/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class ReportedData {
    private final List<Column> columns = new ArrayList<Column>();
    private final List<Row> rows = new ArrayList<Row>();
    private String title = "";

    public static ReportedData getReportedDataFrom(Stanza packet) {
        DataForm dataForm = DataForm.from(packet);
        if (dataForm != null && dataForm.getReportedData() != null) {
            return new ReportedData(dataForm);
        }
        return null;
    }

    private ReportedData(DataForm dataForm) {
        for (FormField formField : dataForm.getReportedData().getFields()) {
            this.columns.add(new Column(formField.getLabel(), formField.getFieldName(), formField.getType()));
        }
        for (DataForm.Item item : dataForm.getItems()) {
            ArrayList<Field> fieldList = new ArrayList<Field>(this.columns.size());
            for (FormField formField : item.getFields()) {
                ArrayList<? extends CharSequence> values2 = new ArrayList<CharSequence>();
                values2.addAll(formField.getValues());
                fieldList.add(new Field(formField.getFieldName(), values2));
            }
            this.rows.add(new Row(fieldList));
        }
        this.title = dataForm.getTitle();
    }

    public ReportedData() {
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public List<Row> getRows() {
        return Collections.unmodifiableList(new ArrayList<Row>(this.rows));
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(new ArrayList<Column>(this.columns));
    }

    public String getTitle() {
        return this.title;
    }

    public static class Field {
        private final String variable;
        private final List<? extends CharSequence> values;

        public Field(String variable, List<? extends CharSequence> values2) {
            this.variable = variable;
            this.values = values2;
        }

        public String getVariable() {
            return this.variable;
        }

        public List<CharSequence> getValues() {
            return Collections.unmodifiableList(this.values);
        }
    }

    public static class Row {
        private List<Field> fields = new ArrayList<Field>();

        public Row(List<Field> fields2) {
            this.fields = fields2;
        }

        public List<CharSequence> getValues(String variable) {
            for (Field field : this.getFields()) {
                if (!variable.equalsIgnoreCase(field.getVariable())) continue;
                return field.getValues();
            }
            return null;
        }

        private List<Field> getFields() {
            return Collections.unmodifiableList(new ArrayList<Field>(this.fields));
        }
    }

    public static class Column {
        private final String label;
        private final String variable;
        private final FormField.Type type;

        public Column(String label, String variable, FormField.Type type2) {
            this.label = label;
            this.variable = variable;
            this.type = type2;
        }

        public String getLabel() {
            return this.label;
        }

        public FormField.Type getType() {
            return this.type;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

