/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public abstract class ActionInvoker {
    private static final RequestProcessor RP = new RequestProcessor("Module-Actions", Integer.MAX_VALUE);

    protected ActionInvoker() {
    }

    protected abstract void invokeAction(Action var1, ActionEvent var2);

    public static void invokeAction(Action action, ActionEvent actionEvent, boolean bl, final Runnable runnable) {
        ActionRunnable actionRunnable = new ActionRunnable(actionEvent, action, bl){

            @Override
            protected void run() {
                if (runnable == null) {
                    this.action.actionPerformed(this.ev);
                } else {
                    runnable.run();
                }
            }
        };
        ActionInvoker.doPerformAction(action, actionRunnable);
    }

    private static void doPerformAction(Action action, final ActionRunnable actionRunnable) {
        assert (EventQueue.isDispatchThread()) : "Action " + action.getClass().getName() + " may not be invoked from the thread " + Thread.currentThread().getName() + ", only the event queue: http://www.netbeans.org/download/4_1/javadoc/OpenAPIs/apichanges.html#actions-event-thread";
        if (actionRunnable.async && !actionRunnable.needsToBeSynchronous()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    actionRunnable.doRun();
                }
            };
            RP.post(runnable);
        } else {
            actionRunnable.run();
        }
    }

    private static abstract class ActionRunnable
    implements Action {
        final ActionEvent ev;
        final Action action;
        final boolean async;

        public ActionRunnable(ActionEvent actionEvent, SystemAction systemAction, boolean bl) {
            this(actionEvent, (Action)systemAction, bl);
        }

        public ActionRunnable(ActionEvent actionEvent, Action action, boolean bl) {
            this.ev = actionEvent;
            this.action = action;
            this.async = bl;
        }

        public static ActionRunnable create(ActionEvent actionEvent, Action action, boolean bl) {
            return new ActionRunnable(actionEvent, action, bl){

                @Override
                protected void run() {
                    this.action.actionPerformed(this.ev);
                }
            };
        }

        public final boolean needsToBeSynchronous() {
            return "waitFinished".equals(this.ev.getActionCommand());
        }

        public final void doRun() {
            ActionInvoker actionInvoker = (ActionInvoker)Lookup.getDefault().lookup(ActionInvoker.class);
            if (actionInvoker != null) {
                actionInvoker.invokeAction(this, this.ev);
            } else {
                this.actionPerformed(this.ev);
            }
        }

        protected abstract void run();

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        @Override
        public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Object getValue(String string) {
            return this.action.getValue(string);
        }

        @Override
        public final boolean isEnabled() {
            return this.action.isEnabled();
        }

        @Override
        public final void putValue(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setEnabled(boolean bl) {
            throw new UnsupportedOperationException();
        }
    }
}

