/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import org.jitsi.srtp.SrtcpCryptoContext;
import org.jitsi.srtp.SrtpCryptoContext;
import org.jitsi.srtp.SrtpPolicy;
import org.jitsi.utils.logging2.Logger;

public class SrtpContextFactory {
    private final byte[] masterKey;
    private final byte[] masterSalt;
    private final boolean sender;
    private final SrtpPolicy srtpPolicy;
    private final SrtpPolicy srtcpPolicy;
    protected final Logger logger;

    public SrtpContextFactory(boolean sender, byte[] masterKey, byte[] masterSalt, SrtpPolicy srtpPolicy, SrtpPolicy srtcpPolicy, Logger parentLogger) {
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        int encKeyLength = srtpPolicy.getEncKeyLength();
        if (encKeyLength != srtcpPolicy.getEncKeyLength()) {
            throw new IllegalArgumentException("srtpPolicy.getEncKeyLength() != srtcpPolicy.getEncKeyLength()");
        }
        if (masterKey != null) {
            if (masterKey.length != encKeyLength) {
                throw new IllegalArgumentException("masterK.length != encKeyLength");
            }
            this.masterKey = new byte[encKeyLength];
            System.arraycopy(masterKey, 0, this.masterKey, 0, encKeyLength);
        } else {
            if (encKeyLength != 0) {
                throw new IllegalArgumentException("null masterK but encKeyLength != 0");
            }
            this.masterKey = new byte[0];
        }
        int saltKeyLength = srtpPolicy.getSaltKeyLength();
        if (saltKeyLength != srtcpPolicy.getSaltKeyLength()) {
            throw new IllegalArgumentException("srtpPolicy.getSaltKeyLength() != srtcpPolicy.getSaltKeyLength()");
        }
        if (masterSalt != null) {
            if (masterSalt.length != saltKeyLength) {
                throw new IllegalArgumentException("masterS.length != saltKeyLength");
            }
            this.masterSalt = new byte[saltKeyLength];
            System.arraycopy(masterSalt, 0, this.masterSalt, 0, saltKeyLength);
        } else {
            if (saltKeyLength != 0) {
                throw new IllegalArgumentException("null masterS but saltKeyLength != 0");
            }
            this.masterSalt = new byte[0];
        }
        this.sender = sender;
        this.srtpPolicy = srtpPolicy;
        this.srtcpPolicy = srtcpPolicy;
    }

    public void close() {
        Arrays.fill(this.masterKey, (byte)0);
        Arrays.fill(this.masterSalt, (byte)0);
    }

    public SrtpCryptoContext deriveContext(int ssrc, int roc) throws GeneralSecurityException {
        return new SrtpCryptoContext(this.sender, ssrc, roc, this.masterKey, this.masterSalt, this.srtpPolicy, this.logger);
    }

    public SrtcpCryptoContext deriveControlContext(int ssrc) throws GeneralSecurityException {
        return new SrtcpCryptoContext(ssrc, this.masterKey, this.masterSalt, this.srtcpPolicy, this.logger);
    }
}

