/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.util.OptionalInt;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class RouteBuildItem
extends MultiBuildItem {
    private final RouteType typeOfRoute;
    private final OptionalInt order;
    private final String path;
    private final Consumer<Route> customizer;
    private final boolean isManagement;
    private final Handler<RoutingContext> handler;
    private final HandlerType typeOfHandler = HandlerType.NORMAL;
    private final boolean displayOnNotFoundPage;
    private final String notFoundPageTitle;
    private final String routeConfigKey;

    public RouteBuildItem(RouteType typeOfRoute, String path, Consumer<Route> customizer, boolean isManagement, Handler<RoutingContext> handler, boolean displayOnNotFoundPage, String notFoundPageTitle, String routeConfigKey, OptionalInt order) {
        this.order = order;
        this.typeOfRoute = typeOfRoute;
        this.path = path;
        this.handler = handler;
        this.displayOnNotFoundPage = displayOnNotFoundPage;
        this.notFoundPageTitle = notFoundPageTitle;
        this.routeConfigKey = routeConfigKey;
        this.customizer = customizer;
        this.isManagement = isManagement;
    }

    public RouteType getTypeOfRoute() {
        return this.typeOfRoute;
    }

    public boolean hasOrder() {
        return this.order.isPresent();
    }

    public int getOrder() {
        if (this.order.isPresent()) {
            return this.order.getAsInt();
        }
        throw new IllegalStateException("No order set");
    }

    public boolean hasRouteConfigKey() {
        return this.routeConfigKey != null;
    }

    public String getRouteConfigKey() {
        return this.routeConfigKey;
    }

    public Handler<RoutingContext> getHandler() {
        return this.handler;
    }

    public HandlerType getHandlerType() {
        return this.typeOfHandler;
    }

    public String getPath() {
        return this.path;
    }

    public Consumer<Route> getCustomizer() {
        return this.customizer;
    }

    public String getNotFoundPageTitle() {
        return this.notFoundPageTitle;
    }

    public boolean isDisplayOnNotFoundPage() {
        return this.displayOnNotFoundPage;
    }

    public static Builder newApplicationRoute(String path) {
        return new Builder(RouteType.APPLICATION_ROUTE, path, false);
    }

    public static Builder newAbsoluteRoute(String path) {
        return new Builder(RouteType.ABSOLUTE_ROUTE, path, false);
    }

    public static Builder newFrameworkRoute(String path) {
        return new Builder(RouteType.FRAMEWORK_ROUTE, path, false);
    }

    public static Builder newManagementRoute(String path) {
        return new Builder(RouteType.FRAMEWORK_ROUTE, path, true);
    }

    public static Builder newManagementRoute(String path, String managementConfigKey) {
        return new Builder(RouteType.FRAMEWORK_ROUTE, path, managementConfigKey == null || RouteBuildItem.isManagement(managementConfigKey));
    }

    private static boolean isManagement(String managementConfigKey) {
        Config config = ConfigProvider.getConfig();
        return (Boolean)config.getValue(managementConfigKey, Boolean.TYPE);
    }

    public boolean isManagement() {
        return this.isManagement;
    }

    public static enum HandlerType {
        NORMAL,
        BLOCKING,
        FAILURE;

    }

    public static enum RouteType {
        FRAMEWORK_ROUTE,
        APPLICATION_ROUTE,
        ABSOLUTE_ROUTE;

    }

    public static class Builder {
        private final RouteType typeOfRoute;
        private OptionalInt order = OptionalInt.empty();
        private final String path;
        private final boolean isManagement;
        private Consumer<Route> customizer;
        private Handler<RoutingContext> handler;
        private HandlerType typeOfHandler = HandlerType.NORMAL;
        private boolean displayOnNotFoundPage;
        private String notFoundPageTitle;
        private String routeConfigKey;

        private Builder(RouteType type, String path, boolean isManagement) {
            this.typeOfRoute = type;
            this.path = path;
            this.isManagement = isManagement;
        }

        public Builder withRouteCustomizer(Consumer<Route> customizer) {
            this.customizer = customizer;
            return this;
        }

        public Builder withOrder(int order) {
            this.order = OptionalInt.of(order);
            return this;
        }

        public Builder withRequestHandler(Handler<RoutingContext> handler) {
            this.handler = handler;
            return this;
        }

        public Builder asBlockingRoute() {
            if (this.typeOfHandler == HandlerType.FAILURE) {
                throw new IllegalArgumentException("A failure route cannot be a blocking route");
            }
            this.typeOfHandler = HandlerType.BLOCKING;
            return this;
        }

        public Builder asFailureRoute() {
            if (this.typeOfHandler == HandlerType.BLOCKING) {
                throw new IllegalArgumentException("A blocking route cannot be a failure route");
            }
            this.typeOfHandler = HandlerType.FAILURE;
            return this;
        }

        public Builder displayOnNotFoundPage() {
            this.displayOnNotFoundPage = true;
            return this;
        }

        public Builder displayOnNotFoundPage(String notFoundPageTitle) {
            this.displayOnNotFoundPage = true;
            this.notFoundPageTitle = notFoundPageTitle;
            return this;
        }

        public Builder withRoutePathConfigKey(String attributeName) {
            this.routeConfigKey = attributeName;
            return this;
        }

        public RouteBuildItem build() {
            if (this.handler == null) {
                throw new IllegalArgumentException("The route handler must be set");
            }
            return new RouteBuildItem(this.typeOfRoute, this.path, this.customizer, this.isManagement, this.handler, this.displayOnNotFoundPage, this.notFoundPageTitle, this.routeConfigKey, this.order);
        }
    }
}

