/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.IdentityHashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.LayoutCallback;
import net.miginfocom.layout.UnitValue;
import net.miginfocom.swing.MigLayout;

public class CallbackDemo
extends JFrame
implements ActionListener,
MouseMotionListener,
MouseListener {
    private final Timer repaintTimer = new Timer(20, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ((JPanel)CallbackDemo.this.getContentPane()).revalidate();
        }
    });
    private final IdentityHashMap<Object, Long> pressMap = new IdentityHashMap();
    private Point mousePos = null;
    private static Font[] FONTS = new Font[120];

    public CallbackDemo() {
        super("MiG Layout Callback Demo");
        MigLayout migLayout = new MigLayout("align center bottom, insets 30");
        final JPanel panel = new JPanel(migLayout){

            protected void paintComponent(Graphics g) {
                ((Graphics2D)g).setPaint(new GradientPaint(0.0f, this.getHeight() / 2, Color.WHITE, 0.0f, this.getHeight(), new Color(240, 238, 235)));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        this.setContentPane(panel);
        migLayout.addLayoutCallback(new LayoutCallback(){

            public BoundSize[] getSize(ComponentWrapper comp) {
                if (comp.getComponent() instanceof JButton) {
                    Component c = (Component)comp.getComponent();
                    Point p = CallbackDemo.this.mousePos != null ? SwingUtilities.convertPoint(panel, CallbackDemo.this.mousePos, c) : new Point(-1000, -1000);
                    float fact = (float)Math.sqrt(Math.pow(Math.abs((float)p.x - (float)c.getWidth() / 2.0f), 2.0) + Math.pow(Math.abs((float)p.y - (float)c.getHeight() / 2.0f), 2.0));
                    fact = Math.max(2.0f - fact / 200.0f, 1.0f);
                    return new BoundSize[]{new BoundSize(new UnitValue(70.0f * fact), ""), new BoundSize(new UnitValue(70.0f * fact), "")};
                }
                return null;
            }

            public void correctBounds(ComponentWrapper c) {
                Long pressedNanos = (Long)CallbackDemo.this.pressMap.get(c.getComponent());
                if (pressedNanos != null) {
                    long duration = System.nanoTime() - pressedNanos;
                    double maxHeight = 100.0 - (double)duration / 1.0E8;
                    int deltaY = (int)Math.round(Math.abs(Math.sin((double)duration / 3.0E8) * maxHeight));
                    c.setBounds(c.getX(), c.getY() - deltaY, c.getWidth(), c.getHeight());
                    if (maxHeight < 0.5) {
                        CallbackDemo.this.pressMap.remove(c.getComponent());
                        if (CallbackDemo.this.pressMap.size() == 0) {
                            CallbackDemo.this.repaintTimer.stop();
                        }
                    }
                }
            }
        });
        for (int j = 0; j < 10; ++j) {
            panel.add((Component)this.createButton(j), "aligny 0.8al");
        }
        JLabel label = new JLabel("Can't you just feel the urge to press one of those Swing JButtons?");
        label.setFont(new Font("verdana", 0, 24));
        label.setForeground(new Color(150, 150, 150));
        panel.add((Component)label, "pos 0.5al 0.2al");
        panel.addMouseMotionListener(this);
        panel.addMouseListener(this);
    }

    private JButton createButton(int i) {
        JButton button = new JButton(String.valueOf("MIG LAYOUT".charAt(i))){

            public Font getFont() {
                if (FONTS[0] == null) {
                    for (int i = 0; i < FONTS.length; ++i) {
                        FONTS[i] = new Font("tahoma", 0, i);
                    }
                }
                return FONTS[this.getWidth() >> 1];
            }
        };
        button.setForeground(new Color(100, 100, 100));
        button.setFocusPainted(false);
        button.addMouseMotionListener(this);
        button.addActionListener(this);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.mousePos = e.getSource() instanceof JButton ? SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.getContentPane()) : e.getPoint();
        ((JPanel)this.getContentPane()).revalidate();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.mousePos = null;
        ((JPanel)this.getContentPane()).revalidate();
    }

    public void actionPerformed(ActionEvent e) {
        this.pressMap.put(e.getSource(), System.nanoTime());
        this.repaintTimer.start();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        CallbackDemo demoFrame = new CallbackDemo();
        demoFrame.setDefaultCloseOperation(3);
        demoFrame.setSize(970, 500);
        demoFrame.setLocationRelativeTo(null);
        demoFrame.setVisible(true);
    }
}

