/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.openide.util.lookup.MetaInfServicesLookup;

final class MetaInfCache {
    private int knownInstancesCount;
    private final List<Reference<Object>> knownInstances = new ArrayList<Reference<Object>>();

    public MetaInfCache(int n) {
        for (int i = 0; i < n; ++i) {
            this.knownInstances.add(null);
        }
    }

    public synchronized Object findInstance(Class<?> clazz) {
        Reference<Object> reference;
        int n = this.knownInstances.size();
        int n2 = MetaInfCache.hashForClass(clazz, n);
        for (int i = 0; i < n && (reference = this.knownInstances.get(n2)) != null; ++i) {
            Object object = reference.get();
            if (object != null && clazz == object.getClass()) {
                return object;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public synchronized void storeInstance(Object object) {
        this.hashPut(object);
        int n = this.knownInstances.size();
        if (this.knownInstancesCount > n * 2 / 3) {
            MetaInfServicesLookup.LOGGER.log(Level.CONFIG, "Cache of size {0} is 2/3 full. Rehashing.", n);
            MetaInfCache metaInfCache = new MetaInfCache(n * 2);
            for (Reference<Object> reference : this.knownInstances) {
                Object object2;
                if (reference == null || (object2 = reference.get()) == null) continue;
                metaInfCache.storeInstance(object2);
            }
            this.knownInstances.clear();
            this.knownInstances.addAll(metaInfCache.knownInstances);
            this.knownInstancesCount = metaInfCache.knownInstancesCount;
        }
    }

    private void hashPut(Object object) {
        assert (Thread.holdsLock(this));
        Class<?> clazz = object.getClass();
        int n = this.knownInstances.size();
        int n2 = MetaInfCache.hashForClass(clazz, n);
        for (int i = 0; i < n; ++i) {
            Object object2;
            Reference<Object> reference = this.knownInstances.get(n2);
            Object object3 = object2 = reference == null ? null : reference.get();
            if (object2 == null) {
                this.knownInstances.set(n2, new WeakReference<Object>(object));
                ++this.knownInstancesCount;
                break;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
    }

    private static int hashForClass(Class<?> clazz, int n) {
        return Math.abs(clazz.hashCode() % n);
    }
}

