/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.copymoveresultfilenames;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileUtil;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.copymoveresultfilenames.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryCopyMoveResultFilenames
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String foldername;
    private boolean specifywildcard;
    private String wildcard;
    private String wildcardexclude;
    private String destination_folder;
    private String nr_errors_less_than;
    public String SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private String success_condition;
    private boolean add_date;
    private boolean add_time;
    private boolean SpecifyFormat;
    private String date_time_format;
    private boolean AddDateBeforeExtension;
    private String action;
    private boolean OverwriteFile;
    private boolean CreateDestinationFolder;
    boolean RemovedSourceFilename;
    boolean AddDestinationFilename;
    int NrErrors = 0;
    private int NrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int limitFiles = 0;

    public JobEntryCopyMoveResultFilenames(String n) {
        super(n, "");
        this.RemovedSourceFilename = true;
        this.AddDestinationFilename = true;
        this.CreateDestinationFolder = false;
        this.foldername = null;
        this.wildcardexclude = null;
        this.wildcard = null;
        this.specifywildcard = false;
        this.OverwriteFile = false;
        this.add_date = false;
        this.add_time = false;
        this.SpecifyFormat = false;
        this.date_time_format = null;
        this.AddDateBeforeExtension = false;
        this.destination_folder = null;
        this.nr_errors_less_than = "10";
        this.action = "copy";
        this.success_condition = this.SUCCESS_IF_NO_ERRORS;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.COPY_MOVE_RESULT_FILENAMES);
    }

    public JobEntryCopyMoveResultFilenames() {
        this("");
    }

    public JobEntryCopyMoveResultFilenames(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryCopyMoveResultFilenames je = (JobEntryCopyMoveResultFilenames)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"foldername", (String)this.foldername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"specify_wildcard", (boolean)this.specifywildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcardexclude", (String)this.wildcardexclude));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destination_folder", (String)this.destination_folder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_less_than", (String)this.nr_errors_less_than));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.add_date));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.add_time));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"action", (String)this.action));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddDateBeforeExtension", (boolean)this.AddDateBeforeExtension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"OverwriteFile", (boolean)this.OverwriteFile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"CreateDestinationFolder", (boolean)this.CreateDestinationFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"RemovedSourceFilename", (boolean)this.RemovedSourceFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddDestinationFilename", (boolean)this.AddDestinationFilename));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.foldername = XMLHandler.getTagValue((Node)entrynode, (String)"foldername");
            this.specifywildcard = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"specify_wildcard"));
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.wildcardexclude = XMLHandler.getTagValue((Node)entrynode, (String)"wildcardexclude");
            this.destination_folder = XMLHandler.getTagValue((Node)entrynode, (String)"destination_folder");
            this.nr_errors_less_than = XMLHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.add_date = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.add_time = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.AddDateBeforeExtension = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddDateBeforeExtension"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.action = XMLHandler.getTagValue((Node)entrynode, (String)"action");
            this.OverwriteFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"OverwriteFile"));
            this.CreateDestinationFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"CreateDestinationFolder"));
            this.RemovedSourceFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"RemovedSourceFilename"));
            this.AddDestinationFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddDestinationFilename"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobEntryCopyMoveResultFilenames.CanNotLoadFromXML", xe.getMessage()));
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.foldername = rep.getJobEntryAttributeString(id_jobentry, "foldername");
            this.specifywildcard = rep.getJobEntryAttributeBoolean(id_jobentry, "specify_wildcard");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.wildcardexclude = rep.getJobEntryAttributeString(id_jobentry, "wildcardexclude");
            this.destination_folder = rep.getJobEntryAttributeString(id_jobentry, "destination_folder");
            this.nr_errors_less_than = rep.getJobEntryAttributeString(id_jobentry, "nr_errors_less_than");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            this.add_date = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.add_time = rep.getJobEntryAttributeBoolean(id_jobentry, "add_time");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.AddDateBeforeExtension = rep.getJobEntryAttributeBoolean(id_jobentry, "AddDateBeforeExtension");
            this.action = rep.getJobEntryAttributeString(id_jobentry, "action");
            this.OverwriteFile = rep.getJobEntryAttributeBoolean(id_jobentry, "OverwriteFile");
            this.CreateDestinationFolder = rep.getJobEntryAttributeBoolean(id_jobentry, "CreateDestinationFolder");
            this.RemovedSourceFilename = rep.getJobEntryAttributeBoolean(id_jobentry, "RemovedSourceFilename");
            this.AddDestinationFilename = rep.getJobEntryAttributeBoolean(id_jobentry, "AddDestinationFilename");
        }
        catch (KettleException dbe) {
            throw new KettleXMLException(Messages.getString("JobEntryCopyMoveResultFilenames.CanNotLoadFromRep", "" + id_jobentry, dbe.getMessage()));
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "foldername", this.foldername);
            rep.saveJobEntryAttribute(id_job, this.getID(), "specify_wildcard", this.specifywildcard);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcardexclude", this.wildcardexclude);
            rep.saveJobEntryAttribute(id_job, this.getID(), "destination_folder", this.destination_folder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "nr_errors_less_than", this.nr_errors_less_than);
            rep.saveJobEntryAttribute(id_job, this.getID(), "success_condition", this.success_condition);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_date", this.add_date);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_time", this.add_time);
            rep.saveJobEntryAttribute(id_job, this.getID(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getID(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getID(), "AddDateBeforeExtension", this.AddDateBeforeExtension);
            rep.saveJobEntryAttribute(id_job, this.getID(), "action", this.action);
            rep.saveJobEntryAttribute(id_job, this.getID(), "OverwriteFile", this.OverwriteFile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "CreateDestinationFolder", this.CreateDestinationFolder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "RemovedSourceFilename", this.RemovedSourceFilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "AddDestinationFilename", this.AddDestinationFilename);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleXMLException(Messages.getString("JobEntryCopyMoveResultFilenames.CanNotSaveToRep", "" + id_job, dbe.getMessage()));
        }
    }

    public void setSpecifyWildcard(boolean specifywildcard) {
        this.specifywildcard = specifywildcard;
    }

    public boolean isSpecifyWildcard() {
        return this.specifywildcard;
    }

    public void setFoldername(String foldername) {
        this.foldername = foldername;
    }

    public String getFoldername() {
        return this.foldername;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getWildcardExclude() {
        return this.wildcardexclude;
    }

    public String getRealWildcard() {
        return this.environmentSubstitute(this.getWildcard());
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setWildcardExclude(String wildcardexclude) {
        this.wildcardexclude = wildcardexclude;
    }

    public void setAddDate(boolean adddate) {
        this.add_date = adddate;
    }

    public boolean isAddDate() {
        return this.add_date;
    }

    public void setAddTime(boolean addtime) {
        this.add_time = addtime;
    }

    public boolean isAddTime() {
        return this.add_time;
    }

    public void setAddDateBeforeExtension(boolean AddDateBeforeExtension) {
        this.AddDateBeforeExtension = AddDateBeforeExtension;
    }

    public boolean isAddDateBeforeExtension() {
        return this.AddDateBeforeExtension;
    }

    public boolean isOverwriteFile() {
        return this.OverwriteFile;
    }

    public void setOverwriteFile(boolean OverwriteFile) {
        this.OverwriteFile = OverwriteFile;
    }

    public void setCreateDestinationFolder(boolean CreateDestinationFolder) {
        this.CreateDestinationFolder = CreateDestinationFolder;
    }

    public boolean isCreateDestinationFolder() {
        return this.CreateDestinationFolder;
    }

    public boolean isRemovedSourceFilename() {
        return this.RemovedSourceFilename;
    }

    public void setRemovedSourceFilename(boolean RemovedSourceFilename) {
        this.RemovedSourceFilename = RemovedSourceFilename;
    }

    public void setAddDestinationFilename(boolean AddDestinationFilename) {
        this.AddDestinationFilename = AddDestinationFilename;
    }

    public boolean isAddDestinationFilename() {
        return this.AddDestinationFilename;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public void setDestinationFolder(String destinationFolder) {
        this.destination_folder = destinationFolder;
    }

    public String getDestinationFolder() {
        return this.destination_folder;
    }

    public void setNrErrorsLessThan(String nr_errors_less_than) {
        this.nr_errors_less_than = nr_errors_less_than;
    }

    public String getNrErrorsLessThan() {
        return this.nr_errors_less_than;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        block16: {
            log = LogWriter.getInstance();
            result = previousResult;
            result.setNrErrors(1L);
            result.setResult(false);
            realdestinationFolder = this.environmentSubstitute(this.getDestinationFolder());
            if (!this.CreateDestinationFolder(realdestinationFolder, log)) {
                return result;
            }
            if (previousResult != null) {
                this.NrErrors = 0;
                this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getNrErrorsLessThan()), (int)10);
                this.NrErrors = 0;
                this.NrSuccess = 0;
                this.successConditionBroken = false;
                this.successConditionBrokenExit = false;
                file = null;
                try {
                    try {
                        size = result.getResultFiles().size();
                        if (log.isBasic()) {
                            log.logBasic(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.log.FilesFound", "" + size), new Object[0]);
                        }
                        if ((resultFiles = result.getResultFilesList()) != null && resultFiles.size() > 0) {
                            it = resultFiles.iterator();
                            while (it.hasNext() && !parentJob.isStopped()) {
                                if (this.successConditionBroken) {
                                    log.logError(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.Error.SuccessConditionbroken", "" + this.NrErrors), new Object[0]);
                                    throw new Exception(Messages.getString("JobEntryCopyMoveResultFilenames.Error.SuccessConditionbroken", "" + this.NrErrors));
                                }
                                resultFile = (ResultFile)it.next();
                                file = resultFile.getFile();
                                if (file != null && file.exists()) {
                                    if (this.specifywildcard && (!this.CheckFileWildcard(file.getName().getBaseName(), this.environmentSubstitute(this.wildcard), true) || this.CheckFileWildcard(file.getName().getBaseName(), this.environmentSubstitute(this.wildcardexclude), false) || !this.specifywildcard) || this.ProcessFile(file, realdestinationFolder, log, result, parentJob)) continue;
                                    this.updateErrors();
                                    continue;
                                }
                                log.logError(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.log.ErrorCanNotFindFile", file.toString()), new Object[0]);
                                this.updateErrors();
                            }
                        }
                        var14_14 = null;
                        if (file == null) break block16;
                    }
                    catch (Exception e) {
                        log.logError(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.Error", e.toString()), new Object[0]);
                        var14_15 = null;
                        if (file != null) {
                            try {
                                file.close();
                            }
                            catch (Exception ex) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable var13_20) {
                    var14_16 = null;
                    if (file == null) throw var13_20;
                    ** try [egrp 2[TRYBLOCK] [4 : 492->502)] { 
lbl54:
                    // 1 sources

                    file.close();
                    throw var13_20;
lbl56:
                    // 1 sources

                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw var13_20;
                }
                try {}
                catch (Exception ex) {}
                file.close();
            }
        }
        result.setNrErrors((long)this.NrErrors);
        result.setNrLinesWritten((long)this.NrSuccess);
        if (this.getSuccessStatus() == false) return result;
        result.setResult(true);
        return result;
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrSuccess >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED) || this.NrErrors <= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean CreateDestinationFolder(String foldername, LogWriter log) {
        block17: {
            block18: {
                block15: {
                    block16: {
                        folder = null;
                        folder = KettleVFS.getFileObject((String)foldername);
                        if (folder.exists()) ** GOTO lbl25
                        log.logError(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.Log.FolderNotExists", foldername), new Object[0]);
                        if (this.isCreateDestinationFolder()) {
                            folder.createFolder();
                            break block15;
                        }
                        var4_4 = false;
                        var6_7 = null;
                        if (folder == null) break block16;
                        try {
                            folder.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    return var4_4;
                }
                if (log.isBasic()) {
                    log.logBasic(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.Log.FolderCreated", foldername), new Object[0]);
                }
                break block18;
lbl25:
                // 1 sources

                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.Log.FolderExists", foldername), new Object[0]);
                }
            }
            var4_5 = true;
            var6_8 = null;
            if (folder == null) break block17;
            try {
                folder.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return var4_5;
        catch (Exception e) {
            try {
                log.logError(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.Log.CanNotCreatedFolder", foldername, e.toString()), new Object[0]);
                var6_9 = null;
                ** if (folder == null) goto lbl-1000
            }
            catch (Throwable var5_15) {
                var6_10 = null;
                if (folder != null) {
                    try {
                        folder.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                throw var5_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    folder.close();
                }
                catch (Exception ex) {}
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        return false;
    }

    private boolean ProcessFile(FileObject sourcefile, String destinationFolder, LogWriter log, Result result, Job parentJob) {
        boolean retval = false;
        boolean filexists = false;
        try {
            String shortfilename = this.getDestinationFilename(sourcefile.getName().getBaseName());
            String destinationFilename = destinationFolder + Const.FILE_SEPARATOR + shortfilename;
            FileObject destinationfile = KettleVFS.getFileObject((String)destinationFilename);
            filexists = destinationfile.exists();
            if (filexists && log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.Log.FileExists", destinationFilename), new Object[0]);
            }
            if (!filexists || filexists && this.isOverwriteFile()) {
                if (this.getAction().equals("copy")) {
                    FileUtil.copyContent((FileObject)sourcefile, (FileObject)destinationfile);
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.log.CopiedFile", sourcefile.toString(), destinationFolder), new Object[0]);
                    }
                } else {
                    sourcefile.moveTo(destinationfile);
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.log.MovedFile", sourcefile.toString(), destinationFolder), new Object[0]);
                    }
                }
                if (this.isRemovedSourceFilename()) {
                    result.getResultFiles().remove(sourcefile.toString());
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.RemovedFileFromResult", sourcefile.toString()), new Object[0]);
                    }
                }
                if (this.isAddDestinationFilename()) {
                    ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)destinationfile.toString()), parentJob.getJobname(), this.toString());
                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.AddedFileToResult", destinationfile.toString()), new Object[0]);
                    }
                }
            }
            retval = true;
        }
        catch (Exception e) {
            log.logError(this.toString(), Messages.getString("JobEntryCopyMoveResultFilenames.Log.ErrorProcessing", e.toString()), new Object[0]);
        }
        return retval;
    }

    private String getDestinationFilename(String shortsourcefilename) throws Exception {
        String shortfilename = shortsourcefilename;
        int lenstring = shortsourcefilename.length();
        int lastindexOfDot = shortfilename.lastIndexOf(46);
        if (this.isAddDateBeforeExtension()) {
            shortfilename = shortfilename.substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.isSpecifyFormat() && !Const.isEmpty((String)this.getDateTimeFormat())) {
            daf.applyPattern(this.getDateTimeFormat());
            String dt = daf.format(now);
            shortfilename = shortfilename + dt;
        } else {
            if (this.isAddDate()) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                shortfilename = shortfilename + "_" + d;
            }
            if (this.isAddTime()) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                shortfilename = shortfilename + "_" + t;
            }
        }
        if (this.isAddDateBeforeExtension()) {
            shortfilename = shortfilename + shortsourcefilename.substring(lastindexOfDot, lenstring);
        }
        return shortfilename;
    }

    private boolean CheckFileWildcard(String selectedfile, String wildcard, boolean include) {
        Pattern pattern = null;
        boolean getIt = include;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileDoesNotExistValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, ctx);
    }
}

