/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaVirtualAllocationInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int PUSERDATA;

    public VmaVirtualAllocationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaVirtualAllocationInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VmaVirtualAllocationInfo.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VmaVirtualAllocationInfo.nsize(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VmaVirtualAllocationInfo.npUserData(this.address());
    }

    public static VmaVirtualAllocationInfo malloc() {
        return (VmaVirtualAllocationInfo)VmaVirtualAllocationInfo.wrap(VmaVirtualAllocationInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaVirtualAllocationInfo calloc() {
        return (VmaVirtualAllocationInfo)VmaVirtualAllocationInfo.wrap(VmaVirtualAllocationInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaVirtualAllocationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaVirtualAllocationInfo)VmaVirtualAllocationInfo.wrap(VmaVirtualAllocationInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaVirtualAllocationInfo create(long address) {
        return (VmaVirtualAllocationInfo)VmaVirtualAllocationInfo.wrap(VmaVirtualAllocationInfo.class, (long)address);
    }

    @Nullable
    public static VmaVirtualAllocationInfo createSafe(long address) {
        return address == 0L ? null : (VmaVirtualAllocationInfo)VmaVirtualAllocationInfo.wrap(VmaVirtualAllocationInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VmaVirtualAllocationInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VmaVirtualAllocationInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VmaVirtualAllocationInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaVirtualAllocationInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VmaVirtualAllocationInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VmaVirtualAllocationInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VmaVirtualAllocationInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VmaVirtualAllocationInfo malloc(MemoryStack stack) {
        return (VmaVirtualAllocationInfo)VmaVirtualAllocationInfo.wrap(VmaVirtualAllocationInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaVirtualAllocationInfo calloc(MemoryStack stack) {
        return (VmaVirtualAllocationInfo)VmaVirtualAllocationInfo.wrap(VmaVirtualAllocationInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaVirtualAllocationInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaVirtualAllocationInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PUSERDATA));
    }

    static {
        Struct.Layout layout = VmaVirtualAllocationInfo.__struct((Struct.Member[])new Struct.Member[]{VmaVirtualAllocationInfo.__member((int)8), VmaVirtualAllocationInfo.__member((int)8), VmaVirtualAllocationInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        PUSERDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaVirtualAllocationInfo, Buffer>
    implements NativeResource {
        private static final VmaVirtualAllocationInfo ELEMENT_FACTORY = VmaVirtualAllocationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaVirtualAllocationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VmaVirtualAllocationInfo.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VmaVirtualAllocationInfo.nsize(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VmaVirtualAllocationInfo.npUserData(this.address());
        }
    }
}

