/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.elements;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.refactoring.java.ui.elements.DescriptionFilter;
import org.openide.explorer.view.CheckableNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ElementNode
extends AbstractNode {
    private static Node WAIT_NODE;
    private Description description;
    private final DescriptionFilter filters;
    private static final InstanceContent.Convertor<Description, TreePathHandle> ConvertDescription2TreePathHandle;
    private static final InstanceContent.Convertor<Description, FileObject> ConvertDescription2FileObject;
    private static final InstanceContent.Convertor<Description, DataObject> ConvertDescription2DataObject;

    public ElementNode(Description description, DescriptionFilter filters, ChangeListener listener) {
        super((Children)(description.subs == null ? Children.LEAF : new ElementChilren(description.subs, filters, listener)), description.elementHandle == null ? null : ElementNode.prepareLookup(description, listener));
        this.filters = filters;
        this.description = description;
        this.setDisplayName(description.name);
    }

    public Image getIcon(int type) {
        return this.description.kind == null ? super.getIcon(type) : ImageUtilities.icon2Image((Icon)ElementIcons.getElementIcon((ElementKind)this.description.kind, this.description.modifiers));
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getDisplayName() {
        if (this.description.name != null) {
            return this.description.name;
        }
        return null;
    }

    public String getHtmlDisplayName() {
        return this.description.htmlHeader;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        return null;
    }

    public Transferable drag() throws IOException {
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
    }

    public static synchronized Node getWaitNode() {
        if (WAIT_NODE == null) {
            WAIT_NODE = new WaitNode();
        }
        return WAIT_NODE;
    }

    public void refreshRecursively() {
        Children ch = this.getChildren();
        if (ch instanceof ElementChilren) {
            ((ElementChilren)ch).resetKeys(this.description.subs, this.filters);
            for (Node sub : ch.getNodes()) {
                ((ElementNode)sub).refreshRecursively();
            }
        }
    }

    public ElementNode getNodeForElement(ElementHandle<Element> eh) {
        if (this.getDescription().elementHandle != null && eh.signatureEquals(this.getDescription().elementHandle)) {
            return this;
        }
        Children ch = this.getChildren();
        if (ch instanceof ElementChilren) {
            for (Node sub : ch.getNodes()) {
                ElementNode result = ((ElementNode)sub).getNodeForElement(eh);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }

    public void updateRecursively(Description newDescription) {
        Children ch = this.getChildren();
        if (ch instanceof ElementChilren) {
            HashSet<Description> oldSubs = new HashSet<Description>(this.description.subs);
            Node[] nodes = ch.getNodes(true);
            HashMap<Description, ElementNode> oldD2node = new HashMap<Description, ElementNode>();
            for (Node node : nodes) {
                oldD2node.put(((ElementNode)node).description, (ElementNode)node);
            }
            ((ElementChilren)ch).resetKeys(newDescription.subs, this.filters);
            nodes = ch.getNodes(true);
            for (Description newSub : newDescription.subs) {
                ElementNode node = (ElementNode)((Object)oldD2node.get(newSub));
                if (node == null) continue;
                node.updateRecursively(newSub);
            }
        }
        Description oldDescription = this.description;
        this.description = newDescription;
        if (oldDescription.htmlHeader != null && !oldDescription.htmlHeader.equals(this.description.htmlHeader)) {
            this.fireDisplayNameChange(oldDescription.htmlHeader, this.description.htmlHeader);
        }
        if (oldDescription.modifiers != null && !oldDescription.modifiers.equals(newDescription.modifiers)) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
    }

    public void selectionChanged() {
        this.fireIconChange();
    }

    public Description getDescription() {
        return this.description;
    }

    private static Lookup prepareLookup(final Description description, final ChangeListener listener) {
        InstanceContent ic = new InstanceContent();
        ic.add((Object)description, ConvertDescription2TreePathHandle);
        ic.add((Object)description, ConvertDescription2FileObject);
        ic.add((Object)description, ConvertDescription2DataObject);
        ic.add((Object)new CheckableNode(){

            public boolean isCheckable() {
                return true;
            }

            public boolean isCheckEnabled() {
                return true;
            }

            public Boolean isSelected() {
                return description.selected;
            }

            public void setSelected(Boolean selected) {
                description.selected = selected;
                listener.stateChanged(new ChangeEvent(this));
            }
        });
        return new AbstractLookup((AbstractLookup.Content)ic);
    }

    static {
        ConvertDescription2TreePathHandle = new InstanceContent.Convertor<Description, TreePathHandle>(){

            public TreePathHandle convert(Description obj) {
                return TreePathHandle.from(obj.elementHandle, (ClasspathInfo)obj.cpInfo);
            }

            public Class<? extends TreePathHandle> type(Description obj) {
                return TreePathHandle.class;
            }

            public String id(Description obj) {
                return "IL[" + obj.toString();
            }

            public String displayName(Description obj) {
                return this.id(obj);
            }
        };
        ConvertDescription2FileObject = new InstanceContent.Convertor<Description, FileObject>(){

            public FileObject convert(Description d) {
                return d.getFileObject();
            }

            public Class<? extends FileObject> type(Description obj) {
                return FileObject.class;
            }

            public String id(Description obj) {
                return "IL[" + obj.toString();
            }

            public String displayName(Description obj) {
                return this.id(obj);
            }
        };
        ConvertDescription2DataObject = new InstanceContent.Convertor<Description, DataObject>(){

            public DataObject convert(Description d) {
                try {
                    FileObject fo = d.getFileObject();
                    return fo == null ? null : DataObject.find((FileObject)fo);
                }
                catch (DataObjectNotFoundException ex) {
                    return null;
                }
            }

            public Class<? extends DataObject> type(Description obj) {
                return DataObject.class;
            }

            public String id(Description obj) {
                return "IL[" + obj.toString();
            }

            public String displayName(Description obj) {
                return this.id(obj);
            }
        };
    }

    public static class Description {
        public static final Comparator<Description> ALPHA_COMPARATOR = new DescriptionComparator(true);
        public static final Comparator<Description> POSITION_COMPARATOR = new DescriptionComparator(false);
        private final String name;
        private final ElementHandle<? extends Element> elementHandle;
        private final ElementKind kind;
        private Set<Modifier> modifiers;
        private Collection<Description> subs;
        private String htmlHeader;
        private long pos;
        private boolean inherited;
        private boolean constructor;
        private ClasspathInfo cpInfo;
        private Boolean selected;

        public Description() {
            this.name = null;
            this.elementHandle = null;
            this.kind = null;
            this.inherited = false;
            this.selected = Boolean.FALSE;
        }

        public Description(@NonNull String name, @NonNull ElementHandle<? extends Element> elementHandle, @NonNull ElementKind kind, boolean inherited) {
            assert (name != null);
            assert (elementHandle != null);
            assert (kind != null);
            this.name = name;
            this.elementHandle = elementHandle;
            this.kind = kind;
            this.inherited = inherited;
            this.selected = Boolean.FALSE;
        }

        public FileObject getFileObject() {
            return SourceUtils.getFile(this.elementHandle, (ClasspathInfo)this.cpInfo);
        }

        public boolean isInherited() {
            return this.inherited;
        }

        public void setIsInherited(boolean isInherited) {
            this.inherited = isInherited;
        }

        public boolean isConstructor() {
            return this.constructor;
        }

        public void setIsConstructor(boolean isConstructor) {
            this.constructor = isConstructor;
        }

        public Collection<Description> getSubs() {
            return this.subs;
        }

        public void setSubs(Collection<Description> subs) {
            this.subs = subs;
        }

        public ElementHandle<? extends Element> getElementHandle() {
            return this.elementHandle;
        }

        public ClasspathInfo getCpInfo() {
            return this.cpInfo;
        }

        public void setCpInfo(ClasspathInfo cpInfo) {
            this.cpInfo = cpInfo;
        }

        public String getHtmlHeader() {
            return this.htmlHeader;
        }

        public void setHtmlHeader(String htmlHeader) {
            this.htmlHeader = htmlHeader;
        }

        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        public void setModifiers(Set<Modifier> modifiers) {
            this.modifiers = modifiers;
        }

        public long getPos() {
            return this.pos;
        }

        public void setPos(long pos) {
            this.pos = pos;
        }

        public Boolean getSelected() {
            return this.selected;
        }

        public void setSelected(Boolean selected) {
            this.selected = selected;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Description)) {
                return false;
            }
            Description d = (Description)o;
            if (this.kind != d.kind) {
                return false;
            }
            if (!(this.name == d.name || this.name != null && this.name.equals(d.name))) {
                return false;
            }
            return this.elementHandle == d.elementHandle || this.elementHandle != null && this.elementHandle.equals(d.elementHandle);
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 29 * hash + (this.kind != null ? this.kind.hashCode() : 0);
            return hash;
        }

        private static class DescriptionComparator
        implements Comparator<Description> {
            boolean alpha;

            DescriptionComparator(boolean alpha) {
                this.alpha = alpha;
            }

            @Override
            public int compare(Description d1, Description d2) {
                if (this.alpha) {
                    return this.alphaCompare(d1, d2);
                }
                if (d1.inherited && !d2.inherited) {
                    return 1;
                }
                if (!d1.inherited && d2.inherited) {
                    return -1;
                }
                if (d1.inherited && d2.inherited) {
                    return this.alphaCompare(d1, d2);
                }
                return d1.pos == d2.pos ? 0 : (d1.pos < d2.pos ? -1 : 1);
            }

            int alphaCompare(Description d1, Description d2) {
                if (this.k2i(d1.kind) != this.k2i(d2.kind)) {
                    return this.k2i(d1.kind) - this.k2i(d2.kind);
                }
                return d1.name.compareTo(d2.name);
            }

            int k2i(ElementKind kind) {
                switch (kind) {
                    case CONSTRUCTOR: {
                        return 1;
                    }
                    case METHOD: {
                        return 2;
                    }
                    case FIELD: {
                        return 3;
                    }
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        return 4;
                    }
                }
                return 100;
            }
        }
    }

    private static final class ElementChilren
    extends Children.Keys<Description> {
        private final DescriptionFilter filters;
        private final ChangeListener listener;

        public ElementChilren(Collection<Description> descriptions, DescriptionFilter filters, ChangeListener listener) {
            this.filters = filters;
            this.listener = listener;
            this.resetKeys(descriptions, filters);
        }

        protected Node[] createNodes(Description key) {
            return new Node[]{new ElementNode(key, this.filters, this.listener)};
        }

        void resetKeys(Collection<Description> descriptions, DescriptionFilter filters) {
            this.setKeys(filters.filter(descriptions));
        }
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/refactoring/java/resources/wait.gif");

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int type) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ElementNode.class, (String)"LBL_WaitNode");
        }
    }
}

