/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.policy;

import com.oracle.bmc.identity.model.Policy;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PolicyParser {
    private static final List<String> OVER_PERMISSIVE_KEYWORDS = List.of("all-resources", "in tenancy", "manage policies", "manage groups", "manage identity", "manage virtual-network-family", "manage database-family");

    public static List<String> getAllStatementsFrom(List<Policy> policies) {
        return policies.stream().flatMap(i -> i.getStatements().stream()).collect(Collectors.toList());
    }

    public static List<String> filterOverpermissiveStatements(List<String> statements) {
        ArrayList<String> overpermissive = new ArrayList<String>();
        for (String statement : statements) {
            for (String keyword : OVER_PERMISSIVE_KEYWORDS) {
                if (!PolicyParser.prepareForComparing(statement).contains(PolicyParser.prepareForComparing(keyword))) continue;
                overpermissive.add(statement);
            }
        }
        return overpermissive;
    }

    public static List<String> removeWhitespacesFromStatements(List<String> statements) {
        return statements.stream().map(PolicyParser::prepareForComparing).collect(Collectors.toList());
    }

    public static String prepareForComparing(String statementPart) {
        return statementPart.replaceAll("\\s+", "").toLowerCase();
    }
}

