/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.facesmodel.JsfVersionUtils;
import org.netbeans.modules.web.jsf.wizards.CompositeComponentWizardPanel;
import org.netbeans.modules.web.jsfapi.api.JsfVersion;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public final class CompositeComponentWizardIterator
implements TemplateWizard.Iterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;
    private String selectedText;
    private static final String RESOURCES_FOLDER = "resources";
    private static final String COMPONENT_FOLDER = "ezcomp";

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        Project project;
        WebModule webModule;
        DataObject result = null;
        String targetName = Templates.getTargetName((WizardDescriptor)this.wizard);
        FileObject targetDir = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        DataFolder df = DataFolder.findFolder((FileObject)targetDir);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        DataObject dTemplate = DataObject.find((FileObject)template);
        HashMap<String, Object> templateProperties = new HashMap<String, Object>();
        if (this.selectedText != null) {
            templateProperties.put("implementation", this.selectedText);
        }
        if ((webModule = WebModule.getWebModule((FileObject)(project = Templates.getProject((WizardDescriptor)this.wizard)).getProjectDirectory())) != null) {
            JsfVersion version = JsfVersionUtils.forWebModule(webModule);
            if (version != null && version.isAtLeast(JsfVersion.JSF_4_1)) {
                templateProperties.put("isJSF41", Boolean.TRUE);
            } else if (version != null && version.isAtLeast(JsfVersion.JSF_4_0)) {
                templateProperties.put("isJSF40", Boolean.TRUE);
            } else if (version != null && version.isAtLeast(JsfVersion.JSF_3_0)) {
                templateProperties.put("isJSF30", Boolean.TRUE);
            } else if (version != null && version.isAtLeast(JsfVersion.JSF_2_2)) {
                templateProperties.put("isJSF22", Boolean.TRUE);
            }
        }
        result = dTemplate.createFromTemplate(df, targetName, templateProperties);
        return Collections.singleton(result);
    }

    public void initialize(TemplateWizard wizard) {
        this.wizard = wizard;
        this.selectedText = (String)wizard.getProperty("selectedText");
        Project project = Templates.getProject((WizardDescriptor)wizard);
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroups = sources.getSourceGroups("doc_root");
        if (sourceGroups == null || sourceGroups.length == 0) {
            sourceGroups = sources.getSourceGroups("generic");
        }
        FileObject targetFolder = null;
        FileObject resourceFolder = sourceGroups[0].getRootFolder().getFileObject(RESOURCES_FOLDER);
        if (resourceFolder != null) {
            FileObject componentFolder = resourceFolder.getFileObject(COMPONENT_FOLDER);
            targetFolder = componentFolder != null ? componentFolder : resourceFolder;
        }
        if (targetFolder != null) {
            Templates.setTargetFolder((WizardDescriptor)wizard, targetFolder);
        }
        CompositeComponentWizardPanel folderPanel = new CompositeComponentWizardPanel(wizard, sourceGroups, this.selectedText);
        this.panels = new WizardDescriptor.Panel[]{folderPanel};
        Object prop = wizard.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = Utilities.createSteps((String[])beforeSteps, (WizardDescriptor.Panel[])this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jc = (JComponent)this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = jc.getName();
            }
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return "" + this.index + 1 + ". " + NbBundle.getMessage(CompositeComponentWizardIterator.class, (String)"MSG_From") + this.panels.length;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

