/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.xerces;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.AbstractSchemaReader;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.validate.xerces.SAXXMLErrorHandler;
import com.thaiopensource.validate.xerces.SchemaImpl;
import com.thaiopensource.validate.xerces.ValidatorImpl;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.sax.SAXSource;
import org.apache.xerces.parsers.CachingParserPool;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.EntityResolverWrapper;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.SynchronizedSymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class SchemaReaderImpl
extends AbstractSchemaReader {
    private static final PropertyId[] supportedPropertyIds = new PropertyId[]{ValidateProperty.ERROR_HANDLER, ValidateProperty.ENTITY_RESOLVER};

    SchemaReaderImpl() {
    }

    public Schema createSchema(SAXSource sAXSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        SymbolTable symbolTable = new SymbolTable();
        XMLGrammarPreparser xMLGrammarPreparser = new XMLGrammarPreparser(symbolTable);
        XMLGrammarPoolImpl xMLGrammarPoolImpl = new XMLGrammarPoolImpl();
        xMLGrammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        xMLGrammarPreparser.setGrammarPool((XMLGrammarPool)xMLGrammarPoolImpl);
        ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(propertyMap);
        SAXXMLErrorHandler sAXXMLErrorHandler = new SAXXMLErrorHandler(errorHandler);
        xMLGrammarPreparser.setErrorHandler((XMLErrorHandler)sAXXMLErrorHandler);
        EntityResolver entityResolver = ValidateProperty.ENTITY_RESOLVER.get(propertyMap);
        if (entityResolver != null) {
            xMLGrammarPreparser.setEntityResolver((XMLEntityResolver)new EntityResolverWrapper(entityResolver));
        }
        try {
            xMLGrammarPreparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", SchemaReaderImpl.toXMLInputSource(sAXSource.getInputSource()));
            Name name = WrapProperty.ATTRIBUTE_OWNER.get(propertyMap);
            if (name != null) {
                StringReader stringReader = new StringReader(SchemaReaderImpl.createWrapper(name));
                xMLGrammarPreparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", new XMLInputSource(null, null, null, (Reader)stringReader, null));
            }
        }
        catch (XNIException xNIException) {
            throw ValidatorImpl.toSAXException(xNIException);
        }
        if (sAXXMLErrorHandler.getHadError()) {
            throw new IncorrectSchemaException();
        }
        return new SchemaImpl((SymbolTable)new SynchronizedSymbolTable(symbolTable), (XMLGrammarPool)new CachingParserPool.SynchronizedGrammarPool((XMLGrammarPool)xMLGrammarPoolImpl), propertyMap, supportedPropertyIds);
    }

    public Option getOption(String string) {
        return null;
    }

    private static String createWrapper(Name name) {
        return "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"    targetNamespace=\"" + name.getNamespaceUri() + "\">" + "  <xs:element name=\"" + name.getLocalName() + "\">" + "    <xs:complexType><xs:anyAttribute processContents=\"strict\"/></xs:complexType>" + "  </xs:element>" + "</xs:schema>";
    }

    private static XMLInputSource toXMLInputSource(InputSource inputSource) {
        XMLInputSource xMLInputSource = new XMLInputSource(inputSource.getPublicId(), inputSource.getSystemId(), null);
        xMLInputSource.setByteStream(inputSource.getByteStream());
        xMLInputSource.setCharacterStream(inputSource.getCharacterStream());
        xMLInputSource.setEncoding(inputSource.getEncoding());
        return xMLInputSource;
    }
}

