/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide.commands;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.WildflyTargetModuleID;
import org.netbeans.modules.javaee.wildfly.ide.WildflyDeploymentStatus;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WildflyExplodedDeployer
implements ProgressObject,
Runnable {
    static final String DEPLOYED = ".deployed";
    static final String FAILED_DEPLOY = ".failed";
    static final String DO_DEPLOY = ".dodeploy";
    static final String DEPLOYING = ".isdeploying";
    static final String UNDEPLOYING = ".isundeploying";
    static final String UNDEPLOYED = ".undeployed";
    static final String SKIP_DEPLOY = ".skipdeploy";
    static final String PENDING = ".pending";
    protected static final int TIMEOUT = 60000;
    protected static final int POLLING_INTERVAL = 1000;
    private static final Logger LOGGER = Logger.getLogger(WildflyExplodedDeployer.class.getName());
    protected final WildflyDeploymentManager dm;
    protected File file;
    protected WildflyTargetModuleID mainModuleID;
    private List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private DeploymentStatus deploymentStatus;

    public WildflyExplodedDeployer(WildflyDeploymentManager dm) {
        this.dm = dm;
    }

    public ProgressObject deploy(Target target, J2eeModule.Type type, File file) {
        this.file = file;
        this.mainModuleID = new WildflyTargetModuleID(target, file.getName(), type, file.isDirectory());
        this.fireHandleProgressEvent(this.mainModuleID, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(WildflyDeploymentStatus.class, (String)"MSG_DEPLOYING", (Object)file.getAbsolutePath())));
        RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        return this;
    }

    public ProgressObject redeploy(TargetModuleID module_id, File file) {
        this.file = file;
        this.mainModuleID = (WildflyTargetModuleID)module_id;
        this.fireHandleProgressEvent(this.mainModuleID, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(WildflyDeploymentStatus.class, (String)"MSG_DEPLOYING", (Object)file.getAbsolutePath())));
        RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        return this;
    }

    @Override
    public void run() {
        try {
            String deployDir = this.dm.getClient().getDeploymentDirectory();
            String message = this.deployFile(this.file, new File(deployDir));
            if (message != null) {
                this.fireHandleProgressEvent(this.mainModuleID, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, message));
                return;
            }
            if (this.mainModuleID.getType() == J2eeModule.Type.WAR) {
                this.mainModuleID.setContextURL(this.dm.getClient().getWebModuleURL(this.mainModuleID.getModuleID()));
            }
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.INFO, null, ex);
            this.fireHandleProgressEvent(this.mainModuleID, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        catch (MissingResourceException ex) {
            LOGGER.log(Level.INFO, null, ex);
            this.fireHandleProgressEvent(this.mainModuleID, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex);
            this.fireHandleProgressEvent(this.mainModuleID, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        this.fireHandleProgressEvent(this.mainModuleID, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, "Application Deployed"));
    }

    private synchronized String deployFile(File file, File deployDir) throws IOException, InterruptedException {
        long deployTime = file.lastModified();
        File statusFile = new File(deployDir, file.getName() + DEPLOYED);
        File failedFile = new File(deployDir, file.getName() + FAILED_DEPLOY);
        File dodeployFile = new File(deployDir, file.getName() + DO_DEPLOY);
        if (!dodeployFile.exists() && !this.isDeploymentInProgress(file, deployDir)) {
            dodeployFile.createNewFile();
        }
        int i = 0;
        int limit = 60;
        do {
            Thread.sleep(1000L);
        } while (++i < limit && this.isDeploymentInProgress(file, deployDir) || (!statusFile.exists() || statusFile.lastModified() < deployTime) && (!failedFile.exists() || failedFile.lastModified() < deployTime));
        if (failedFile.isFile()) {
            FileObject fo = FileUtil.toFileObject((File)failedFile);
            if (fo != null) {
                return fo.asText();
            }
            return NbBundle.getMessage(WildflyDeploymentStatus.class, (String)"MSG_FAILED");
        }
        if (!statusFile.isFile()) {
            return NbBundle.getMessage(WildflyDeploymentStatus.class, (String)"MSG_TIMEOUT");
        }
        return null;
    }

    private boolean isDeploymentInProgress(File file, File deployDir) {
        File deployingFile = new File(deployDir, file.getName() + DEPLOYING);
        File pendingFile = new File(deployDir, file.getName() + PENDING);
        File undeployingFile = new File(deployDir, file.getName() + UNDEPLOYING);
        return deployingFile.exists() || pendingFile.exists() || undeployingFile.exists();
    }

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("Stop is not supported");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("Cancel is not supported");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[]{this.mainModuleID};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentStatus getDeploymentStatus() {
        WildflyExplodedDeployer wildflyExplodedDeployer = this;
        synchronized (wildflyExplodedDeployer) {
            return this.deploymentStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHandleProgressEvent(TargetModuleID targetModuleID, DeploymentStatus deploymentStatus) {
        ProgressEvent evt = new ProgressEvent((Object)this, targetModuleID, deploymentStatus);
        WildflyExplodedDeployer wildflyExplodedDeployer = this;
        synchronized (wildflyExplodedDeployer) {
            this.deploymentStatus = deploymentStatus;
        }
        for (ProgressListener listener : this.listeners) {
            listener.handleProgressEvent(evt);
        }
    }
}

