/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.queries.api;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.source.queries.SPIAccessor;
import org.netbeans.modules.java.source.queries.api.Function;
import org.netbeans.modules.java.source.queries.api.Queries;
import org.netbeans.modules.java.source.queries.api.QueryException;
import org.netbeans.modules.java.source.queries.spi.QueriesController;
import org.openide.util.Parameters;

public final class Updates
extends Queries {
    Updates(@NonNull URL forURL) {
        super(forURL);
    }

    public void modifyInterfaces(@NonNull String cls, @NonNull Collection<? extends String> toAdd, @NonNull Collection<? extends String> toRemove) throws QueryException {
        Parameters.notNull((CharSequence)"cls", (Object)cls);
        Parameters.notNull((CharSequence)"toAdd", toAdd);
        Parameters.notNull((CharSequence)"toRemove", toRemove);
        this.impl.modifyInterfaces(cls, toAdd, toRemove);
    }

    public void setSuperClass(@NonNull String cls, @NonNull String superCls) throws QueryException {
        Parameters.notNull((CharSequence)"cls", (Object)cls);
        Parameters.notNull((CharSequence)"superCls", (Object)superCls);
        this.impl.setSuperClass(cls, superCls);
    }

    public void fixImports(int[][] ranges) throws QueryException {
        Parameters.notNull((CharSequence)"requiredFQNs", (Object)ranges);
        int[][] dcopy = new int[ranges.length][];
        for (int i = 0; i < ranges.length; ++i) {
            if (ranges[i].length != 2) {
                throw new IllegalArgumentException("Wrong range length, expected 2");
            }
            dcopy[i] = Arrays.copyOf(ranges[i], 2);
        }
        this.impl.fixImports(dcopy);
    }

    public void renameField(@NonNull String cls, @NonNull String oldName, @NonNull String newName) throws QueryException {
        Parameters.notNull((CharSequence)"oldName", (Object)oldName);
        Parameters.notNull((CharSequence)"newName", (Object)newName);
        this.impl.renameField(cls, oldName, newName);
    }

    public static boolean update(@NonNull URL forURL, @NonNull Function<Updates, Boolean> updateFnc) throws QueryException {
        Parameters.notNull((CharSequence)"forURL", (Object)forURL);
        Parameters.notNull((CharSequence)"updateFnc", updateFnc);
        if (ctl == null) {
            throw new IllegalStateException("No QueriesController found in the Lookup");
        }
        Updates u = new Updates(forURL);
        QueriesController.Context<Boolean> ctx = SPIAccessor.getInstance().createContext(updateFnc, u);
        return ctl.runUpdate(ctx);
    }
}

