/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.hints.projectbridge;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.hints.projectbridge.Bundle;
import org.netbeans.modules.editor.tools.storage.api.ToolPreferences;
import org.netbeans.spi.editor.hints.projects.PerProjectHintsPanel;
import org.netbeans.spi.editor.hints.projects.ProjectSettings;
import org.netbeans.spi.editor.hints.projects.support.StandardProjectSettings;
import org.netbeans.spi.editor.hints.settings.FileHintPreferences;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class ProjectConfiguration {
    private static Project suiteProject(Project prj) {
        try {
            FileObject suiteProperties = prj.getProjectDirectory().getFileObject("nbproject/suite.properties");
            if (suiteProperties == null) {
                return null;
            }
            EditableProperties p = new EditableProperties(false);
            try (InputStream is = suiteProperties.getInputStream();){
                p.load(is);
            }
            String suiteDir = p.get((Object)"suite.dir").replace("${basedir}/", "");
            FileObject suiteProjectLoc = suiteDir != null ? prj.getProjectDirectory().getFileObject(suiteDir) : null;
            return suiteProjectLoc != null ? ProjectManager.getDefault().findProject(suiteProjectLoc) : null;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static class ProjectCustomizer
    implements ProjectCustomizer.CompositeCategoryProvider {
        public ProjectCustomizer.Category createCategory(Lookup context) {
            Project prj = (Project)context.lookup(Project.class);
            if (prj == null) {
                return null;
            }
            return ProjectCustomizer.Category.create((String)"editor.hints", (String)Bundle.CAP_Hints(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        }

        public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
            FileObject customizersFolder;
            Project prj = (Project)context.lookup(Project.class);
            assert (prj != null);
            try {
                customizersFolder = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"Projects/hints/java-based");
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            final PerProjectHintsPanel panel = PerProjectHintsPanel.create((FileObject)customizersFolder);
            FileObject nbbuildMisc = prj.getProjectDirectory().getFileObject("../../nbbuild/misc");
            if (nbbuildMisc == null) {
                nbbuildMisc = prj.getProjectDirectory().getFileObject("../../../nbbuild/misc");
            }
            if (nbbuildMisc != null) {
                URI settingsLocation = nbbuildMisc.toURI().resolve("hints-settings.xml");
                final ToolPreferences prefs = ToolPreferences.from((URI)settingsLocation);
                panel.setPerProjectSettings(prefs);
                category.setOkButtonListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        panel.applyChanges();
                    }
                });
                category.setStoreListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            prefs.save();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        FileHintPreferences.fireChange();
                    }
                });
                return panel.getPanel();
            }
            Project suiteProject = ProjectConfiguration.suiteProject(prj);
            if (suiteProject != null && suiteProject != prj) {
                JLabel configureInModuleSuite = new JLabel(Bundle.LBL_ConfigureInSuite());
                return configureInModuleSuite;
            }
            return StandardProjectSettings.createCustomizerProvider((String)"Projects/hints/java-based").createComponent(category, context);
        }
    }

    public static class ProjectSettingsProvider
    implements LookupProvider {
        public Lookup createAdditionalLookup(Lookup baseContext) {
            Project prj = (Project)baseContext.lookup(Project.class);
            FileObject nbbuildMisc = prj.getProjectDirectory().getFileObject("../../nbbuild/misc");
            if (nbbuildMisc == null) {
                nbbuildMisc = prj.getProjectDirectory().getFileObject("../../../nbbuild/misc");
            }
            if (nbbuildMisc != null) {
                final FileObject nbbuildMiscFin = nbbuildMisc;
                return Lookups.fixed((Object[])new Object[]{new ProjectSettings(){

                    public boolean getUseProjectSettings() {
                        return true;
                    }

                    public Preferences getProjectSettings(String mimeType) {
                        URI settingsLocation = nbbuildMiscFin.toURI().resolve("hints-settings.xml");
                        return ToolPreferences.from((URI)settingsLocation).getPreferences("hints", mimeType);
                    }
                }});
            }
            InstanceContent ic = new InstanceContent();
            ic.add((Object)prj, (InstanceContent.Convertor)new InstanceContent.Convertor<Project, ProjectSettings>(){

                public ProjectSettings convert(Project prj) {
                    Project suiteProject = ProjectConfiguration.suiteProject(prj);
                    if (suiteProject != null && suiteProject != prj) {
                        System.err.println("suiteProject=" + suiteProject.getProjectDirectory());
                        ProjectSettings settings = (ProjectSettings)suiteProject.getLookup().lookup(ProjectSettings.class);
                        return settings;
                    }
                    return (ProjectSettings)StandardProjectSettings.createSettings(null, null, null).createAdditionalLookup(Lookups.fixed((Object[])new Object[]{prj})).lookup(ProjectSettings.class);
                }

                public Class<? extends ProjectSettings> type(Project obj) {
                    return ProjectSettings.class;
                }

                public String id(Project prj) {
                    return "prj";
                }

                public String displayName(Project prj) {
                    return "Hint Project Settings";
                }
            });
            return new AbstractLookup((AbstractLookup.Content)ic);
        }
    }
}

