/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.security.SignatureException;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupport;
import org.netbeans.modules.nativeexecution.sps.impl.SPSLocalImpl;
import org.netbeans.modules.nativeexecution.sps.impl.SPSRemoteImpl;
import org.netbeans.modules.nativeexecution.support.Logger;

public final class SolarisPrivilegesSupportProvider {
    private static final ConcurrentHashMap<ExecutionEnvironment, SolarisPrivilegesSupport> instances = new ConcurrentHashMap();

    private SolarisPrivilegesSupportProvider() {
    }

    public static SolarisPrivilegesSupport getSupportFor(ExecutionEnvironment execEnv) {
        SolarisPrivilegesSupport result = instances.get(execEnv);
        if (result == null) {
            SolarisPrivilegesSupport oldRef;
            if (execEnv.isLocal()) {
                try {
                    result = SPSLocalImpl.getNewInstance(execEnv);
                }
                catch (SignatureException ex) {
                    Logger.getInstance().log(Level.SEVERE, "Resource signature is wrong: {0}", ex.getMessage());
                }
                catch (MissingResourceException ex) {
                    Logger.getInstance().log(Level.SEVERE, "Resource not found: {0}", ex.getMessage());
                }
            } else {
                result = SPSRemoteImpl.getNewInstance(execEnv);
            }
            if (result != null && (oldRef = instances.putIfAbsent(execEnv, result)) != null) {
                result = oldRef;
            }
        }
        return result;
    }
}

