/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class NamespaceName
extends Expression {
    protected List<Identifier> segments = new ArrayList<Identifier>();
    private boolean global;
    private boolean current;

    public NamespaceName(int start, int end, Identifier[] segments, boolean global, boolean current) {
        super(start, end);
        if (segments == null) {
            throw new IllegalArgumentException();
        }
        this.segments.addAll(Arrays.asList(segments));
        this.global = global;
        this.current = current;
    }

    public NamespaceName(int start, int end, List segments, boolean global, boolean current) {
        super(start, end);
        if (segments == null) {
            throw new IllegalArgumentException();
        }
        Iterator it = segments.iterator();
        while (it.hasNext()) {
            this.segments.add((Identifier)it.next());
        }
        this.global = global;
        this.current = current;
    }

    @NonNull
    public static NamespaceName create(int start, int end, @NonNull String namespaceName) {
        boolean isGlobal = namespaceName.startsWith("\\");
        boolean isCurrent = namespaceName.startsWith("namespace\\");
        String[] names = namespaceName.split("\\\\");
        int startSegment = start;
        ArrayList<Identifier> list = new ArrayList<Identifier>(names.length);
        for (String n : names) {
            if (n.equals("namespace") || n.isEmpty()) {
                startSegment += n.length() + 1;
                continue;
            }
            list.add(new Identifier(startSegment, startSegment + n.length(), n));
            startSegment += n.length() + 1;
        }
        return new NamespaceName(start, end, list, isGlobal, isCurrent);
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public List<Identifier> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Identifier identifier : this.getSegments()) {
            sb.append(identifier).append("\\");
        }
        return (this.isGlobal() ? "\\" : (this.isCurrent() ? "namespace " : "")) + sb.toString();
    }
}

