/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsRootChildren;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class JaxWsRootNode
extends AbstractNode
implements PropertyChangeListener {
    private PropertyEvaluator evaluator;
    private Project project;
    private boolean jsr109Supported;
    private static final String SERVICES_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/webservicegroup.png";
    private Icon folderIconCache;
    private Icon openedFolderIconCache;
    private Image cachedServicesBadge;

    public JaxWsRootNode(Project project, JaxWsModel jaxWsModel, FileObject[] srcRoots) {
        super((Children)new JaxWsRootChildren(jaxWsModel, srcRoots), Lookups.fixed((Object[])new Object[]{project}));
        this.setDisplayName(NbBundle.getBundle(JaxWsRootNode.class).getString("LBL_WebServices"));
        this.project = project;
        if (!ProjectUtil.isJavaEE5orHigher((Project)project)) {
            this.listenToServerChanges();
            WSStackUtils stackUtils = new WSStackUtils(project);
            this.jsr109Supported = stackUtils.isJsr109Supported();
        }
    }

    public Image getIcon(int type) {
        return this.computeIcon(false);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true);
    }

    private Image getServicesImage() {
        if (this.cachedServicesBadge == null) {
            this.cachedServicesBadge = ImageUtilities.loadImage((String)SERVICES_BADGE);
        }
        return this.cachedServicesBadge;
    }

    private Icon getFolderIcon(boolean opened) {
        if (this.openedFolderIconCache == null) {
            Node n = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
            this.openedFolderIconCache = ImageUtilities.image2Icon((Image)n.getOpenedIcon(1));
            this.folderIconCache = ImageUtilities.image2Icon((Image)n.getIcon(1));
        }
        if (opened) {
            return this.openedFolderIconCache;
        }
        return this.folderIconCache;
    }

    private Image computeIcon(boolean opened) {
        Icon icon = this.getFolderIcon(opened);
        Image image = ((ImageIcon)icon).getImage();
        image = ImageUtilities.mergeImages((Image)image, (Image)this.getServicesImage(), (int)7, (int)7);
        return image;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private void listenToServerChanges() {
        JAXWSSupport wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
        if (wss != null) {
            this.evaluator = wss.getAntProjectHelper().getStandardPropertyEvaluator();
            PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.evaluator);
            this.evaluator.addPropertyChangeListener(pcl);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        WSStackUtils stackUtils;
        boolean newJsr109Supported;
        JAXWSSupport wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
        if (wss != null && wss.getServices().size() > 0 && "j2ee.server.instance".equals(evt.getPropertyName()) && this.jsr109Supported != (newJsr109Supported = (stackUtils = new WSStackUtils(this.project)).isJsr109Supported())) {
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            boolean isJsr109Project = jaxWsModel.getJsr109();
            if (isJsr109Project != newJsr109Supported) {
                String msg = NbBundle.getMessage(JaxWsRootNode.class, (String)"MSG_IncompatibleWSServer");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
            }
            this.jsr109Supported = newJsr109Supported;
        }
    }
}

