/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.wizards.PanelSupportedFrameworks;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelSupportedFrameworksVisual
extends JPanel
implements HelpCtx.Provider,
TableModelListener,
ListSelectionListener,
ChangeListener {
    public static final int ALL_FRAMEWORKS = 0;
    public static final int USED_FRAMEWORKS = 1;
    public static final int UNUSED_FRAMEWORKS = 2;
    private List ignoredFrameworks;
    private Map<WebFrameworkProvider, WebModuleExtender> extenders = new IdentityHashMap<WebFrameworkProvider, WebModuleExtender>();
    private FrameworksTableModel model;
    private PanelSupportedFrameworks panel;
    private ExtenderController controller;
    private JLabel jLabel1;
    private JLabel jLabelConfig;
    private JPanel jPanelConfig;
    private JScrollPane jScrollPane1;
    private JTable jTableFrameworks;

    public PanelSupportedFrameworksVisual(PanelSupportedFrameworks panel, ExtenderController controller, WebProject project, int filter, List ignoredFrameworks) {
        this.panel = panel;
        this.controller = controller;
        this.ignoredFrameworks = ignoredFrameworks;
        this.initComponents();
        this.model = new FrameworksTableModel();
        this.jTableFrameworks.setModel(this.model);
        this.jTableFrameworks.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
        this.createFrameworksList(project, filter);
        FrameworksTableCellRenderer renderer = new FrameworksTableCellRenderer();
        renderer.setBooleanRenderer(this.jTableFrameworks.getDefaultRenderer(Boolean.class));
        this.jTableFrameworks.setDefaultRenderer(WebFrameworkProvider.class, renderer);
        this.jTableFrameworks.setDefaultRenderer(Boolean.class, renderer);
        this.initTableVisualProperties(this.jTableFrameworks);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"ACS_NWP2_Frameworks_A11YDesc"));
        this.setName(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"LBL_NWP2_Frameworks"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"TXT_NewWebApp"));
    }

    private void initTableVisualProperties(JTable table) {
        table.getModel().addTableModelListener(this);
        table.setRowSelectionAllowed(true);
        table.getSelectionModel().addListSelectionListener(this);
        table.getSelectionModel().setSelectionMode(0);
        table.setTableHeader(null);
        table.setRowHeight(this.jTableFrameworks.getRowHeight() + 4);
        table.setIntercellSpacing(new Dimension(0, 0));
        table.getParent().setBackground(table.getBackground());
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(false);
        table.getColumnModel().getColumn(0).setMaxWidth(30);
    }

    private void createFrameworksList(WebProject project, int filter) {
        block4: {
            List frameworks;
            block5: {
                block3: {
                    frameworks = WebFrameworks.getFrameworks();
                    if (project != null && filter != 0) break block3;
                    for (int i = 0; i < frameworks.size(); ++i) {
                        this.addFrameworkToModel((WebFrameworkProvider)frameworks.get(i));
                    }
                    break block4;
                }
                if (filter != 1) break block5;
                for (int i = 0; i < frameworks.size(); ++i) {
                    WebFrameworkProvider framework = (WebFrameworkProvider)frameworks.get(i);
                    if (!framework.isInWebModule(project.getAPIWebModule())) continue;
                    this.addFrameworkToModel(framework);
                }
                break block4;
            }
            if (filter != 2) break block4;
            for (int i = 0; i < frameworks.size(); ++i) {
                WebFrameworkProvider framework = (WebFrameworkProvider)frameworks.get(i);
                if (framework.isInWebModule(project.getAPIWebModule())) continue;
                this.addFrameworkToModel(framework);
            }
        }
    }

    private void addFrameworkToModel(WebFrameworkProvider framework) {
        FrameworksTableModel model = (FrameworksTableModel)this.jTableFrameworks.getModel();
        if (this.ignoredFrameworks == null || !this.ignoredFrameworks.contains(framework)) {
            model.addItem(new FrameworkModelItem(framework));
        }
    }

    private void createExtenders() {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            FrameworkModelItem item = this.model.getItem(i);
            WebFrameworkProvider framework = item.getFramework();
            WebModuleExtender extender = framework.createWebModuleExtender(null, this.controller);
            if (extender == null) continue;
            extender.addChangeListener((ChangeListener)this);
            this.extenders.put(framework, extender);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableFrameworks = new JTable();
        this.jLabelConfig = new JLabel();
        this.jPanelConfig = new JPanel();
        this.setPreferredSize(new Dimension(500, 340));
        this.setRequestFocusEnabled(false);
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"MNE_Frameworks").charAt(0));
        this.jLabel1.setLabelFor(this.jTableFrameworks);
        this.jLabel1.setText(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"LBL_NWP2_Select_Frameworks"));
        this.jScrollPane1.setMinimumSize(new Dimension(22, 70));
        this.jScrollPane1.setOpaque(false);
        this.jScrollPane1.setPreferredSize(new Dimension(453, 70));
        this.jTableFrameworks.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableFrameworks.setOpaque(false);
        this.jScrollPane1.setViewportView(this.jTableFrameworks);
        this.jLabelConfig.setLabelFor(this.jPanelConfig);
        this.jPanelConfig.setLayout(new GridBagLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 500, Short.MAX_VALUE).addComponent(this.jPanelConfig, -1, 500, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 500, Short.MAX_VALUE).addComponent(this.jLabelConfig, -1, 500, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelConfig, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelConfig, -1, 199, Short.MAX_VALUE)));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"ACS_LBL_NWP2_FrameworksTable_A11YDesc"));
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        this.setErrorMessage(wizardDescriptor, null);
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String message;
            if (!this.model.getItem(i).isSelected().booleanValue()) continue;
            FrameworkModelItem item = this.model.getItem(i);
            WebModuleExtender extender = this.extenders.get(item.getFramework());
            if (extender != null && !extender.isValid()) {
                message = (String)this.controller.getProperties().getProperty("WizardPanel_infoMessage");
                if (this.controller.getErrorMessage() == null && message != null) {
                    this.setInfoMessage(wizardDescriptor, message);
                } else {
                    this.setErrorMessage(wizardDescriptor, this.controller.getErrorMessage());
                }
                return false;
            }
            if (extender == null || !extender.isValid()) continue;
            message = (String)this.controller.getProperties().getProperty("WizardPanel_infoMessage");
            if (this.controller.getErrorMessage() != null || message == null) continue;
            this.setInfoMessage(wizardDescriptor, message);
        }
        return true;
    }

    private void setErrorMessage(WizardDescriptor wizardDescriptor, String errorMessage) {
        if (errorMessage == null || errorMessage.length() == 0) {
            errorMessage = " ";
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
    }

    private void setInfoMessage(WizardDescriptor wizardDescriptor, String infoMessage) {
        if (infoMessage == null || infoMessage.length() == 0) {
            infoMessage = " ";
        }
        wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)infoMessage);
    }

    void read(WizardDescriptor settings) {
        ExtenderController.Properties properties = this.controller.getProperties();
        properties.setProperty("name", (Object)((String)settings.getProperty("name")));
        Profile profile = (Profile)settings.getProperty("j2eeLevel");
        if (profile != null) {
            properties.setProperty("j2eeLevel", (Object)profile.toPropertiesString());
        }
        properties.setProperty("serverInstanceID", (Object)((String)settings.getProperty("serverInstanceID")));
        properties.setProperty("setSourceLevel", (Object)((String)settings.getProperty("setSourceLevel")));
        if (this.extenders.size() == 0) {
            this.createExtenders();
        }
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            FrameworkModelItem item = this.model.getItem(i);
            WebModuleExtender extender = this.extenders.get(item.getFramework());
            if (extender == null) continue;
            extender.update();
        }
    }

    void store(WizardDescriptor settings) {
        settings.putProperty("extenders", (Object)this.getSelectedExtenders());
        settings.putProperty("frameworkNames", this.getSelectedFrameworkNames());
    }

    public List getSelectedExtenders() {
        LinkedList<WebModuleExtender> selectedExtenders = new LinkedList<WebModuleExtender>();
        FrameworksTableModel model = (FrameworksTableModel)this.jTableFrameworks.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            WebModuleExtender extender;
            FrameworkModelItem item = model.getItem(i);
            if (!item.isSelected().booleanValue() || (extender = this.extenders.get(item.getFramework())) == null) continue;
            selectedExtenders.add(extender);
        }
        return selectedExtenders;
    }

    private List<String> getSelectedFrameworkNames() {
        LinkedList<String> selectedFrameworkNames = new LinkedList<String>();
        FrameworksTableModel model = (FrameworksTableModel)this.jTableFrameworks.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            String name;
            FrameworkModelItem item = model.getItem(i);
            if (!item.isSelected().booleanValue() || (name = item.getFramework().getName()) == null) continue;
            selectedFrameworkNames.add(name);
        }
        return selectedFrameworkNames;
    }

    public Component[] getConfigComponents() {
        return new Component[]{this.jLabelConfig, this.jPanelConfig};
    }

    public HelpCtx getHelpCtx() {
        if (this.jPanelConfig.getComponentCount() > 0) {
            for (int i = 0; i < this.jPanelConfig.getComponentCount(); ++i) {
                if (!(this.jPanelConfig.getComponent(i) instanceof HelpCtx.Provider)) continue;
                return ((HelpCtx.Provider)this.jPanelConfig.getComponent(i)).getHelpCtx();
            }
        }
        return null;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        FrameworksTableModel model = (FrameworksTableModel)this.jTableFrameworks.getModel();
        if (this.jTableFrameworks.getSelectedRow() == -1) {
            return;
        }
        FrameworkModelItem item = model.getItem(this.jTableFrameworks.getSelectedRow());
        WebFrameworkProvider framework = item.getFramework();
        this.setConfigPanel(framework, item);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        FrameworksTableModel model = (FrameworksTableModel)this.jTableFrameworks.getModel();
        if (this.jTableFrameworks.getSelectedRow() == -1) {
            return;
        }
        FrameworkModelItem item = model.getItem(this.jTableFrameworks.getSelectedRow());
        WebFrameworkProvider framework = item.getFramework();
        this.setConfigPanel(framework, item);
    }

    private void setConfigPanel(WebFrameworkProvider framework, FrameworkModelItem item) {
        if (this.extenders.get(framework) != null) {
            String message = MessageFormat.format(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"LBL_NWP2_ConfigureFramework"), framework.getName());
            this.jLabelConfig.setText(message);
            this.jPanelConfig.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            JComponent panelComponent = this.extenders.get(framework).getComponent();
            this.jPanelConfig.add((Component)panelComponent, gridBagConstraints);
            this.jLabelConfig.setEnabled(item.isSelected());
            this.enableComponents(panelComponent, item.isSelected());
            this.extenders.get(framework).update();
            this.jPanelConfig.revalidate();
            this.jPanelConfig.repaint();
        } else {
            this.jLabelConfig.setText("");
            this.jPanelConfig.removeAll();
            this.jPanelConfig.repaint();
            this.jPanelConfig.revalidate();
        }
        if (this.panel != null) {
            this.panel.fireChangeEvent();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.panel != null) {
            this.panel.fireChangeEvent();
        }
    }

    private void enableComponents(Container root, boolean enabled) {
        root.setEnabled(enabled);
        for (int i = 0; i < root.getComponentCount(); ++i) {
            Component child = root.getComponent(i);
            if (child instanceof Container) {
                this.enableComponents((Container)child, enabled);
                continue;
            }
            child.setEnabled(enabled);
        }
    }

    public static final class FrameworksTableModel
    extends AbstractTableModel {
        private DefaultListModel<FrameworkModelItem> model = new DefaultListModel();

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.model.size();
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return WebFrameworkProvider.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            FrameworkModelItem item = this.getItem(row);
            switch (column) {
                case 0: {
                    return item.isSelected();
                }
                case 1: {
                    return item.getFramework();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            FrameworkModelItem item = this.getItem(row);
            switch (column) {
                case 0: {
                    item.setSelected((Boolean)value);
                    break;
                }
                case 1: {
                    item.setFramework((WebFrameworkProvider)value);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.fireTableCellUpdated(row, column);
        }

        private FrameworkModelItem getItem(int index) {
            return this.model.get(index);
        }

        public void addItem(FrameworkModelItem item) {
            this.model.addElement(item);
        }
    }

    public static class FrameworksTableCellRenderer
    extends DefaultTableCellRenderer {
        private TableCellRenderer booleanRenderer;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof WebFrameworkProvider) {
                WebFrameworkProvider item = (WebFrameworkProvider)value;
                Component comp = super.getTableCellRendererComponent(table, item.getName(), isSelected, false, row, column);
                if (comp instanceof JComponent) {
                    ((JComponent)comp).setOpaque(isSelected);
                }
                return comp;
            }
            if (value instanceof Boolean && this.booleanRenderer != null) {
                return this.booleanRenderer.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }

        public void setBooleanRenderer(TableCellRenderer booleanRenderer) {
            this.booleanRenderer = booleanRenderer;
        }
    }

    private static final class FrameworkModelItem {
        private WebFrameworkProvider framework;
        private Boolean selected;

        public FrameworkModelItem(WebFrameworkProvider framework) {
            this.setFramework(framework);
            this.setSelected(Boolean.FALSE);
        }

        public WebFrameworkProvider getFramework() {
            return this.framework;
        }

        public void setFramework(WebFrameworkProvider framework) {
            this.framework = framework;
        }

        public Boolean isSelected() {
            return this.selected;
        }

        public void setSelected(Boolean selected) {
            this.selected = selected;
        }
    }
}

