/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server.config;

import java.net.URL;
import java.util.List;
import org.netbeans.modules.payara.tooling.data.PayaraConfig;
import org.netbeans.modules.payara.tooling.server.config.JavaEESet;
import org.netbeans.modules.payara.tooling.server.config.JavaSESet;
import org.netbeans.modules.payara.tooling.server.config.LibraryNode;
import org.netbeans.modules.payara.tooling.server.config.Tools;
import org.netbeans.modules.payara.tooling.server.parser.ConfigReaderServer;
import org.netbeans.modules.payara.tooling.server.parser.TreeParser;

public class PayaraConfigXMLImpl
implements PayaraConfig {
    private final URL configFile;
    private final ConfigReaderServer reader = new ConfigReaderServer();
    private volatile boolean readDone;

    public PayaraConfigXMLImpl(URL configFile) {
        this.configFile = configFile;
        this.readDone = false;
    }

    @Override
    public List<LibraryNode> getLibrary() {
        this.readXml();
        return this.reader.getLibraries();
    }

    @Override
    public JavaEESet getJavaEE() {
        this.readXml();
        return this.reader.getJavaEE();
    }

    @Override
    public JavaSESet getJavaSE() {
        this.readXml();
        return this.reader.getJavaSE();
    }

    @Override
    public Tools getTools() {
        this.readXml();
        return this.reader.getTools();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXml() {
        if (this.readDone) {
            return;
        }
        ConfigReaderServer configReaderServer = this.reader;
        synchronized (configReaderServer) {
            if (!this.readDone) {
                TreeParser.readXml(this.configFile, this.reader);
                this.readDone = true;
            }
        }
    }
}

