/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.database.model.DbSystemOptions;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListDbSystemStoragePerformancesRequest
extends BmcRequest<Void> {
    private DbSystemOptions.StorageManagement storageManagement;
    private String shapeType;
    private String opcRequestId;

    public DbSystemOptions.StorageManagement getStorageManagement() {
        return this.storageManagement;
    }

    public String getShapeType() {
        return this.shapeType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().storageManagement(this.storageManagement).shapeType(this.shapeType).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",storageManagement=").append(String.valueOf((Object)this.storageManagement));
        sb.append(",shapeType=").append(String.valueOf(this.shapeType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDbSystemStoragePerformancesRequest)) {
            return false;
        }
        ListDbSystemStoragePerformancesRequest other = (ListDbSystemStoragePerformancesRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.storageManagement, (Object)other.storageManagement) && Objects.equals(this.shapeType, other.shapeType) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.storageManagement == null ? 43 : this.storageManagement.hashCode());
        result = result * 59 + (this.shapeType == null ? 43 : this.shapeType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbSystemStoragePerformancesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private DbSystemOptions.StorageManagement storageManagement = null;
        private String shapeType = null;
        private String opcRequestId = null;

        public Builder storageManagement(DbSystemOptions.StorageManagement storageManagement) {
            this.storageManagement = storageManagement;
            return this;
        }

        public Builder shapeType(String shapeType) {
            this.shapeType = shapeType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbSystemStoragePerformancesRequest o) {
            this.storageManagement(o.getStorageManagement());
            this.shapeType(o.getShapeType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbSystemStoragePerformancesRequest build() {
            ListDbSystemStoragePerformancesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDbSystemStoragePerformancesRequest buildWithoutInvocationCallback() {
            ListDbSystemStoragePerformancesRequest request = new ListDbSystemStoragePerformancesRequest();
            request.storageManagement = this.storageManagement;
            request.shapeType = this.shapeType;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

