/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.lexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.lexer.SLexer;
import org.netbeans.modules.languages.lexer.STokenId;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public class SLanguageHierarchy
extends LanguageHierarchy<STokenId> {
    private Language language;
    private List<STokenId> tokenIDs;
    private Map<Integer, STokenId> tokenIDToType;

    public SLanguageHierarchy(Language language) {
        this.language = language;
    }

    protected Collection<STokenId> createTokenIds() {
        if (this.tokenIDs == null) {
            List<TokenType> tokenTypes = this.language.getParser().getTokenTypes();
            this.tokenIDToType = new HashMap<Integer, STokenId>();
            this.tokenIDs = new ArrayList<STokenId>();
            HashSet<String> types = new HashSet<String>();
            int size = tokenTypes.size();
            for (int i = 0; i < size; ++i) {
                TokenType tokenType = tokenTypes.get(i);
                String typeName = tokenType.getType();
                if (types.contains(typeName)) continue;
                if (this.language.getTokenID(typeName) < 0) {
                    throw new IndexOutOfBoundsException();
                }
                types.add(typeName);
                STokenId tokenId = new STokenId(typeName, this.language.getTokenID(typeName), typeName);
                this.tokenIDs.add(tokenId);
                this.tokenIDToType.put(tokenId.ordinal(), tokenId);
            }
        }
        return this.tokenIDs;
    }

    protected Lexer<STokenId> createLexer(LexerRestartInfo<STokenId> info) {
        if (this.tokenIDs == null) {
            this.createTokenIds();
        }
        return new SLexer(this.language, this.tokenIDToType, info);
    }

    protected String mimeType() {
        return this.language.getMimeType();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + this.hashCode();
    }
}

