/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.DelegatingGitProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.commands.ListBranchCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class CreateBranchCommand
extends GitCommand {
    private final String revision;
    private final String branchName;
    private GitBranch branch;
    private final ProgressMonitor monitor;
    private static final Logger LOG = Logger.getLogger(CreateBranchCommand.class.getName());

    public CreateBranchCommand(Repository repository, GitClassFactory gitFactory, String branchName, String revision, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.branchName = branchName;
        this.revision = revision;
        this.monitor = monitor;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        org.eclipse.jgit.api.CreateBranchCommand cmd = new Git(repository).branchCreate();
        cmd.setName(this.branchName);
        if (this.revision.startsWith("refs/heads/") || this.revision.startsWith("refs/remotes/")) {
            cmd.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK);
        } else {
            Utils.findCommit(repository, this.revision);
        }
        cmd.setStartPoint(this.revision);
        String createdBranchName = this.branchName;
        try {
            Ref ref = cmd.call();
            createdBranchName = ref.getName().substring("refs/heads/".length());
            this.setupRebaseFlag(repository);
        }
        catch (RefNotFoundException ex) {
            if (!this.createBranchInEmptyRepository(repository)) {
                throw new GitException(ex);
            }
        }
        catch (IOException | GitAPIException | JGitInternalException ex) {
            throw new GitException(ex);
        }
        ListBranchCommand branchCmd = new ListBranchCommand(repository, this.getClassFactory(), false, new DelegatingGitProgressMonitor(this.monitor));
        branchCmd.run();
        Map<String, GitBranch> branches = branchCmd.getBranches();
        this.branch = branches.get(createdBranchName);
        if (this.branch == null) {
            LOG.log(Level.WARNING, "Branch {0}/{1} probably created but not in the branch list: {2}", new Object[]{this.branchName, createdBranchName, branches.keySet()});
        }
    }

    private void setupRebaseFlag(Repository repository) throws IOException {
        Ref baseRef = repository.findRef(this.revision);
        if (baseRef != null && baseRef.getName().startsWith("refs/remotes/")) {
            boolean rebase;
            StoredConfig config = repository.getConfig();
            String autosetupRebase = config.getString("branch", null, "autosetuprebase");
            boolean bl = rebase = "always".equals(autosetupRebase) || "remote".equals(autosetupRebase);
            if (rebase && !config.getNames("branch", this.branchName).isEmpty()) {
                config.setBoolean("branch", this.branchName, "rebase", rebase);
                config.save();
            }
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git branch --track " + this.branchName + ' ' + this.revision;
    }

    public GitBranch getBranch() {
        return this.branch;
    }

    private boolean createBranchInEmptyRepository(Repository repository) throws GitException {
        if (this.revision.startsWith("refs/remotes/")) {
            try {
                if (Utils.parseObjectId(repository, "HEAD") == null) {
                    StoredConfig config = repository.getConfig();
                    String[] elements = this.revision.split("/", 4);
                    String remoteName = elements[2];
                    String remoteBranchName = elements[3];
                    config.setString("branch", this.branchName, "remote", remoteName);
                    config.setString("branch", this.branchName, "merge", "refs/heads/" + remoteBranchName);
                    config.save();
                    return true;
                }
            }
            catch (IOException ex) {
                throw new GitException(ex);
            }
            catch (GitException ex) {
                throw ex;
            }
        }
        return false;
    }
}

