/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.js.builtins.ConstructorBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.JSConstructTypedArrayNodeGen;
import com.oracle.truffle.js.builtins.helper.CanBeHeldWeaklyNode;
import com.oracle.truffle.js.nodes.CompileRegexNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.access.ArrayLiteralNode;
import com.oracle.truffle.js.nodes.access.ErrorStackTraceLimitNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.InitErrorObjectNode;
import com.oracle.truffle.js.nodes.access.InstallErrorCauseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.IsRegExpNode;
import com.oracle.truffle.js.nodes.access.IterableToListNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.OrdinaryCreateFromConstructorNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.array.ArrayCreateNode;
import com.oracle.truffle.js.nodes.cast.JSNumericToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerThrowOnInfinityNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerWithoutRoundingNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.ToArrayLengthNode;
import com.oracle.truffle.js.nodes.function.EvalNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.intl.CreateRegExpNode;
import com.oracle.truffle.js.nodes.intl.GetBooleanOptionNode;
import com.oracle.truffle.js.nodes.intl.InitializeCollatorNode;
import com.oracle.truffle.js.nodes.intl.InitializeDateTimeFormatNode;
import com.oracle.truffle.js.nodes.intl.InitializeDisplayNamesNode;
import com.oracle.truffle.js.nodes.intl.InitializeListFormatNode;
import com.oracle.truffle.js.nodes.intl.InitializeLocaleNode;
import com.oracle.truffle.js.nodes.intl.InitializeNumberFormatNode;
import com.oracle.truffle.js.nodes.intl.InitializePluralRulesNode;
import com.oracle.truffle.js.nodes.intl.InitializeRelativeTimeFormatNode;
import com.oracle.truffle.js.nodes.intl.InitializeSegmenterNode;
import com.oracle.truffle.js.nodes.promise.PromiseResolveThenableNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.wasm.ExportByteSourceNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyIndexOrSizeNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ArrayAllocationSite;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantObjectArray;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSAsyncIterator;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSBooleanObject;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSDateObject;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSErrorObject;
import com.oracle.truffle.js.runtime.builtins.JSFinalizationRegistry;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSIterator;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSNumberObject;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSRegExpObject;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSShadowRealm;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSStringObject;
import com.oracle.truffle.js.runtime.builtins.JSWeakMap;
import com.oracle.truffle.js.runtime.builtins.JSWeakRef;
import com.oracle.truffle.js.runtime.builtins.JSWeakSet;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollator;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollatorObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormatObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSDisplayNames;
import com.oracle.truffle.js.runtime.builtins.intl.JSDisplayNamesObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSListFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSListFormatObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSLocale;
import com.oracle.truffle.js.runtime.builtins.intl.JSLocaleObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormatObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSPluralRules;
import com.oracle.truffle.js.runtime.builtins.intl.JSPluralRulesObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSRelativeTimeFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSRelativeTimeFormatObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSSegmenter;
import com.oracle.truffle.js.runtime.builtins.intl.JSSegmenterObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendar;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDay;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobal;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstance;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModule;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModuleObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTable;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyValueTypes;
import com.oracle.truffle.js.runtime.java.JavaImporter;
import com.oracle.truffle.js.runtime.java.JavaPackage;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.LRUCache;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;

public final class ConstructorBuiltins
extends JSBuiltinsContainer.SwitchEnum<Constructor> {
    public static final JSBuiltinsContainer BUILTINS = new ConstructorBuiltins();

    protected ConstructorBuiltins() {
        super(null, Constructor.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, Constructor builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                if (newTarget) {
                    return ConstructorBuiltinsFactory.ConstructArrayNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().varArgs().createArgumentNodes(context));
                }
                return ConstructorBuiltinsFactory.ConstructArrayNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().varArgs().createArgumentNodes(context));
            }
            case 1: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructBooleanNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructBooleanNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context))) : ConstructorBuiltinsFactory.CallBooleanNodeGen.create(context, builtin, ConstructorBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructDateNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().varArgs().createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructDateNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().varArgs().createArgumentNodes(context))) : ConstructorBuiltinsFactory.CallDateNodeGen.create(context, builtin, ConstructorBuiltins.args().createArgumentNodes(context));
            }
            case 3: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructRegExpNodeGen.create(context, builtin, false, true, ConstructorBuiltins.args().newTarget().fixedArgs(2).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructRegExpNodeGen.create(context, builtin, false, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context))) : ConstructorBuiltinsFactory.ConstructRegExpNodeGen.create(context, builtin, true, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context));
            }
            case 4: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructStringNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().varArgs().createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructStringNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().varArgs().createArgumentNodes(context))) : ConstructorBuiltinsFactory.CallStringNodeGen.create(context, builtin, ConstructorBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case 44: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructWeakRefNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructWeakRefNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 45: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructFinalizationRegistryNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructFinalizationRegistryNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 10: {
                return newTarget ? ConstructorBuiltinsFactory.ConstructCollatorNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(2).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructCollatorNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context));
            }
            case 12: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructListFormatNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(2).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructListFormatNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context))) : ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 11: {
                return newTarget ? ConstructorBuiltinsFactory.ConstructNumberFormatNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(2).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructNumberFormatNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context));
            }
            case 13: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructPluralRulesNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(2).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructPluralRulesNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context))) : ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 14: {
                return newTarget ? ConstructorBuiltinsFactory.ConstructDateTimeFormatNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(2).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructDateTimeFormatNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context));
            }
            case 15: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructRelativeTimeFormatNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(2).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructRelativeTimeFormatNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context))) : ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 16: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructSegmenterNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(2).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructSegmenterNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context))) : ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 17: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructDisplayNamesNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(2).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructDisplayNamesNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context))) : ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 18: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructLocaleNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(2).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructLocaleNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context))) : ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 5: {
                if (newTarget) {
                    return ConstructorBuiltinsFactory.ConstructObjectNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().varArgs().createArgumentNodes(context));
                }
                return ConstructorBuiltinsFactory.ConstructObjectNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().varArgs().createArgumentNodes(context));
            }
            case 6: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructNumberNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().varArgs().createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructNumberNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().varArgs().createArgumentNodes(context))) : ConstructorBuiltinsFactory.CallNumberNodeGen.create(context, builtin, ConstructorBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case 7: {
                return construct ? ConstructorBuiltinsFactory.ConstructBigIntNodeGen.create(context, builtin, ConstructorBuiltins.args().createArgumentNodes(context)) : ConstructorBuiltinsFactory.CallBigIntNodeGen.create(context, builtin, ConstructorBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 8: {
                if (newTarget) {
                    return ConstructorBuiltinsFactory.ConstructFunctionNodeGen.create(context, builtin, false, false, true, ConstructorBuiltins.args().newTarget().varArgs().createArgumentNodes(context));
                }
                return ConstructorBuiltinsFactory.ConstructFunctionNodeGen.create(context, builtin, false, false, false, ConstructorBuiltins.args().function().varArgs().createArgumentNodes(context));
            }
            case 9: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructArrayBufferNodeGen.create(context, builtin, false, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructArrayBufferNodeGen.create(context, builtin, false, false, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                if (newTarget) {
                    return ConstructorBuiltinsFactory.ConstructErrorNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(2).createArgumentNodes(context));
                }
                return ConstructorBuiltinsFactory.ConstructErrorNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context));
            }
            case 26: {
                if (newTarget) {
                    return ConstructorBuiltinsFactory.ConstructAggregateErrorNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(3).createArgumentNodes(context));
                }
                return ConstructorBuiltinsFactory.ConstructAggregateErrorNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(3).createArgumentNodes(context));
            }
            case 72: {
                return ConstructorBuiltinsFactory.AbstractClassConstructorNodeGen.create(context, builtin, ConstructorBuiltins.args().createArgumentNodes(context));
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (construct) {
                    if (newTarget) {
                        return JSConstructTypedArrayNodeGen.create(context, builtin, ConstructorBuiltins.args().newTarget().fixedArgs(3).createArgumentNodes(context));
                    }
                    return JSConstructTypedArrayNodeGen.create(context, builtin, ConstructorBuiltins.args().function().fixedArgs(3).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 41: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructDataViewNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(3).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructDataViewNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(3).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 42: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructMapNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructMapNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 43: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructSetNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructSetNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 46: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructWeakMapNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructWeakMapNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 47: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructWeakSetNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructWeakSetNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 48: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructIteratorNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().varArgs().createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructIteratorNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().varArgs().createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 49: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructAsyncIteratorNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().varArgs().createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructAsyncIteratorNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().varArgs().createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 50: {
                if (newTarget) {
                    return ConstructorBuiltinsFactory.ConstructFunctionNodeGen.create(context, builtin, true, false, true, ConstructorBuiltins.args().newTarget().varArgs().createArgumentNodes(context));
                }
                return ConstructorBuiltinsFactory.ConstructFunctionNodeGen.create(context, builtin, true, false, false, ConstructorBuiltins.args().function().varArgs().createArgumentNodes(context));
            }
            case 54: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructArrayBufferNodeGen.create(context, builtin, true, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructArrayBufferNodeGen.create(context, builtin, true, false, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 53: {
                if (newTarget) {
                    return ConstructorBuiltinsFactory.ConstructFunctionNodeGen.create(context, builtin, false, true, true, ConstructorBuiltins.args().newTarget().varArgs().createArgumentNodes(context));
                }
                return ConstructorBuiltinsFactory.ConstructFunctionNodeGen.create(context, builtin, false, true, false, ConstructorBuiltins.args().function().varArgs().createArgumentNodes(context));
            }
            case 55: {
                if (newTarget) {
                    return ConstructorBuiltinsFactory.ConstructFunctionNodeGen.create(context, builtin, true, true, true, ConstructorBuiltins.args().newTarget().varArgs().createArgumentNodes(context));
                }
                return ConstructorBuiltinsFactory.ConstructFunctionNodeGen.create(context, builtin, true, true, false, ConstructorBuiltins.args().function().varArgs().createArgumentNodes(context));
            }
            case 73: {
                return construct ? ConstructorBuiltinsFactory.ConstructSymbolNodeGen.create(context, builtin, ConstructorBuiltins.args().createArgumentNodes(context)) : ConstructorBuiltinsFactory.CallSymbolNodeGen.create(context, builtin, ConstructorBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 51: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructJSProxyNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(3).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructJSProxyNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(3).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 52: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.PromiseConstructorNodeGen.create(context, builtin, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.PromiseConstructorNodeGen.create(context, builtin, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 62: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructTemporalPlainTimeNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(6).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructTemporalPlainTimeNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(6).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 63: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructTemporalPlainDateNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(4).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructTemporalPlainDateNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(4).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 64: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructTemporalPlainDateTimeNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(10).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructTemporalPlainDateTimeNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(10).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 65: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructTemporalDurationNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(10).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructTemporalDurationNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(10).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 66: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructTemporalCalendarNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructTemporalCalendarNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 67: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructTemporalPlainYearMonthNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(4).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructTemporalPlainYearMonthNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(4).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 68: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructTemporalPlainMonthDayNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(4).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructTemporalPlainMonthDayNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(4).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 69: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructTemporalInstantNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(4).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructTemporalInstantNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(4).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 70: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructTemporalTimeZoneNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(4).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructTemporalTimeZoneNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(4).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 71: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructTemporalZonedDateTimeNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(4).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructTemporalZonedDateTimeNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(4).createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 61: {
                if (construct) {
                    return newTarget ? ConstructorBuiltinsFactory.ConstructShadowRealmNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructShadowRealmNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().createArgumentNodes(context));
                }
                return ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 74: {
                return ConstructorBuiltinsFactory.ConstructJSAdapterNodeGen.create(context, builtin, ConstructorBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case 75: {
                return ConstructorBuiltinsFactory.ConstructJavaImporterNodeGen.create(context, builtin, ConstructorBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case 56: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructWebAssemblyGlobalNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).varArgs().createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructWebAssemblyGlobalNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(1).varArgs().createArgumentNodes(context))) : ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 57: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructWebAssemblyInstanceNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(2).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructWebAssemblyInstanceNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(2).createArgumentNodes(context))) : ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 58: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructWebAssemblyMemoryNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructWebAssemblyMemoryNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context))) : ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 59: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructWebAssemblyModuleNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructWebAssemblyModuleNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(1).createArgumentNodes(context))) : ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
            case 60: {
                return construct ? (newTarget ? ConstructorBuiltinsFactory.ConstructWebAssemblyTableNodeGen.create(context, builtin, true, ConstructorBuiltins.args().newTarget().fixedArgs(1).varArgs().createArgumentNodes(context)) : ConstructorBuiltinsFactory.ConstructWebAssemblyTableNodeGen.create(context, builtin, false, ConstructorBuiltins.args().function().fixedArgs(1).varArgs().createArgumentNodes(context))) : ConstructorBuiltins.createCallRequiresNew(context, builtin);
            }
        }
        return null;
    }

    public static JSBuiltinNode createCallRequiresNew(JSContext context, JSBuiltin builtin) {
        return ConstructorBuiltinsFactory.CallRequiresNewNodeGen.create(context, builtin, ConstructorBuiltins.args().createArgumentNodes(context));
    }

    public static enum Constructor implements BuiltinEnum<Constructor>
    {
        Array(1),
        Boolean(1),
        Date(7),
        RegExp(2),
        String(1),
        Object(1),
        Number(1),
        BigInt(1),
        Function(1),
        ArrayBuffer(1),
        Collator(0),
        NumberFormat(0),
        ListFormat(0),
        PluralRules(0),
        DateTimeFormat(0),
        RelativeTimeFormat(0),
        Segmenter(0),
        DisplayNames(2),
        Locale(1),
        Error(1),
        RangeError(1),
        TypeError(1),
        ReferenceError(1),
        SyntaxError(1),
        EvalError(1),
        URIError(1),
        AggregateError(2),
        CompileError(1),
        LinkError(1),
        RuntimeError(1),
        Int8Array(3),
        Uint8Array(3),
        Uint8ClampedArray(3),
        Int16Array(3),
        Uint16Array(3),
        Int32Array(3),
        Uint32Array(3),
        Float32Array(3),
        Float64Array(3),
        BigInt64Array(3),
        BigUint64Array(3),
        DataView(1),
        Map(0),
        Set(0),
        WeakRef(1),
        FinalizationRegistry(1),
        WeakMap(0),
        WeakSet(0),
        Iterator(0),
        AsyncIterator(0),
        GeneratorFunction(1),
        Proxy(2),
        Promise(1),
        AsyncFunction(1),
        SharedArrayBuffer(1),
        AsyncGeneratorFunction(1),
        Global(1),
        Instance(1),
        Memory(1),
        Module(1),
        Table(1),
        ShadowRealm(0),
        PlainTime(0),
        PlainDate(3),
        PlainDateTime(3),
        Duration(0),
        Calendar(1),
        PlainYearMonth(2),
        PlainMonthDay(2),
        Instant(1),
        TimeZone(1),
        ZonedDateTime(2),
        TypedArray(0),
        Symbol(0),
        JSAdapter(1),
        JavaImporter(1);

        private final int length;

        private Constructor(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isConstructor() {
            return true;
        }

        @Override
        public boolean isNewTargetConstructor() {
            return EnumSet.range(Array, ZonedDateTime).contains(this);
        }

        @Override
        public int getECMAScriptVersion() {
            if (AsyncGeneratorFunction == this) {
                return 9;
            }
            if (EnumSet.of(SharedArrayBuffer, AsyncFunction).contains(this)) {
                return 8;
            }
            if (EnumSet.range(Map, Symbol).contains(this)) {
                return 6;
            }
            if (EnumSet.of(PlainTime, new Constructor[]{Calendar, Duration, PlainDate, PlainDateTime, PlainYearMonth, PlainMonthDay, Instant, TimeZone, ZonedDateTime}).contains(this)) {
                return 13;
            }
            if (EnumSet.of(Iterator, AsyncIterator).contains(this)) {
                return 15;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ConstructArrayNode
    extends ConstructWithNewTargetNode {
        @CompilerDirectives.CompilationFinal
        private ConstructArrayAllocationSite arrayAllocationSite = ConstructArrayNode.createAllocationSite();

        public ConstructArrayNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        protected static boolean isOneNumberArg(Object[] args) {
            return args.length == 1 && JSRuntime.isNumber(args[0]);
        }

        protected static boolean isOneForeignArg(Object[] args) {
            return args.length == 1 && JSRuntime.isForeignObject(args[0]);
        }

        protected static boolean isOneIntegerArg(Object[] args) {
            return args.length == 1 && args[0] instanceof Integer && (Integer)args[0] >= 0;
        }

        @Specialization(guards={"args.length == 0"})
        protected JSObject constructArray0(JSDynamicObject newTarget, Object[] args) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSArray.createConstantEmptyArray(this.getContext(), realm, proto, this.arrayAllocationSite);
        }

        @Specialization(guards={"isOneIntegerArg(args)"})
        protected JSObject constructArrayWithIntLength(JSDynamicObject newTarget, Object[] args) {
            ScriptArray initialType;
            int length = (Integer)args[0];
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            if (JSConfig.TrackArrayAllocationSites && this.arrayAllocationSite != null && this.arrayAllocationSite.isTyped() && (initialType = this.arrayAllocationSite.getInitialArrayType()) != null) {
                return JSArray.create(this.getContext(), realm, proto, initialType, ((AbstractWritableArray)initialType).allocateArray(length), (long)length);
            }
            return JSArray.createConstantEmptyArray(this.getContext(), realm, proto, this.arrayAllocationSite, length);
        }

        @Specialization(guards={"args.length == 1", "toArrayLengthNode.isTypeNumber(len)"}, replaces={"constructArrayWithIntLength"}, limit="1")
        protected JSObject constructWithLength(JSDynamicObject newTarget, Object[] args, @Cached ToArrayLengthNode toArrayLengthNode, @Cached(value="create(getContext())") @Cached.Shared(value="arrayCreate") ArrayCreateNode arrayCreateNode, @Bind(value="toArrayLengthNode.executeLong(firstArg(args))") long len) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return arrayCreateNode.execute(len, realm, proto);
        }

        static Object firstArg(Object[] arguments) {
            return arguments[0];
        }

        @Specialization(guards={"isOneForeignArg(args)"}, limit="InteropLibraryLimit")
        protected JSObject constructWithForeignArg(JSDynamicObject newTarget, Object[] args, @Bind(value="this") Node node, @CachedLibrary(value="firstArg(args)") InteropLibrary interop, @Cached(value="create(getContext())") @Cached.Shared(value="arrayCreate") ArrayCreateNode arrayCreateNode, @Cached @Cached.Exclusive InlinedConditionProfile isNumber, @Cached @Cached.Exclusive InlinedBranchProfile rangeErrorProfile) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            Object len = args[0];
            if (isNumber.profile(node, interop.isNumber(len))) {
                if (interop.fitsInLong(len)) {
                    try {
                        long length = interop.asLong(len);
                        if (JSRuntime.isArrayIndex(length)) {
                            return arrayCreateNode.execute(length, realm, proto);
                        }
                    }
                    catch (UnsupportedMessageException umex) {
                        rangeErrorProfile.enter(node);
                        throw Errors.createTypeErrorInteropException(len, (InteropException)((Object)umex), "asLong", this);
                    }
                }
                rangeErrorProfile.enter(node);
                throw Errors.createRangeErrorInvalidArrayLength(this);
            }
            return JSArray.create(this.getContext(), realm, proto, ConstantObjectArray.createConstantObjectArray(), args, 1L);
        }

        @Specialization(guards={"!isOneNumberArg(args)", "!isOneForeignArg(args)"})
        protected JSObject constructArrayVarargs(JSDynamicObject newTarget, Object[] args, @Cached @Cached.Exclusive InlinedBranchProfile isIntegerCase, @Cached @Cached.Exclusive InlinedBranchProfile isDoubleCase, @Cached @Cached.Exclusive InlinedBranchProfile isObjectCase, @Cached @Cached.Exclusive InlinedConditionProfile isLengthZero) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            if (isLengthZero.profile((Node)this, args == null || args.length == 0)) {
                return JSArray.create(this.getContext(), realm, proto, ScriptArray.createConstantEmptyArray(), args, 0L);
            }
            ArrayLiteralNode.ArrayContentType type = ArrayLiteralNode.identifyPrimitiveContentType(args, false);
            if (type == ArrayLiteralNode.ArrayContentType.Integer) {
                isIntegerCase.enter((Node)this);
                return JSArray.createZeroBasedIntArray(this.getContext(), realm, proto, ArrayLiteralNode.createIntArray(args));
            }
            if (type == ArrayLiteralNode.ArrayContentType.Double) {
                isDoubleCase.enter((Node)this);
                return JSArray.createZeroBasedDoubleArray(this.getContext(), realm, proto, ArrayLiteralNode.createDoubleArray(args));
            }
            isObjectCase.enter((Node)this);
            return JSArray.create(this.getContext(), realm, proto, ConstantObjectArray.createConstantObjectArray(), args, (long)args.length);
        }

        @Override
        protected JSDynamicObject getPrototype(JSRealm realm, JSDynamicObject newTarget) {
            JSDynamicObject prototype = super.getPrototype(realm, newTarget);
            assert (prototype != Null.instance);
            if (this.isNewTargetCase) {
                if (this.getContext().getArrayPrototypeNoElementsAssumption().isValid() && !JSShape.isArrayPrototypeOrDerivative(prototype)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getContext().getArrayPrototypeNoElementsAssumption().invalidate("Unexpected Array prototype");
                }
            } else assert (JSArray.isArrayPrototype(prototype));
            return prototype;
        }

        @Override
        public JavaScriptNode copy() {
            ConstructArrayNode copy = (ConstructArrayNode)super.copy();
            copy.arrayAllocationSite = ConstructArrayNode.createAllocationSite();
            return copy;
        }

        private static ConstructArrayAllocationSite createAllocationSite() {
            return JSConfig.TrackArrayAllocationSites ? new ConstructArrayAllocationSite() : null;
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getArrayPrototype();
        }

        private static final class ConstructArrayAllocationSite
        implements ArrayAllocationSite {
            private static final ScriptArray UNINIT_ARRAY_TYPE = ScriptArray.createConstantEmptyArray();
            @CompilerDirectives.CompilationFinal
            private ScriptArray concreteArrayType = UNINIT_ARRAY_TYPE;
            @CompilerDirectives.CompilationFinal
            private Assumption assumption = Truffle.getRuntime().createAssumption("Array allocation site (untyped)");

            private ConstructArrayAllocationSite() {
            }

            public boolean isTyped() {
                return this.assumption.isValid() && this.concreteArrayType != UNINIT_ARRAY_TYPE && this.concreteArrayType != null;
            }

            @Override
            public void notifyArrayTransition(ScriptArray arrayType, int length) {
                CompilerAsserts.neverPartOfCompilation((String)"do not notify array transitions from compiled code");
                assert (JSConfig.TrackArrayAllocationSites);
                if (arrayType instanceof AbstractWritableArray && length > 0) {
                    if (this.concreteArrayType == UNINIT_ARRAY_TYPE) {
                        this.concreteArrayType = arrayType;
                        this.assumption.invalidate("TypedArray type initialization");
                        this.assumption = Truffle.getRuntime().createAssumption("Array allocation site (typed)");
                    } else if (this.concreteArrayType != arrayType) {
                        this.concreteArrayType = null;
                        this.assumption.invalidate("TypedArray type rewrite");
                    }
                }
            }

            @Override
            public ScriptArray getInitialArrayType() {
                if (this.isTyped()) {
                    return this.concreteArrayType;
                }
                return null;
            }
        }
    }

    public static abstract class ConstructBooleanNode
    extends ConstructWithNewTargetNode {
        public ConstructBooleanNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected JSBooleanObject constructBoolean(JSDynamicObject newTarget, Object value, @Cached(inline=true) JSToBooleanNode toBoolean) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSBoolean.create(this.getContext(), realm, proto, toBoolean.executeBoolean(this, value));
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getBooleanPrototype();
        }
    }

    public static abstract class CallBooleanNode
    extends JSBuiltinNode {
        public CallBooleanNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean callBoolean(Object value, @Cached(inline=true) JSToBooleanNode toBoolean) {
            return toBoolean.executeBoolean(this, value);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ConstructDateNode
    extends ConstructWithNewTargetNode {
        public ConstructDateNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization(guards={"args.length == 0"})
        protected final JSObject constructDateZero(JSDynamicObject newTarget, Object[] args) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSDate.create(this.getContext(), realm, proto, this.now());
        }

        protected static Object arg0(Object[] args) {
            return args[0];
        }

        @Specialization(guards={"args.length == 1", "isJSDate(arg0(args))"})
        protected final JSObject constructDateFromDate(JSDynamicObject newTarget, Object[] args) {
            double dateValue = JSDate.getTimeMillisField((JSDateObject)((Object)args[0]));
            assert (JSRuntime.isSameValue(JSDate.timeClip(dateValue), dateValue));
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSDate.create(this.getContext(), realm, proto, dateValue);
        }

        @Specialization(guards={"args.length == 1", "!isJSDate(arg0(args))"})
        protected final JSObject constructDateOne(JSDynamicObject newTarget, Object[] args, @Cached InlinedConditionProfile isSpecialCase, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached InlinedConditionProfile stringOrNumberProfile, @Cached(value="createHintDefault()") JSToPrimitiveNode toPrimitiveNode, @Cached @Cached.Shared JSToDoubleNode toDoubleNode) {
            Object value;
            Object arg0 = args[0];
            double rawDateValue = this.getContext().getEcmaScriptVersion() >= 6 && interop.isInstant(arg0) ? JSDate.getDateValueFromInstant(arg0, interop) : (stringOrNumberProfile.profile((Node)this, (value = toPrimitiveNode.execute(arg0)) instanceof TruffleString) ? this.parseDate((TruffleString)value) : toDoubleNode.executeDouble(value));
            double dateValue = this.timeClip(rawDateValue, isSpecialCase);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSDate.create(this.getContext(), realm, proto, dateValue);
        }

        @Specialization(guards={"args.length >= 2"})
        protected final JSObject constructDateMult(JSDynamicObject newTarget, Object[] args, @Cached @Cached.Shared JSToDoubleNode toDoubleNode) {
            double dateValue = ConstructDateNode.constructorImpl(args, toDoubleNode);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSDate.create(this.getContext(), realm, proto, dateValue);
        }

        private double timeClip(double dateValue, InlinedConditionProfile isSpecialCase) {
            if (isSpecialCase.profile((Node)this, Double.isInfinite(dateValue) || Double.isNaN(dateValue) || Math.abs(dateValue) > 8.64E15)) {
                return Double.NaN;
            }
            return (long)dateValue;
        }

        @CompilerDirectives.TruffleBoundary
        private double now() {
            return this.getRealm().currentTimeMillis();
        }

        @CompilerDirectives.TruffleBoundary
        private double parseDate(TruffleString target) {
            Integer[] fields = this.getContext().getEvaluator().parseDate(this.getRealm(), Strings.toJavaString(Strings.lazyTrim(target)), false);
            if (fields != null) {
                return JSDate.makeDate(fields[0].intValue(), fields[1].intValue(), fields[2].intValue(), fields[3].intValue(), fields[4].intValue(), fields[5].intValue(), fields[6].intValue(), fields[7]);
            }
            return Double.NaN;
        }

        private static double constructorImpl(Object[] args, JSToDoubleNode toDoubleNode) {
            double[] argsEvaluated = new double[args.length];
            boolean isNaN = false;
            for (int i = 0; i < args.length; ++i) {
                double d = toDoubleNode.executeDouble(args[i]);
                if (Double.isNaN(d)) {
                    isNaN = true;
                }
                argsEvaluated[i] = d;
            }
            if (isNaN) {
                return Double.NaN;
            }
            return JSDate.executeConstructor(argsEvaluated, false);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getDatePrototype();
        }
    }

    public static abstract class CallDateNode
    extends JSBuiltinNode {
        public CallDateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object callDate() {
            JSRealm realm = this.getRealm();
            return JSDate.toString(realm.currentTimeMillis(), realm);
        }
    }

    public static abstract class ConstructRegExpNode
    extends ConstructWithNewTargetNode {
        private final boolean isCall;
        @Node.Child
        private JSToStringNode patternToStringNode;
        @Node.Child
        private JSToStringNode flagsToStringNode;
        @Node.Child
        private CompileRegexNode compileRegexNode;
        @Node.Child
        private CreateRegExpNode createRegExpNode;
        @Node.Child
        private PropertyGetNode getConstructorNode;
        @Node.Child
        private PropertyGetNode getSourceNode;
        @Node.Child
        private PropertyGetNode getFlagsNode;

        public ConstructRegExpNode(JSContext context, JSBuiltin builtin, boolean isCall, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
            this.isCall = isCall;
        }

        @Specialization
        protected JSObject constructRegExp(JSDynamicObject newTarget, Object pattern, Object flags, @Bind(value="this") Node node, @Cached(value="create(getContext())") IsRegExpNode isRegExpNode, @Cached InlinedBranchProfile regexpObject, @Cached InlinedBranchProfile regexpMatcherObject, @Cached InlinedBranchProfile regexpNonObject, @Cached InlinedBranchProfile regexpObjectNewFlagsBranch, @Cached InlinedConditionProfile callIsRegExpProfile, @Cached InlinedConditionProfile constructorEquivalentProfile, @Cached(inline=true) TRegexUtil.InteropReadStringMemberNode readPattern) {
            Object f;
            Object p;
            boolean legacyFeaturesEnabled;
            JSRealm realm = this.getRealm();
            boolean hasMatchSymbol = isRegExpNode.executeBoolean(pattern);
            if (this.isCall) {
                JSObject patternObj;
                Object patternConstructor;
                if (callIsRegExpProfile.profile(node, hasMatchSymbol && flags == Undefined.instance && pattern instanceof JSObject) && constructorEquivalentProfile.profile(node, (patternConstructor = this.getConstructor(patternObj = (JSObject)((Object)pattern))) == realm.getRegExpConstructor())) {
                    return patternObj;
                }
                legacyFeaturesEnabled = true;
            } else {
                boolean bl = legacyFeaturesEnabled = newTarget == realm.getRegExpConstructor();
            }
            if (JSRegExp.isJSRegExp(pattern)) {
                regexpObject.enter(node);
                Object compiledRegex = JSRegExp.getCompiledRegex((JSRegExpObject)pattern);
                if (flags != Undefined.instance) {
                    regexpObjectNewFlagsBranch.enter(node);
                    if (this.getContext().getEcmaScriptVersion() < 6) {
                        throw Errors.createTypeError("Cannot supply flags when constructing one RegExp from another");
                    }
                    Object flagsStr = this.flagsToString(flags);
                    TruffleString patternStr = readPattern.execute(node, compiledRegex, "pattern");
                    compiledRegex = this.getCompileRegexNode().compile(patternStr, flagsStr);
                }
                JSDynamicObject proto = this.getPrototype(realm, newTarget);
                return this.getCreateRegExpNode().createRegExp(compiledRegex, legacyFeaturesEnabled, realm, proto);
            }
            if (hasMatchSymbol) {
                regexpMatcherObject.enter(node);
                JSObject patternJSObj = (JSObject)((Object)pattern);
                p = this.getSource(patternJSObj);
                f = flags == Undefined.instance ? this.getFlags(patternJSObj) : flags;
            } else {
                regexpNonObject.enter(node);
                p = pattern;
                f = flags;
            }
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            TruffleString patternStr = this.getPatternToStringNode().executeString(p);
            Object flagsStr = this.flagsToString(f);
            Object compiledRegex = this.getCompileRegexNode().compile(patternStr, flagsStr);
            JSRegExpObject regExp = this.getCreateRegExpNode().createRegExp(compiledRegex, legacyFeaturesEnabled, realm, proto);
            if (this.getContext().getLanguageOptions().testV8Mode()) {
                JSObjectUtil.putDataProperty(regExp, Strings.SOURCE, JSRegExp.escapeRegExpPattern(patternStr), JSAttributes.configurableNotEnumerableNotWritable());
            }
            return regExp;
        }

        private JSToStringNode getPatternToStringNode() {
            if (this.patternToStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.patternToStringNode = (JSToStringNode)this.insert(JSToStringNode.createUndefinedToEmpty());
            }
            return this.patternToStringNode;
        }

        private CompileRegexNode getCompileRegexNode() {
            if (this.compileRegexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.compileRegexNode = (CompileRegexNode)this.insert(CompileRegexNode.create(this.getContext()));
            }
            return this.compileRegexNode;
        }

        private CreateRegExpNode getCreateRegExpNode() {
            if (this.createRegExpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.createRegExpNode = (CreateRegExpNode)this.insert(CreateRegExpNode.create(this.getContext()));
            }
            return this.createRegExpNode;
        }

        private Object flagsToString(Object f) {
            if (this.flagsToStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.flagsToStringNode = (JSToStringNode)this.insert(JSToStringNode.createUndefinedToEmpty());
            }
            return this.flagsToStringNode.executeString(f);
        }

        private Object getConstructor(JSDynamicObject obj) {
            if (this.getConstructorNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getConstructorNode = (PropertyGetNode)this.insert(PropertyGetNode.create(JSObject.CONSTRUCTOR, this.getContext()));
            }
            return this.getConstructorNode.getValue((Object)obj);
        }

        private Object getSource(JSDynamicObject obj) {
            if (this.getSourceNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getSourceNode = (PropertyGetNode)this.insert(PropertyGetNode.create(JSRegExp.SOURCE, this.getContext()));
            }
            return this.getSourceNode.getValue((Object)obj);
        }

        private Object getFlags(JSDynamicObject obj) {
            if (this.getFlagsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getFlagsNode = (PropertyGetNode)this.insert(PropertyGetNode.create(JSRegExp.FLAGS, this.getContext()));
            }
            return this.getFlagsNode.getValue((Object)obj);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getRegExpPrototype();
        }
    }

    public static abstract class ConstructStringNode
    extends ConstructWithNewTargetNode {
        public ConstructStringNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
        }

        @Specialization(guards={"args.length == 0"})
        protected JSStringObject constructStringInt0(JSDynamicObject newTarget, Object[] args) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSString.create(this.getContext(), realm, proto, Strings.EMPTY_STRING);
        }

        @Specialization(guards={"args.length != 0"})
        protected JSStringObject constructString(JSDynamicObject newTarget, Object[] args, @Cached JSToStringNode toStringNode) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSString.create(this.getContext(), realm, proto, toStringNode.executeString(args[0]));
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getStringPrototype();
        }
    }

    public static abstract class CallStringNode
    extends JSBuiltinNode {
        public CallStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"args.length == 0"})
        protected Object callStringInt0(Object[] args) {
            return Strings.EMPTY_STRING;
        }

        @Specialization(guards={"args.length != 0"})
        protected Object callStringGeneric(Object[] args, @Cached(value="createSymbolToString()") JSToStringNode toStringNode) {
            return toStringNode.executeString(args[0]);
        }
    }

    public static abstract class ConstructWeakRefNode
    extends ConstructWithNewTargetNode {
        public ConstructWeakRefNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, target)"}, limit="1")
        protected JSObject constructWeakRef(JSDynamicObject newTarget, Object target, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSWeakRef.create(this.getContext(), realm, proto, target);
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, target)"}, limit="1")
        protected static JSObject constructWeakRefNonObject(JSDynamicObject newTarget, Object target, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            throw Errors.createTypeError("WeakRef: invalid target");
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getWeakRefPrototype();
        }
    }

    public static abstract class ConstructFinalizationRegistryNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        protected IsCallableNode isCallableNode = IsCallableNode.create();

        public ConstructFinalizationRegistryNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
        }

        @Specialization(guards={"isCallableNode.executeBoolean(cleanupCallback)"})
        protected JSObject constructFinalizationRegistry(JSDynamicObject newTarget, Object cleanupCallback) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSFinalizationRegistry.create(this.getContext(), realm, proto, realm.getAgent().hostMakeJobCallback(cleanupCallback));
        }

        @Specialization(guards={"!isCallableNode.executeBoolean(cleanupCallback)"})
        protected JSObject constructFinalizationRegistryNonObject(JSDynamicObject newTarget, Object cleanupCallback) {
            throw Errors.createTypeError("FinalizationRegistry: cleanup must be callable");
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getFinalizationRegistryPrototype();
        }
    }

    public static abstract class ConstructCollatorNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        InitializeCollatorNode initializeCollatorNode;

        public ConstructCollatorNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.initializeCollatorNode = InitializeCollatorNode.createInitalizeCollatorNode(context);
        }

        @Specialization
        protected JSCollatorObject constructCollator(JSDynamicObject newTarget, Object locales, Object options) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            JSCollatorObject collator = JSCollator.create(this.getContext(), realm, proto);
            return this.initializeCollatorNode.executeInit(collator, locales, options);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getCollatorPrototype();
        }
    }

    public static abstract class ConstructListFormatNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        InitializeListFormatNode initializeListFormatNode;

        public ConstructListFormatNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.initializeListFormatNode = InitializeListFormatNode.createInitalizeListFormatNode(context);
        }

        @Specialization
        protected JSListFormatObject constructListFormat(JSDynamicObject newTarget, Object locales, Object options) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            JSListFormatObject listFormat = JSListFormat.create(this.getContext(), realm, proto);
            return this.initializeListFormatNode.executeInit(listFormat, locales, options);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getListFormatPrototype();
        }
    }

    public static abstract class ConstructNumberFormatNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        InitializeNumberFormatNode initializeNumberFormatNode;

        public ConstructNumberFormatNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.initializeNumberFormatNode = InitializeNumberFormatNode.createInitalizeNumberFormatNode(context);
        }

        @Specialization
        protected JSNumberFormatObject constructNumberFormat(JSDynamicObject newTarget, Object locales, Object options) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            JSNumberFormatObject numberFormat = JSNumberFormat.create(this.getContext(), realm, proto);
            return this.initializeNumberFormatNode.executeInit(numberFormat, locales, options);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getNumberFormatPrototype();
        }
    }

    public static abstract class ConstructPluralRulesNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        InitializePluralRulesNode initializePluralRulesNode;

        public ConstructPluralRulesNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.initializePluralRulesNode = InitializePluralRulesNode.createInitalizePluralRulesNode(context);
        }

        @Specialization
        protected JSPluralRulesObject constructPluralRules(JSDynamicObject newTarget, Object locales, Object options) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            JSPluralRulesObject pluralRules = JSPluralRules.create(this.getContext(), realm, proto);
            return this.initializePluralRulesNode.executeInit(pluralRules, locales, options);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getPluralRulesPrototype();
        }
    }

    public static abstract class ConstructDateTimeFormatNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        InitializeDateTimeFormatNode initializeDateTimeFormatNode;

        public ConstructDateTimeFormatNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.initializeDateTimeFormatNode = InitializeDateTimeFormatNode.createInitalizeDateTimeFormatNode(context, InitializeDateTimeFormatNode.Required.ANY, InitializeDateTimeFormatNode.Defaults.DATE);
        }

        @Specialization
        protected JSDateTimeFormatObject constructDateTimeFormat(JSDynamicObject newTarget, Object locales, Object options) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            JSDateTimeFormatObject dateTimeFormat = JSDateTimeFormat.create(this.getContext(), realm, proto);
            return this.initializeDateTimeFormatNode.executeInit(dateTimeFormat, locales, options);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getDateTimeFormatPrototype();
        }
    }

    public static abstract class ConstructRelativeTimeFormatNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        InitializeRelativeTimeFormatNode initializeRelativeTimeFormatNode;

        public ConstructRelativeTimeFormatNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.initializeRelativeTimeFormatNode = InitializeRelativeTimeFormatNode.createInitalizeRelativeTimeFormatNode(context);
        }

        @Specialization
        protected JSRelativeTimeFormatObject constructRelativeTimeFormat(JSDynamicObject newTarget, Object locales, Object options) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            JSRelativeTimeFormatObject listFormat = JSRelativeTimeFormat.create(this.getContext(), realm, proto);
            return this.initializeRelativeTimeFormatNode.executeInit(listFormat, locales, options);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getRelativeTimeFormatPrototype();
        }
    }

    public static abstract class ConstructSegmenterNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        InitializeSegmenterNode initializeSegmenterNode;

        public ConstructSegmenterNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.initializeSegmenterNode = InitializeSegmenterNode.createInitalizeSegmenterNode(context);
        }

        @Specialization
        protected JSSegmenterObject constructSegmenter(JSDynamicObject newTarget, Object locales, Object options) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            JSSegmenterObject segmenter = JSSegmenter.create(this.getContext(), realm, proto);
            return this.initializeSegmenterNode.executeInit(segmenter, locales, options);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getSegmenterPrototype();
        }
    }

    public static abstract class ConstructDisplayNamesNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        InitializeDisplayNamesNode initializeDisplayNamesNode;

        public ConstructDisplayNamesNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.initializeDisplayNamesNode = InitializeDisplayNamesNode.createInitalizeDisplayNamesNode(context);
        }

        @Specialization
        protected JSDisplayNamesObject constructDisplayNames(JSDynamicObject newTarget, Object locales, Object options) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            JSDisplayNamesObject displayNames = JSDisplayNames.create(this.getContext(), realm, proto);
            return this.initializeDisplayNamesNode.executeInit(displayNames, locales, options);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getDisplayNamesPrototype();
        }
    }

    public static abstract class ConstructLocaleNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        InitializeLocaleNode initializeLocaleNode;

        public ConstructLocaleNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.initializeLocaleNode = InitializeLocaleNode.createInitalizeLocaleNode(context);
        }

        @Specialization
        protected JSLocaleObject constructLocale(JSDynamicObject newTarget, Object tag, Object options) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            JSLocaleObject locale = JSLocale.create(this.getContext(), realm, proto);
            return this.initializeLocaleNode.executeInit(locale, tag, options);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getLocalePrototype();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ConstructObjectNode
    extends ConstructWithNewTargetNode {
        public ConstructObjectNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        protected static boolean arg0NullOrUndefined(Object[] args) {
            Object arg0 = args[0];
            return arg0 == Undefined.instance || arg0 == Null.instance;
        }

        protected static Object firstArgument(Object[] arguments) {
            return arguments.length == 0 ? Undefined.instance : arguments[0];
        }

        @Specialization(guards={"isNewTargetCase"})
        protected JSObject constructObjectNewTarget(JSDynamicObject newTarget, Object[] arguments) {
            return this.newObject(newTarget);
        }

        @Specialization(guards={"arguments.length == 0"})
        protected JSObject constructObject0(JSDynamicObject newTarget, Object[] arguments) {
            return this.newObject(newTarget);
        }

        @Specialization(guards={"!isNewTargetCase", "arguments.length > 0", "!arg0NullOrUndefined(arguments)"}, limit="InteropLibraryLimit")
        protected Object constructObjectJSObject(JSDynamicObject newTarget, Object[] arguments, @Bind(value="this") Node node, @Cached JSToObjectNode toObjectNode, @CachedLibrary(value="firstArgument(arguments)") InteropLibrary interop, @Cached InlinedConditionProfile isNull) {
            Object arg0 = arguments[0];
            if (isNull.profile(node, interop.isNull(arg0))) {
                return this.newObject(Null.instance);
            }
            return toObjectNode.execute(arg0);
        }

        @Specialization(guards={"arguments.length > 0", "arg0NullOrUndefined(arguments)"})
        protected JSObject constructObjectNullOrUndefined(JSDynamicObject newTarget, Object[] arguments) {
            return this.newObject(newTarget);
        }

        private JSObject newObject(JSDynamicObject newTarget) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSOrdinary.create(this.getContext(), realm, proto);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getObjectPrototype();
        }
    }

    public static abstract class ConstructNumberNode
    extends ConstructWithNewTargetNode {
        public ConstructNumberNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization(guards={"args.length == 0"})
        protected JSNumberObject constructNumberZero(JSDynamicObject newTarget, Object[] args) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSNumber.create(this.getContext(), realm, proto, 0);
        }

        @Specialization(guards={"args.length > 0"})
        protected JSNumberObject constructNumber(JSDynamicObject newTarget, Object[] args, @Cached JSToNumericNode toNumericNode, @Cached JSNumericToNumberNode toNumberFromNumericNode) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            Number number = toNumberFromNumericNode.executeNumeric(toNumericNode.execute(args[0]));
            return JSNumber.create(this.getContext(), realm, proto, number);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getNumberPrototype();
        }
    }

    public static abstract class CallNumberNode
    extends JSBuiltinNode {
        public CallNumberNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"args.length == 0"})
        protected int callNumberZero(Object[] args) {
            return 0;
        }

        @Specialization(guards={"args.length > 0"})
        protected Number callNumber(Object[] args, @Cached JSToNumericNode toNumericNode, @Cached JSNumericToNumberNode toNumberFromNumericNode) {
            return toNumberFromNumericNode.executeNumeric(toNumericNode.execute(args[0]));
        }
    }

    public static abstract class ConstructBigIntNode
    extends JSBuiltinNode {
        public ConstructBigIntNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static final JSDynamicObject construct() {
            throw Errors.createTypeError("BigInt is not a constructor");
        }
    }

    public static abstract class CallBigIntNode
    extends JSBuiltinNode {
        public CallBigIntNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static BigInt doBigInt(BigInt value) {
            return value;
        }

        @Specialization
        protected final BigInt toBigInt(Object value, @Cached JSToBigIntNode.CoercePrimitiveToBigIntNode toBigIntNode, @Cached(value="createHintNumber()") JSToPrimitiveNode toPrimitiveNode) {
            Object primitive = toPrimitiveNode.execute(value);
            return toBigIntNode.executeBigInt(this, primitive);
        }
    }

    public static abstract class ConstructFunctionNode
    extends ConstructWithNewTargetNode {
        private final boolean generatorFunction;
        private final boolean asyncFunction;
        @Node.Child
        private JSToStringNode toStringNode;
        @Node.Child
        private CreateDynamicFunctionNode functionNode;

        public ConstructFunctionNode(JSContext context, JSBuiltin builtin, boolean generatorFunction, boolean asyncFunction, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
            this.generatorFunction = generatorFunction;
            this.asyncFunction = asyncFunction;
            this.toStringNode = JSToStringNode.create();
            this.functionNode = ConstructorBuiltinsFactory.CreateDynamicFunctionNodeGen.create(context, generatorFunction, asyncFunction);
        }

        @Specialization
        protected final JSFunctionObject constructFunction(JSDynamicObject newTarget, Object[] args, @Cached InlinedConditionProfile hasArgsProfile, @Cached InlinedConditionProfile hasParamsProfile) {
            TruffleString paramList;
            TruffleString body;
            TruffleString[] params;
            int argc = args.length;
            if (hasArgsProfile.profile((Node)this, argc > 0)) {
                params = new TruffleString[argc - 1];
                for (int i = 0; i < argc - 1; ++i) {
                    params[i] = this.toStringNode.executeString(args[i]);
                }
                body = this.toStringNode.executeString(args[argc - 1]);
            } else {
                params = new TruffleString[]{};
                body = Strings.EMPTY_STRING;
            }
            TruffleString truffleString = paramList = hasParamsProfile.profile((Node)this, argc > 1) ? ConstructFunctionNode.join(params) : Strings.EMPTY_STRING;
            assert (this.isCallerSensitive());
            Node callNode = EvalNode.findCallNode(this.getRealm());
            String sourceName = EvalNode.formatEvalOrigin(callNode, this.getContext(), "<function>");
            ScriptOrModule activeScriptOrModule = EvalNode.findActiveScriptOrModule(callNode);
            JSFunctionObject functionObj = this.functionNode.executeFunction(Strings.toJavaString(paramList), Strings.toJavaString(body), sourceName, activeScriptOrModule);
            return this.swapPrototype(functionObj, newTarget);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString join(TruffleString[] params) {
            assert (params.length > 0);
            TruffleStringBuilderUTF16 sb = Strings.builderCreate();
            Strings.builderAppend(sb, params[0]);
            for (int i = 1; i < params.length; ++i) {
                Strings.builderAppend(sb, Strings.COMMA);
                Strings.builderAppend(sb, params[i]);
            }
            return Strings.builderToString(sb);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            if (this.generatorFunction && this.asyncFunction) {
                return realm.getAsyncGeneratorFunctionPrototype();
            }
            if (this.generatorFunction) {
                return realm.getGeneratorFunctionPrototype();
            }
            if (this.asyncFunction) {
                return realm.getAsyncFunctionPrototype();
            }
            return realm.getFunctionPrototype();
        }

        @Override
        public boolean isCallerSensitive() {
            return true;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ConstructArrayBufferNode
    extends ConstructWithNewTargetNode {
        private final boolean useShared;

        public ConstructArrayBufferNode(JSContext context, JSBuiltin builtin, boolean useShared, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
            this.useShared = useShared;
        }

        @Specialization(guards={"!bufferInterop.hasBufferElements(length)"})
        protected JSDynamicObject constructFromLength(JSDynamicObject newTarget, Object length, @Cached JSToIndexNode toIndexNode, @Cached @Cached.Shared(value="errorBranch") InlinedBranchProfile errorBranch, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="bufferInterop") InteropLibrary bufferInterop) {
            long byteLength = toIndexNode.executeLong(length);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            if (byteLength > (long)this.getContext().getLanguageOptions().maxTypedArrayLength()) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeError("Array buffer allocation failed");
            }
            JSContext contextFromNewTarget = this.getContext();
            JSArrayBufferObject arrayBuffer = this.useShared ? JSSharedArrayBuffer.createSharedArrayBuffer(contextFromNewTarget, realm, proto, (int)byteLength) : (this.getContext().isOptionDirectByteBuffer() ? JSArrayBuffer.createDirectArrayBuffer(contextFromNewTarget, realm, proto, (int)byteLength) : JSArrayBuffer.createArrayBuffer(contextFromNewTarget, realm, proto, (int)byteLength));
            return arrayBuffer;
        }

        @Specialization(guards={"bufferInterop.hasBufferElements(buffer)"})
        protected JSDynamicObject constructFromInteropBuffer(JSDynamicObject newTarget, Object buffer, @Cached @Cached.Shared(value="errorBranch") InlinedBranchProfile errorBranch, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="bufferInterop") InteropLibrary bufferInterop) {
            ConstructArrayBufferNode.getBufferSizeSafe(buffer, bufferInterop, this, errorBranch);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSArrayBuffer.createInteropArrayBuffer(this.getContext(), realm, proto, buffer);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return this.useShared ? realm.getSharedArrayBufferPrototype() : realm.getArrayBufferPrototype();
        }

        static int getBufferSizeSafe(Object buffer, InteropLibrary bufferInterop, Node node, InlinedBranchProfile errorBranch) {
            try {
                long bufferSize = bufferInterop.getBufferSize(buffer);
                if (bufferSize < 0L || bufferSize > Integer.MAX_VALUE) {
                    errorBranch.enter(node);
                    throw Errors.createRangeErrorInvalidBufferSize();
                }
                return (int)bufferSize;
            }
            catch (UnsupportedMessageException e) {
                return 0;
            }
        }
    }

    public static abstract class ConstructErrorNode
    extends ConstructWithNewTargetNode {
        private final JSErrorType errorType = JSErrorType.valueOf(Strings.toJavaString(this.getBuiltin().getName()));
        @Node.Child
        private ErrorStackTraceLimitNode stackTraceLimitNode = ErrorStackTraceLimitNode.create();
        @Node.Child
        private InitErrorObjectNode initErrorObjectNode;

        public ConstructErrorNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
            this.initErrorObjectNode = InitErrorObjectNode.create(context);
            assert (this.errorType != JSErrorType.AggregateError);
        }

        @Specialization
        protected JSDynamicObject constructError(JSDynamicObject newTarget, TruffleString message, Object options) {
            return this.constructErrorImpl(newTarget, message, options);
        }

        @Specialization(guards={"!isString(message)"})
        protected JSDynamicObject constructError(JSDynamicObject newTarget, Object message, Object options, @Cached JSToStringNode toStringNode) {
            return this.constructErrorImpl(newTarget, message == Undefined.instance ? null : toStringNode.executeString(message), options);
        }

        private JSDynamicObject constructErrorImpl(JSDynamicObject newTarget, TruffleString messageOpt, Object options) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            JSErrorObject errorObj = JSError.createErrorObject(this.getContext(), realm, this.errorType, proto);
            int stackTraceLimit = this.stackTraceLimitNode.executeInt();
            JSFunctionObject errorFunction = realm.getErrorConstructor(this.errorType);
            JSDynamicObject skipUntil = newTarget == Undefined.instance ? errorFunction : newTarget;
            JSException exception = JSException.createCapture(this.errorType, Strings.toJavaString(messageOpt), errorObj, realm, stackTraceLimit, skipUntil, skipUntil != errorFunction);
            return this.initErrorObjectNode.execute(errorObj, exception, messageOpt, null, options);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getErrorPrototype(this.errorType);
        }

        @Override
        public boolean countsTowardsStackTraceLimit() {
            return false;
        }
    }

    @ImportStatic(value={Strings.class})
    public static abstract class ConstructAggregateErrorNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        private ErrorStackTraceLimitNode stackTraceLimitNode = ErrorStackTraceLimitNode.create();
        @Node.Child
        private InitErrorObjectNode initErrorObjectNode;
        @Node.Child
        private DynamicObjectLibrary setMessage;
        @Node.Child
        private InstallErrorCauseNode installErrorCauseNode;

        public ConstructAggregateErrorNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
            this.initErrorObjectNode = InitErrorObjectNode.create(context);
            this.setMessage = JSObjectUtil.createDispatched(JSError.MESSAGE);
        }

        @Specialization
        protected JSDynamicObject constructError(JSDynamicObject newTarget, Object errorsObj, Object messageObj, Object options, @Cached JSToStringNode toStringNode, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached IterableToListNode iterableToListNode) {
            TruffleString message;
            JSContext context = this.getContext();
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            JSErrorObject errorObj = JSError.createErrorObject(context, realm, JSErrorType.AggregateError, proto);
            if (messageObj == Undefined.instance) {
                message = null;
            } else {
                message = toStringNode.executeString(messageObj);
                this.setMessage.putWithFlags((DynamicObject)errorObj, (Object)JSError.MESSAGE, (Object)message, JSError.MESSAGE_ATTRIBUTES);
            }
            if (context.getLanguageOptions().errorCause() && options != Undefined.instance) {
                this.installErrorCause(errorObj, options);
            }
            IteratorRecord iterator = getIteratorNode.execute(this, errorsObj);
            SimpleArrayList<Object> errors = iterableToListNode.execute(iterator);
            JSArrayObject errorsArray = JSArray.createConstantObjectArray(context, this.getRealm(), errors.toArray());
            int stackTraceLimit = this.stackTraceLimitNode.executeInt();
            JSFunctionObject errorFunction = realm.getErrorConstructor(JSErrorType.AggregateError);
            JSDynamicObject skipUntil = newTarget == Undefined.instance ? errorFunction : newTarget;
            JSException exception = JSException.createCapture(JSErrorType.AggregateError, Strings.toJavaString(message), errorObj, realm, stackTraceLimit, skipUntil, skipUntil != errorFunction);
            this.initErrorObjectNode.execute(errorObj, exception, null, errorsArray);
            return errorObj;
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getErrorPrototype(JSErrorType.AggregateError);
        }

        @Override
        public boolean countsTowardsStackTraceLimit() {
            return false;
        }

        private void installErrorCause(JSObject errorObj, Object options) {
            if (this.installErrorCauseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.installErrorCauseNode = (InstallErrorCauseNode)this.insert(new InstallErrorCauseNode(this.getContext()));
            }
            this.installErrorCauseNode.executeVoid(errorObj, options);
        }
    }

    public static abstract class AbstractClassConstructorNode
    extends JSBuiltinNode {
        public AbstractClassConstructorNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        @Specialization
        protected final Object construct() {
            throw Errors.createTypeErrorFormat("Abstract class %s not directly constructable", this.getBuiltin().getName());
        }
    }

    @ImportStatic(value={JSArrayBuffer.class, JSConfig.class})
    public static abstract class ConstructDataViewNode
    extends ConstructWithNewTargetNode {
        public ConstructDataViewNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization(guards={"isJSHeapArrayBuffer(buffer)"})
        protected final JSDynamicObject ofHeapArrayBuffer(JSDynamicObject newTarget, JSArrayBufferObject buffer, Object byteOffset, Object byteLength, @Cached @Cached.Shared(value="errorBranch") InlinedBranchProfile errorBranch, @Cached @Cached.Shared(value="byteLengthCondition") InlinedConditionProfile byteLengthCondition, @Cached @Cached.Shared(value="offsetToIndexNode") JSToIndexNode offsetToIndexNode, @Cached @Cached.Shared(value="lengthToIndexNode") JSToIndexNode lengthToIndexNode) {
            return this.constructDataView(newTarget, buffer, byteOffset, byteLength, false, false, errorBranch, byteLengthCondition, offsetToIndexNode, lengthToIndexNode, null);
        }

        @Specialization(guards={"isJSDirectOrSharedArrayBuffer(buffer)"})
        protected final JSDynamicObject ofDirectArrayBuffer(JSDynamicObject newTarget, JSArrayBufferObject buffer, Object byteOffset, Object byteLength, @Cached @Cached.Shared(value="errorBranch") InlinedBranchProfile errorBranch, @Cached @Cached.Shared(value="byteLengthCondition") InlinedConditionProfile byteLengthCondition, @Cached @Cached.Shared(value="offsetToIndexNode") JSToIndexNode offsetToIndexNode, @Cached @Cached.Shared(value="lengthToIndexNode") JSToIndexNode lengthToIndexNode) {
            return this.constructDataView(newTarget, buffer, byteOffset, byteLength, true, false, errorBranch, byteLengthCondition, offsetToIndexNode, lengthToIndexNode, null);
        }

        @Specialization(guards={"isJSInteropArrayBuffer(buffer)"})
        protected final JSDynamicObject ofInteropArrayBuffer(JSDynamicObject newTarget, JSArrayBufferObject buffer, Object byteOffset, Object byteLength, @Cached @Cached.Shared(value="errorBranch") InlinedBranchProfile errorBranch, @Cached @Cached.Shared(value="byteLengthCondition") InlinedConditionProfile byteLengthCondition, @Cached @Cached.Shared(value="offsetToIndexNode") JSToIndexNode offsetToIndexNode, @Cached @Cached.Shared(value="lengthToIndexNode") JSToIndexNode lengthToIndexNode, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="bufferInterop") InteropLibrary bufferInterop) {
            return this.constructDataView(newTarget, buffer, byteOffset, byteLength, false, true, errorBranch, byteLengthCondition, offsetToIndexNode, lengthToIndexNode, bufferInterop);
        }

        @Specialization(guards={"!isJSAbstractBuffer(buffer)", "bufferInterop.hasBufferElements(buffer)"})
        protected final JSDynamicObject ofInteropBuffer(JSDynamicObject newTarget, Object buffer, Object byteOffset, Object byteLength, @Cached @Cached.Shared(value="errorBranch") InlinedBranchProfile errorBranch, @Cached @Cached.Shared(value="byteLengthCondition") InlinedConditionProfile byteLengthCondition, @Cached @Cached.Shared(value="offsetToIndexNode") JSToIndexNode offsetToIndexNode, @Cached @Cached.Shared(value="lengthToIndexNode") JSToIndexNode lengthToIndexNode, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="bufferInterop") InteropLibrary bufferInterop) {
            JSArrayBufferObject.Interop arrayBuffer = JSArrayBuffer.createInteropArrayBuffer(this.getContext(), this.getRealm(), buffer);
            return this.ofInteropArrayBuffer(newTarget, arrayBuffer, byteOffset, byteLength, errorBranch, byteLengthCondition, offsetToIndexNode, lengthToIndexNode, bufferInterop);
        }

        @Specialization(guards={"!isJSAbstractBuffer(buffer)", "!bufferInterop.hasBufferElements(buffer)"})
        protected static JSDynamicObject error(JSDynamicObject newTarget, Object buffer, Object byteOffset, Object byteLength, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared(value="bufferInterop") InteropLibrary bufferInterop) {
            throw Errors.createTypeError("Not an ArrayBuffer");
        }

        protected final JSDynamicObject constructDataView(JSDynamicObject newTarget, JSArrayBufferObject arrayBuffer, Object byteOffset, Object byteLength, boolean direct, boolean isInteropBuffer, InlinedBranchProfile errorBranch, InlinedConditionProfile byteLengthCondition, JSToIndexNode offsetToIndexNode, JSToIndexNode lengthToIndexNode, InteropLibrary bufferInterop) {
            long viewByteLength;
            long offset = offsetToIndexNode.executeLong(byteOffset);
            this.checkDetachedBuffer(arrayBuffer, errorBranch);
            int bufferByteLength = isInteropBuffer ? ConstructArrayBufferNode.getBufferSizeSafe(JSArrayBuffer.getInteropBuffer((Object)arrayBuffer), bufferInterop, this, errorBranch) : (direct ? JSArrayBuffer.getDirectByteLength((Object)arrayBuffer) : JSArrayBuffer.getHeapByteLength((Object)arrayBuffer));
            if (offset > (long)bufferByteLength) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeError("offset > bufferByteLength");
            }
            if (byteLengthCondition.profile((Node)this, byteLength != Undefined.instance)) {
                viewByteLength = lengthToIndexNode.executeLong(byteLength);
                if (viewByteLength < 0L) {
                    errorBranch.enter((Node)this);
                    throw Errors.createRangeError("viewByteLength < 0");
                }
                if (offset + viewByteLength > (long)bufferByteLength) {
                    errorBranch.enter((Node)this);
                    throw Errors.createRangeError("offset + viewByteLength > bufferByteLength");
                }
            } else {
                viewByteLength = (long)bufferByteLength - offset;
            }
            assert (offset >= 0L && offset <= Integer.MAX_VALUE && viewByteLength >= 0L && viewByteLength <= Integer.MAX_VALUE);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            this.checkDetachedBuffer(arrayBuffer, errorBranch);
            return JSDataView.createDataView(this.getContext(), realm, proto, arrayBuffer, (int)offset, (int)viewByteLength);
        }

        private void checkDetachedBuffer(JSArrayBufferObject arrayBuffer, InlinedBranchProfile errorBranch) {
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorDetachedBuffer();
            }
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getDataViewPrototype();
        }
    }

    public static abstract class ConstructMapNode
    extends JSConstructIterableOperation {
        public ConstructMapNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization(guards={"isNullOrUndefined(iterable)"})
        protected JSObject constructEmptyMap(JSDynamicObject newTarget, Object iterable) {
            return this.newMapObject(newTarget);
        }

        @Specialization(guards={"!isNullOrUndefined(iterable)"})
        protected final JSObject constructMapFromIterable(JSDynamicObject newTarget, Object iterable, @Bind(value="this") Node node, @Cached(value="create(getContext())") ReadElementNode readElementNode, @Cached IsObjectNode isObjectNode, @Cached IsCallableNode isCallableNode, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached InlinedBranchProfile errorBranch) {
            JSObject mapObj = this.newMapObject(newTarget);
            Object adder = this.getAdderFn(mapObj, Strings.SET);
            if (!isCallableNode.executeBoolean(adder)) {
                errorBranch.enter(node);
                throw Errors.createTypeError("function set not callable");
            }
            IteratorRecord iter = getIteratorNode.execute(node, iterable);
            try {
                Object next;
                while ((next = this.iteratorStep(iter)) != Boolean.FALSE) {
                    Object nextItem = this.getIteratorValue(next);
                    if (!isObjectNode.executeBoolean(nextItem)) {
                        errorBranch.enter(node);
                        throw Errors.createTypeErrorIteratorResultNotObject(nextItem, this);
                    }
                    Object k = readElementNode.executeWithTargetAndIndex(nextItem, 0);
                    Object v = readElementNode.executeWithTargetAndIndex(nextItem, 1);
                    this.call((Object)mapObj, adder, k, v);
                }
            }
            catch (AbstractTruffleException ex) {
                this.iteratorCloseAbrupt(iter.getIterator());
                throw ex;
            }
            return mapObj;
        }

        protected JSObject newMapObject(JSDynamicObject newTarget) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSMap.create(this.getContext(), realm, proto);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getMapPrototype();
        }
    }

    public static abstract class ConstructSetNode
    extends JSConstructIterableOperation {
        public ConstructSetNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization(guards={"isNullOrUndefined(iterable)"})
        protected JSObject constructEmptySet(JSDynamicObject newTarget, Object iterable) {
            return this.newSetObject(newTarget);
        }

        @Specialization(guards={"!isNullOrUndefined(iterable)"})
        protected JSObject constructSetFromIterable(JSDynamicObject newTarget, Object iterable, @Bind(value="this") Node node, @Cached IsCallableNode isCallableNode, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached InlinedBranchProfile errorBranch) {
            JSObject setObj = this.newSetObject(newTarget);
            Object adder = this.getAdderFn(setObj, Strings.ADD);
            if (!isCallableNode.executeBoolean(adder)) {
                errorBranch.enter(node);
                throw Errors.createTypeError("function add not callable");
            }
            IteratorRecord iter = getIteratorNode.execute(node, iterable);
            try {
                Object next;
                while ((next = this.iteratorStep(iter)) != Boolean.FALSE) {
                    Object nextValue = this.getIteratorValue(next);
                    this.call((Object)setObj, adder, nextValue);
                }
            }
            catch (AbstractTruffleException ex) {
                this.iteratorCloseAbrupt(iter.getIterator());
                throw ex;
            }
            return setObj;
        }

        protected JSObject newSetObject(JSDynamicObject newTarget) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSSet.create(this.getContext(), realm, proto);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getSetPrototype();
        }
    }

    public static abstract class ConstructWeakMapNode
    extends ConstructMapNode {
        public ConstructWeakMapNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Override
        protected JSObject newMapObject(JSDynamicObject newTarget) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSWeakMap.create(this.getContext(), realm, proto);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getWeakMapPrototype();
        }
    }

    public static abstract class ConstructWeakSetNode
    extends ConstructSetNode {
        public ConstructWeakSetNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Override
        protected JSObject newSetObject(JSDynamicObject newTarget) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSWeakSet.create(this.getContext(), this.getRealm(), proto);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getWeakSetPrototype();
        }
    }

    public static abstract class ConstructIteratorNode
    extends ConstructWithNewTargetNode {
        public ConstructIteratorNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        protected final boolean isValidTarget(VirtualFrame frame, JSDynamicObject newTarget) {
            return this.isNewTargetCase && newTarget != Undefined.instance && newTarget != JSFrameUtil.getFunctionObjectNoCast((Frame)frame);
        }

        @Specialization(guards={"isValidTarget(frame, newTarget)"})
        protected JSObject constructIterator(VirtualFrame frame, JSDynamicObject newTarget, Object[] args) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSIterator.create(this.getContext(), realm, proto);
        }

        @Specialization(guards={"!isValidTarget(frame, newTarget)"})
        protected JSObject constructIteratorTypeError(VirtualFrame frame, JSDynamicObject newTarget, Object[] args) {
            throw Errors.createTypeError("Cannot construct a new Iterator as it is an abstract class.");
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getIteratorPrototype();
        }
    }

    public static abstract class ConstructAsyncIteratorNode
    extends ConstructWithNewTargetNode {
        public ConstructAsyncIteratorNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        protected final boolean isValidTarget(VirtualFrame frame, JSDynamicObject newTarget) {
            return this.isNewTargetCase && newTarget != Undefined.instance && newTarget != JSFrameUtil.getFunctionObjectNoCast((Frame)frame);
        }

        @Specialization(guards={"isValidTarget(frame, newTarget)"})
        protected JSObject constructIterator(VirtualFrame frame, JSDynamicObject newTarget, Object[] args) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSAsyncIterator.create(this.getContext(), realm, proto);
        }

        @Specialization(guards={"!isValidTarget(frame, newTarget)"})
        protected JSObject constructIteratorTypeError(VirtualFrame frame, JSDynamicObject newTarget, Object[] args) {
            throw Errors.createTypeError("Cannot construct a new AsyncIterator as it is an abstract class.");
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getAsyncIteratorPrototype();
        }
    }

    public static abstract class ConstructSymbolNode
    extends JSBuiltinNode {
        public ConstructSymbolNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static final Object construct() {
            throw Errors.createTypeError("cannot construct a Symbol");
        }
    }

    @ImportStatic(value={Symbol.class})
    public static abstract class CallSymbolNode
    extends JSBuiltinNode
    implements JSBuiltinNode.Inlineable {
        public CallSymbolNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Symbol callSymbolString(TruffleString value) {
            return Symbol.create(value);
        }

        @Specialization(guards={"!isString(value)"})
        protected Symbol callSymbolGeneric(Object value, @Cached JSToStringNode toStringNode) {
            return Symbol.create(value == Undefined.instance ? null : toStringNode.executeString(value));
        }

        @Override
        public Inlined createInlined() {
            return ConstructorBuiltinsFactory.CallSymbolNodeGen.InlinedNodeGen.create(this.getContext(), this.getBuiltin(), new JavaScriptNode[0]);
        }

        public static abstract class Inlined
        extends CallSymbolNode
        implements JSBuiltinNode.Inlined {
            public Inlined(JSContext context, JSBuiltin builtin) {
                super(context, builtin);
            }

            protected abstract Object executeWithArguments(Object var1);

            @Specialization(guards={"acceptCache(equalNode, value, cachedValue, symbolUsageMarker)"}, limit="1")
            protected Symbol callSymbolSingleton(TruffleString value, @Cached(value="value") TruffleString cachedValue, @Cached TruffleString.EqualNode equalNode, @Cached(value="createSymbolUsageMarker()") AtomicReference<Object> symbolUsageMarker, @Cached(value="createCachedSingletonSymbol(value)", weak=true) Symbol cachedSymbol) {
                return cachedSymbol;
            }

            @Override
            @Specialization
            protected Symbol callSymbolString(TruffleString value) {
                throw this.rewriteToCall();
            }

            @Specialization
            protected TruffleString callInlinedSymbolGeneric(Object value) {
                throw this.rewriteToCall();
            }

            @Override
            public Object callInlined(Object[] arguments) {
                if (JSArguments.getUserArgumentCount(arguments) < 1) {
                    throw this.rewriteToCall();
                }
                return this.executeWithArguments(JSArguments.getUserArgument(arguments, 0));
            }

            @CompilerDirectives.TruffleBoundary
            protected boolean acceptCache(TruffleString.EqualNode equalNode, TruffleString value, TruffleString cachedValue, AtomicReference<Object> symbolUsageMarker) {
                if (this.getContext().isMultiContext() && Strings.equals(equalNode, value, cachedValue)) {
                    Object oldMarker;
                    Object currentMarker = this.getContext().getSymbolUsageMarker();
                    return currentMarker != (oldMarker = symbolUsageMarker.getAndSet(currentMarker));
                }
                return false;
            }

            protected AtomicReference<Object> createSymbolUsageMarker() {
                return new AtomicReference<Object>();
            }

            protected Symbol createCachedSingletonSymbol(TruffleString value) {
                return Symbol.create(value);
            }
        }
    }

    @ImportStatic(value={JSProxy.class})
    public static abstract class ConstructJSProxyNode
    extends ConstructWithNewTargetNode {
        public ConstructJSProxyNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected final JSObject constructJSProxy(JSDynamicObject newTarget, Object target, Object handler, @Cached InlinedConditionProfile targetNonObject, @Cached InlinedConditionProfile handlerNonObject) {
            if (targetNonObject.profile((Node)this, !JSGuards.isTruffleObject(target) || target instanceof Symbol || target == Undefined.instance || target == Null.instance || target instanceof TruffleString || target instanceof SafeInteger || target instanceof BigInt)) {
                throw Errors.createTypeError("target expected to be an object");
            }
            if (handlerNonObject.profile((Node)this, !JSGuards.isJSObject(handler))) {
                throw Errors.createTypeError("handler expected to be an object");
            }
            JSDynamicObject handlerObj = (JSDynamicObject)((Object)handler);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSProxy.create(this.getContext(), realm, proto, target, handlerObj);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getProxyPrototype();
        }

        public abstract JSDynamicObject execute(JSDynamicObject var1, Object var2, Object var3);
    }

    public static abstract class PromiseConstructorNode
    extends JSBuiltinNode {
        @Node.Child
        protected IsCallableNode isCallable = IsCallableNode.create();
        @Node.Child
        private PromiseResolveThenableNode promiseResolveThenable;
        @Node.Child
        private OrdinaryCreateFromConstructorNode createPromiseFromConstructor;

        public PromiseConstructorNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.promiseResolveThenable = PromiseResolveThenableNode.create(context);
            this.createPromiseFromConstructor = OrdinaryCreateFromConstructorNode.create(context, null, JSRealm::getPromisePrototype, JSPromise.INSTANCE);
        }

        @Specialization(guards={"isCallable.executeBoolean(executor)"})
        protected JSPromiseObject construct(JSDynamicObject newTarget, Object executor) {
            JSPromiseObject promise = (JSPromiseObject)this.createPromiseFromConstructor.executeWithConstructor(newTarget);
            promise.setPromiseState(0);
            promise.setIsHandled(false);
            promise.allocatePromiseReactions();
            this.getContext().notifyPromiseHook(0, promise);
            this.promiseResolveThenable.executePromiseConstructor(promise, executor);
            return promise;
        }

        @Specialization(guards={"!isCallable.executeBoolean(executor)"})
        protected JSPromiseObject notCallable(JSDynamicObject newTarget, Object executor) {
            throw Errors.createTypeError("cannot create promise: executor not callable");
        }
    }

    public static abstract class ConstructTemporalPlainTimeNode
    extends ConstructWithNewTargetNode {
        protected ConstructTemporalPlainTimeNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected JSDynamicObject constructTemporalPlainTime(JSDynamicObject newTarget, Object hourObj, Object minuteObj, Object secondObj, Object millisecondObject, Object microsecondObject, Object nanosecondObject, @Cached InlinedBranchProfile errorBranch, @Cached JSToIntegerThrowOnInfinityNode toIntegerNode) {
            int hour = toIntegerNode.executeIntOrThrow(hourObj);
            int minute = toIntegerNode.executeIntOrThrow(minuteObj);
            int second = toIntegerNode.executeIntOrThrow(secondObj);
            int millisecond = toIntegerNode.executeIntOrThrow(millisecondObject);
            int microsecond = toIntegerNode.executeIntOrThrow(microsecondObject);
            int nanosecond = toIntegerNode.executeIntOrThrow(nanosecondObject);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSTemporalPlainTime.create(this.getContext(), realm, proto, hour, minute, second, millisecond, microsecond, nanosecond, this, errorBranch);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getTemporalPlainTimePrototype();
        }
    }

    public static abstract class ConstructTemporalPlainDateNode
    extends ConstructWithNewTargetNode {
        protected ConstructTemporalPlainDateNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected JSDynamicObject constructTemporalPlainDate(JSDynamicObject newTarget, Object isoYear, Object isoMonth, Object isoDay, Object calendarLike, @Cached JSToIntegerThrowOnInfinityNode toIntegerNode, @Cached ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode, @Cached InlinedBranchProfile errorBranch) {
            int y = toIntegerNode.executeIntOrThrow(isoYear);
            int m = toIntegerNode.executeIntOrThrow(isoMonth);
            int d = toIntegerNode.executeIntOrThrow(isoDay);
            JSDynamicObject calendar = toTemporalCalendarWithISODefaultNode.execute(calendarLike);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSTemporalPlainDate.create(this.getContext(), realm, proto, y, m, d, calendar, this, errorBranch);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getTemporalPlainDatePrototype();
        }
    }

    public static abstract class ConstructTemporalPlainDateTimeNode
    extends ConstructWithNewTargetNode {
        protected ConstructTemporalPlainDateTimeNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected JSDynamicObject constructTemporalPlainDateTime(JSDynamicObject newTarget, Object yearObj, Object monthObj, Object dayObj, Object hourObj, Object minuteObj, Object secondObj, Object millisecondObject, Object microsecondObject, Object nanosecondObject, Object calendarLike, @Cached JSToIntegerThrowOnInfinityNode toIntegerNode, @Cached ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode, @Cached InlinedBranchProfile errorBranch) {
            int year = toIntegerNode.executeIntOrThrow(yearObj);
            int month = toIntegerNode.executeIntOrThrow(monthObj);
            int day = toIntegerNode.executeIntOrThrow(dayObj);
            int hour = toIntegerNode.executeIntOrThrow(hourObj);
            int minute = toIntegerNode.executeIntOrThrow(minuteObj);
            int second = toIntegerNode.executeIntOrThrow(secondObj);
            int millisecond = toIntegerNode.executeIntOrThrow(millisecondObject);
            int microsecond = toIntegerNode.executeIntOrThrow(microsecondObject);
            int nanosecond = toIntegerNode.executeIntOrThrow(nanosecondObject);
            JSDynamicObject calendar = toTemporalCalendarWithISODefaultNode.execute(calendarLike);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSTemporalPlainDateTime.create(this.getContext(), realm, proto, year, month, day, hour, minute, second, millisecond, microsecond, nanosecond, calendar, this, errorBranch);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getTemporalPlainDateTimePrototype();
        }
    }

    public static abstract class ConstructTemporalDurationNode
    extends ConstructWithNewTargetNode {
        protected ConstructTemporalDurationNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected JSDynamicObject constructTemporalDuration(JSDynamicObject newTarget, Object yearsObj, Object monthsObj, Object weeksObj, Object daysObj, Object hoursObj, Object minutesObj, Object secondsObj, Object millisecondsObject, Object microsecondsObject, Object nanosecondsObject, @Cached JSToIntegerWithoutRoundingNode toIntegerNode, @Cached InlinedBranchProfile errorBranch) {
            double years = toIntegerNode.executeDouble(yearsObj);
            double months = toIntegerNode.executeDouble(monthsObj);
            double weeks = toIntegerNode.executeDouble(weeksObj);
            double days = toIntegerNode.executeDouble(daysObj);
            double hours = toIntegerNode.executeDouble(hoursObj);
            double minutes = toIntegerNode.executeDouble(minutesObj);
            double seconds = toIntegerNode.executeDouble(secondsObj);
            double milliseconds = toIntegerNode.executeDouble(millisecondsObject);
            double microseconds = toIntegerNode.executeDouble(microsecondsObject);
            double nanoseconds = toIntegerNode.executeDouble(nanosecondsObject);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, proto, years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, this, errorBranch);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getTemporalDurationPrototype();
        }
    }

    public static abstract class ConstructTemporalCalendar
    extends ConstructWithNewTargetNode {
        protected ConstructTemporalCalendar(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected JSDynamicObject constructTemporalCalendar(JSDynamicObject newTarget, Object arg, @Cached InlinedBranchProfile errorBranch, @Cached JSToStringNode toString) {
            TruffleString id = toString.executeString(arg);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            if (!TemporalUtil.isBuiltinCalendar(id)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorCalendarNotSupported();
            }
            return JSTemporalCalendar.create(this.getContext(), realm, proto, id);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getTemporalCalendarPrototype();
        }
    }

    public static abstract class ConstructTemporalPlainYearMonth
    extends ConstructWithNewTargetNode {
        protected ConstructTemporalPlainYearMonth(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected JSDynamicObject constructTemporalPlainYearMonth(JSDynamicObject newTarget, Object isoYear, Object isoMonth, Object calendarLike, Object refISODay, @Cached InlinedBranchProfile errorBranch, @Cached JSToIntegerThrowOnInfinityNode toInteger, @Cached ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode) {
            Object referenceISODay = refISODay;
            if (referenceISODay == Undefined.instance || referenceISODay == null) {
                referenceISODay = 1;
            }
            int y = toInteger.executeIntOrThrow(isoYear);
            int m = toInteger.executeIntOrThrow(isoMonth);
            JSDynamicObject calendar = toTemporalCalendarWithISODefaultNode.execute(calendarLike);
            int ref = toInteger.executeIntOrThrow(referenceISODay);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSTemporalPlainYearMonth.create(this.getContext(), realm, proto, y, m, calendar, ref, this, errorBranch);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getTemporalPlainYearMonthPrototype();
        }
    }

    public static abstract class ConstructTemporalPlainMonthDay
    extends ConstructWithNewTargetNode {
        protected ConstructTemporalPlainMonthDay(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected JSDynamicObject constructTemporalPlainMonthDay(JSDynamicObject newTarget, Object isoMonth, Object isoDay, Object calendarLike, Object refISOYear, @Cached InlinedBranchProfile errorBranch, @Cached JSToIntegerThrowOnInfinityNode toInt, @Cached ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode) {
            Object referenceISOYear = refISOYear;
            if (referenceISOYear == Undefined.instance || referenceISOYear == null) {
                referenceISOYear = 1972;
            }
            int m = toInt.executeIntOrThrow(isoMonth);
            int d = toInt.executeIntOrThrow(isoDay);
            JSDynamicObject calendar = toTemporalCalendarWithISODefaultNode.execute(calendarLike);
            int ref = toInt.executeIntOrThrow(referenceISOYear);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSTemporalPlainMonthDay.create(this.getContext(), realm, proto, m, d, calendar, ref, this, errorBranch);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getTemporalPlainMonthDayPrototype();
        }
    }

    public static abstract class ConstructTemporalInstant
    extends ConstructWithNewTargetNode {
        protected ConstructTemporalInstant(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected JSDynamicObject constructTemporalInstant(JSDynamicObject newTarget, Object epochNanoseconds, @Cached InlinedBranchProfile errorBranch) {
            BigInt bi = JSRuntime.toBigInt(epochNanoseconds);
            if (!TemporalUtil.isValidEpochNanoseconds(bi)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorInvalidNanoseconds();
            }
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSTemporalInstant.create(this.getContext(), realm, proto, bi);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getTemporalInstantPrototype();
        }
    }

    public static abstract class ConstructTemporalTimeZone
    extends ConstructWithNewTargetNode {
        protected ConstructTemporalTimeZone(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected JSDynamicObject constructTemporalTimeZone(JSDynamicObject newTarget, Object identifier, @Cached JSToStringNode toStringNode) {
            TruffleString id = toStringNode.executeString(identifier);
            return this.constructTemporalTimeZoneIntl(newTarget, id);
        }

        @CompilerDirectives.TruffleBoundary
        private JSDynamicObject constructTemporalTimeZoneIntl(JSDynamicObject newTarget, TruffleString idParam) {
            TruffleString id = idParam;
            boolean canParse = TemporalUtil.canParseAsTimeZoneNumericUTCOffset(id);
            if (!canParse) {
                if (!TemporalUtil.isValidTimeZoneName(id)) {
                    throw TemporalErrors.createRangeErrorInvalidTimeZoneString();
                }
                id = TemporalUtil.canonicalizeTimeZoneName(id);
            }
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return TemporalUtil.createTemporalTimeZone(this.getContext(), realm, proto, id);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getTemporalTimeZonePrototype();
        }
    }

    public static abstract class ConstructTemporalZonedDateTime
    extends ConstructWithNewTargetNode {
        protected ConstructTemporalZonedDateTime(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected JSDynamicObject constructTemporalZonedDateTime(JSDynamicObject newTarget, Object epochNanoseconds, Object timeZoneLike, Object calendarLike, @Cached ToTemporalTimeZoneNode toTemporalTimeZone, @Cached ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode, @Cached JSToBigIntNode toBigIntNode, @Cached InlinedBranchProfile errorBranch) {
            BigInt ns = toBigIntNode.executeBigInteger(epochNanoseconds);
            if (!TemporalUtil.isValidEpochNanoseconds(ns)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorInvalidNanoseconds();
            }
            JSDynamicObject timeZone = toTemporalTimeZone.execute(timeZoneLike);
            JSDynamicObject calendar = toTemporalCalendarWithISODefaultNode.execute(calendarLike);
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, proto, ns, timeZone, calendar);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getTemporalZonedDateTimePrototype();
        }
    }

    public static abstract class ConstructShadowRealmNode
    extends ConstructWithNewTargetNode {
        public ConstructShadowRealmNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        @Specialization
        protected final JSObject construct(JSDynamicObject newTarget) {
            JSRealm currentRealm = this.getRealm();
            JSRealm shadowRealm = currentRealm.createChildRealm();
            this.hostInitializeShadowRealm(shadowRealm);
            JSDynamicObject proto = this.getPrototype(currentRealm, newTarget);
            return JSShadowRealm.create(this.getContext(), currentRealm, proto, shadowRealm);
        }

        private void hostInitializeShadowRealm(JSRealm shadowRealm) {
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return this.getRealm().getShadowRealmPrototype();
        }
    }

    public static abstract class ConstructJSAdapterNode
    extends JSBuiltinNode {
        public ConstructJSAdapterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUndefined(undefined1)", "isUndefined(undefined2)"})
        protected JSObject constructJSAdapter(JSObject adaptee, Object undefined1, Object undefined2) {
            return JSAdapter.create(this.getContext(), this.getRealm(), adaptee, null, null);
        }

        @Specialization(guards={"isUndefined(undefined2)"})
        protected JSObject constructJSAdapter(JSObject overrides, JSObject adaptee, Object undefined2) {
            return JSAdapter.create(this.getContext(), this.getRealm(), adaptee, overrides, null);
        }

        @Specialization
        protected JSObject constructJSAdapter(JSObject proto, JSObject overrides, JSObject adaptee) {
            return JSAdapter.create(this.getContext(), this.getRealm(), adaptee, overrides, proto);
        }

        @Fallback
        protected JSObject constructJSAdapter(Object proto, Object overrides, Object adaptee) {
            Object notAnObject;
            if (!JSRuntime.isObject(proto)) {
                notAnObject = proto;
            } else if (!JSRuntime.isObject(overrides)) {
                notAnObject = overrides;
            } else if (!JSRuntime.isObject(adaptee)) {
                notAnObject = adaptee;
            } else {
                throw Errors.shouldNotReachHere();
            }
            throw Errors.createTypeErrorNotAnObject(notAnObject);
        }
    }

    public static abstract class ConstructJavaImporterNode
    extends JSBuiltinNode {
        public ConstructJavaImporterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject constructJavaImporter(Object[] args) {
            JSRealm realm = this.getRealm();
            TruffleLanguage.Env env = realm.getEnv();
            SimpleArrayList<Object> imports = new SimpleArrayList<Object>(args.length);
            for (Object anImport : args) {
                InteropLibrary interop;
                if (JavaPackage.isJavaPackage(anImport)) {
                    imports.addUnchecked(anImport);
                    continue;
                }
                if (!env.isHostObject(anImport) || !(interop = InteropLibrary.getUncached((Object)anImport)).isMetaObject(anImport)) continue;
                imports.addUnchecked(anImport);
            }
            return JavaImporter.create(this.getContext(), realm, imports.toArray());
        }
    }

    public static abstract class ConstructWebAssemblyGlobalNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        PropertyGetNode getValueNode;
        @Node.Child
        PropertyGetNode getMutableNode;
        @Node.Child
        InteropLibrary globalAllocLib;

        public ConstructWebAssemblyGlobalNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.getValueNode = PropertyGetNode.create(Strings.VALUE, context);
            this.getMutableNode = PropertyGetNode.create(Strings.MUTABLE, context);
            this.globalAllocLib = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        }

        @Specialization
        protected JSObject constructGlobal(JSDynamicObject newTarget, Object descriptor, Object[] args, @Cached IsObjectNode isObjectNode, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached JSToStringNode toStringNode, @Cached ToWebAssemblyValueNode toWebAssemblyValueNode) {
            Object wasmGlobal;
            Object webAssemblyValue;
            if (!isObjectNode.executeBoolean(descriptor)) {
                throw Errors.createTypeError("WebAssembly.Global(): Argument 0 must be a global descriptor", (Node)this);
            }
            boolean mutable = toBooleanNode.executeBoolean(this, this.getMutableNode.getValue(descriptor));
            TruffleString valueType = toStringNode.executeString(this.getValueNode.getValue(descriptor));
            if (!JSWebAssemblyValueTypes.isValueType(valueType)) {
                throw Errors.createTypeError("WebAssembly.Global(): Descriptor property 'value' must be a WebAssembly type (i32, i64, f32, f64, anyfunc, externref)", (Node)this);
            }
            JSRealm realm = this.getRealm();
            if (args.length == 0 || args[0] == Undefined.instance) {
                webAssemblyValue = JSWebAssemblyValueTypes.getDefaultValue(realm, valueType);
            } else {
                if (!this.getContext().getLanguageOptions().wasmBigInt() && JSWebAssemblyValueTypes.isI64(valueType)) {
                    throw Errors.createTypeError("WebAssembly.Global(): Can't set the value of i64 WebAssembly.Global", (Node)this);
                }
                webAssemblyValue = toWebAssemblyValueNode.execute(args[0], valueType);
            }
            try {
                Object createGlobal = realm.getWASMGlobalAlloc();
                wasmGlobal = this.globalAllocLib.execute(createGlobal, new Object[]{valueType, mutable, webAssemblyValue});
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSWebAssemblyGlobal.create(this.getContext(), realm, proto, wasmGlobal, valueType, mutable);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getWebAssemblyGlobalPrototype();
        }
    }

    public static abstract class ConstructWebAssemblyInstanceNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        IsObjectNode isObjectNode = IsObjectNode.create();
        @Node.Child
        InteropLibrary instantiateModuleLib = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);

        public ConstructWebAssemblyInstanceNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
        }

        @Specialization
        protected JSObject constructInstanceFromModule(JSDynamicObject newTarget, JSWebAssemblyModuleObject module, Object importObject) {
            Object wasmInstance;
            if (importObject != Undefined.instance && !this.isObjectNode.executeBoolean(importObject)) {
                throw Errors.createTypeError("WebAssembly.Instance(): Argument 1 must be an object", (Node)this);
            }
            Object wasmModule = module.getWASMModule();
            JSRealm realm = this.getRealm();
            try {
                Object wasmImportObject = JSWebAssemblyInstance.transformImportObject(this.getContext(), realm, wasmModule, importObject);
                Object instantiate = realm.getWASMModuleInstantiate();
                try {
                    wasmInstance = this.instantiateModuleLib.execute(instantiate, new Object[]{wasmModule, wasmImportObject});
                }
                catch (GraalJSException jsex) {
                    throw jsex;
                }
                catch (AbstractTruffleException tex) {
                    throw Errors.createLinkError(tex, this);
                }
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSWebAssemblyInstance.create(this.getContext(), realm, proto, wasmInstance, wasmModule);
        }

        @Specialization(guards={"!isJSWebAssemblyModule(other)"})
        protected JSObject constructInstanceFromOther(JSDynamicObject newTarget, Object other, Object importObject) {
            throw Errors.createTypeError("WebAssembly.Instance(): Argument 0 must be a WebAssembly.Module");
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getWebAssemblyInstancePrototype();
        }
    }

    public static abstract class ConstructWebAssemblyMemoryNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        IsObjectNode isObjectNode = IsObjectNode.create();
        @Node.Child
        PropertyGetNode getInitialNode;
        @Node.Child
        PropertyGetNode getMaximumNode;
        @Node.Child
        GetBooleanOptionNode getSharedNode;
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toInitialSizeNode;
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toMaximumSizeNode;
        @Node.Child
        InteropLibrary memAllocLib;

        public ConstructWebAssemblyMemoryNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.getInitialNode = PropertyGetNode.create(Strings.INITIAL, context);
            this.getMaximumNode = PropertyGetNode.create(Strings.MAXIMUM, context);
            this.getSharedNode = GetBooleanOptionNode.create(context, Strings.SHARED, false);
            this.toInitialSizeNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Memory(): Property 'initial'");
            this.toMaximumSizeNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Memory(): Property 'maximum'");
            this.memAllocLib = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        }

        @Specialization
        protected JSObject constructMemory(JSDynamicObject newTarget, Object descriptor) {
            Object wasmMemory;
            int maximumInt;
            if (!this.isObjectNode.executeBoolean(descriptor)) {
                throw Errors.createTypeError("WebAssembly.Memory(): Argument 0 must be a memory descriptor", (Node)this);
            }
            Object initial = this.getInitialNode.getValue(descriptor);
            if (initial == Undefined.instance) {
                throw Errors.createTypeError("WebAssembly.Memory(): Property 'initial' is required", (Node)this);
            }
            int initialInt = this.toInitialSizeNode.executeInt(initial);
            if (initialInt > Short.MAX_VALUE) {
                throw Errors.createRangeErrorFormat("WebAssembly.Memory(): Property 'initial': value %d is above the upper bound %d", this, initialInt, Short.MAX_VALUE);
            }
            Boolean shared = this.getSharedNode.executeValue(descriptor);
            boolean sharedBoolean = Boolean.TRUE.equals(shared);
            Object maximum = this.getMaximumNode.getValue(descriptor);
            if (maximum == Undefined.instance) {
                if (sharedBoolean) {
                    throw Errors.createTypeError("WebAssembly.Memory(): Property 'maximum' is required for shared memory", (Node)this);
                }
                maximumInt = Short.MAX_VALUE;
            } else {
                maximumInt = this.toMaximumSizeNode.executeInt(maximum);
                if (maximumInt < initialInt) {
                    throw Errors.createRangeErrorFormat("WebAssembly.Memory(): Property 'maximum': value %d is below the lower bound %d", this, maximumInt, initialInt);
                }
                if (maximumInt > Short.MAX_VALUE) {
                    throw Errors.createRangeErrorFormat("WebAssembly.Memory(): Property 'maximum': value %d is above the upper bound %d", this, maximumInt, Short.MAX_VALUE);
                }
            }
            JSRealm realm = this.getRealm();
            try {
                Object createMemory = realm.getWASMMemAlloc();
                wasmMemory = this.memAllocLib.execute(createMemory, new Object[]{initialInt, maximumInt, sharedBoolean});
            }
            catch (AbstractTruffleException tex) {
                throw Errors.createRangeError("WebAssembly.Memory(): could not allocate memory");
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSWebAssemblyMemory.create(this.getContext(), realm, proto, wasmMemory, sharedBoolean);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getWebAssemblyMemoryPrototype();
        }
    }

    public static abstract class ConstructWebAssemblyModuleNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        ExportByteSourceNode exportByteSourceNode;
        @Node.Child
        InteropLibrary decodeModuleLib;

        public ConstructWebAssemblyModuleNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.exportByteSourceNode = ExportByteSourceNode.create(context, "WebAssembly.Module(): Argument 0 must be a buffer source", "WebAssembly.Module(): BufferSource argument is empty");
            this.decodeModuleLib = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        }

        @Specialization
        protected JSObject constructModule(JSDynamicObject newTarget, Object bytes) {
            Object wasmModule;
            Object byteSource = this.exportByteSourceNode.execute(bytes);
            JSRealm realm = this.getRealm();
            try {
                Object decode = realm.getWASMModuleDecode();
                wasmModule = this.decodeModuleLib.execute(decode, new Object[]{byteSource});
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            catch (AbstractTruffleException tex) {
                try {
                    ExceptionType type = InteropLibrary.getUncached((Object)((Object)tex)).getExceptionType((Object)tex);
                    if (type == ExceptionType.PARSE_ERROR) {
                        throw Errors.createCompileError(tex, (Node)this);
                    }
                }
                catch (UnsupportedMessageException ex) {
                    throw Errors.shouldNotReachHere(ex);
                }
                throw tex;
            }
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSWebAssemblyModule.create(this.getContext(), realm, proto, wasmModule);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getWebAssemblyModulePrototype();
        }
    }

    public static abstract class ConstructWebAssemblyTableNode
    extends ConstructWithNewTargetNode {
        @Node.Child
        IsObjectNode isObjectNode = IsObjectNode.create();
        @Node.Child
        PropertyGetNode getElementNode;
        @Node.Child
        PropertyGetNode getInitialNode;
        @Node.Child
        PropertyGetNode getMaximumNode;
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toInitialSizeNode;
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toMaximumSizeNode;
        @Node.Child
        InteropLibrary tableAllocLib;

        public ConstructWebAssemblyTableNode(JSContext context, JSBuiltin builtin, boolean newTargetCase) {
            super(context, builtin, newTargetCase);
            this.getElementNode = PropertyGetNode.create(Strings.ELEMENT, context);
            this.getInitialNode = PropertyGetNode.create(Strings.INITIAL, context);
            this.getMaximumNode = PropertyGetNode.create(Strings.MAXIMUM, context);
            this.toInitialSizeNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Table(): Property 'initial'");
            this.toMaximumSizeNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Table(): Property 'maximum'");
            this.tableAllocLib = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        }

        @Specialization
        protected JSObject constructTable(JSDynamicObject newTarget, Object descriptor, Object[] args, @Cached JSToStringNode toStringNode, @Cached ToWebAssemblyValueNode toWebAssemblyValueNode) {
            Object wasmTable;
            int maximumInt;
            if (!this.isObjectNode.executeBoolean(descriptor)) {
                throw Errors.createTypeError("WebAssembly.Table(): Argument 0 must be a table descriptor", (Node)this);
            }
            TruffleString elementKind = toStringNode.executeString(this.getElementNode.getValue(descriptor));
            if (!JSWebAssemblyValueTypes.isReferenceType(elementKind)) {
                throw Errors.createTypeError("WebAssembly.Table(): Descriptor property 'element' must be 'anyfunc' or 'externref'", (Node)this);
            }
            Object initial = this.getInitialNode.getValue(descriptor);
            if (initial == Undefined.instance) {
                throw Errors.createTypeError("WebAssembly.Table(): Property 'initial' is required", (Node)this);
            }
            int initialInt = this.toInitialSizeNode.executeInt(initial);
            if (initialInt > 10000000) {
                throw Errors.createRangeErrorFormat("WebAssembly.Table(): Property 'initial': value %d is above the upper bound %d", this, initialInt, 10000000);
            }
            Object maximum = this.getMaximumNode.getValue(descriptor);
            if (maximum == Undefined.instance) {
                maximumInt = 10000000;
            } else {
                maximumInt = this.toMaximumSizeNode.executeInt(maximum);
                if (initialInt > maximumInt) {
                    throw Errors.createRangeErrorFormat("WebAssembly.Table(): Property 'maximum': value %d is below the lower bound %d", this, maximumInt, initialInt);
                }
                if (maximumInt > 10000000) {
                    throw Errors.createRangeErrorFormat("WebAssembly.Table(): Property 'maximum': value %d is above the upper bound %d", this, maximumInt, 10000000);
                }
            }
            JSRealm realm = this.getRealm();
            Object wasmValue = args.length == 0 ? JSWebAssemblyValueTypes.getDefaultValue(realm, elementKind) : toWebAssemblyValueNode.execute(args[0], elementKind);
            try {
                Object createTable = realm.getWASMTableAlloc();
                wasmTable = this.tableAllocLib.execute(createTable, new Object[]{initialInt, maximumInt, elementKind, wasmValue});
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSWebAssemblyTable.create(this.getContext(), realm, proto, wasmTable, elementKind);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getWebAssemblyTablePrototype();
        }
    }

    public static abstract class CallRequiresNewNode
    extends JSBuiltinNode {
        public CallRequiresNewNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        @Specialization
        protected final Object call() {
            throw Errors.createTypeErrorFormat("Constructor %s requires 'new'", this.getBuiltin().getName());
        }
    }

    public static abstract class JSConstructIterableOperation
    extends ConstructWithNewTargetNode {
        @Node.Child
        private IteratorCloseNode iteratorCloseNode;
        @Node.Child
        private IteratorValueNode getIteratorValueNode;
        @Node.Child
        private IteratorStepNode iteratorStepNode;
        @Node.Child
        private JSFunctionCallNode callAdderNode;
        @Node.Child
        private PropertyGetNode getAdderFnNode;

        public JSConstructIterableOperation(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin, isNewTargetCase);
        }

        protected void iteratorCloseAbrupt(Object iterator) {
            if (this.iteratorCloseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorCloseNode = (IteratorCloseNode)this.insert(IteratorCloseNode.create(this.getContext()));
            }
            this.iteratorCloseNode.executeAbrupt(iterator);
        }

        protected Object getIteratorValue(Object iteratorResult) {
            if (this.getIteratorValueNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getIteratorValueNode = (IteratorValueNode)this.insert(IteratorValueNode.create());
            }
            return this.getIteratorValueNode.execute(iteratorResult);
        }

        protected Object iteratorStep(IteratorRecord iterator) {
            if (this.iteratorStepNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorStepNode = (IteratorStepNode)this.insert(IteratorStepNode.create());
            }
            return this.iteratorStepNode.execute(iterator);
        }

        protected Object call(Object target, Object function, Object ... userArguments) {
            if (this.callAdderNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callAdderNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            }
            return this.callAdderNode.executeCall(JSArguments.create(target, function, userArguments));
        }

        protected Object getAdderFn(JSDynamicObject obj, TruffleString name) {
            if (this.getAdderFnNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getAdderFnNode = (PropertyGetNode)this.insert(PropertyGetNode.create(name, this.getContext()));
            }
            return this.getAdderFnNode.getValue((Object)obj);
        }
    }

    static abstract class CreateDynamicFunctionNode
    extends JavaScriptBaseNode {
        private final boolean generatorFunction;
        private final boolean asyncFunction;
        private final JSContext context;

        protected CreateDynamicFunctionNode(JSContext context, boolean generatorFunction, boolean asyncFunction) {
            this.generatorFunction = generatorFunction;
            this.asyncFunction = asyncFunction;
            this.context = context;
        }

        protected abstract JSFunctionObject executeFunction(String var1, String var2, String var3, ScriptOrModule var4);

        protected static boolean equals(String a, String b) {
            return a.equals(b);
        }

        @NeverDefault
        protected LRUCache<CachedSourceKey, ScriptNode> createCache() {
            return new LRUCache<CachedSourceKey, ScriptNode>(this.context.getLanguageOptions().functionConstructorCacheSize());
        }

        @Specialization(guards={"equals(cachedParamList, paramList)", "equals(cachedBody, body)", "equals(cachedSourceName, sourceName)"}, limit="1")
        protected final JSFunctionObject doCached(String paramList, String body, String sourceName, ScriptOrModule activeScriptOrModule, @Cached(value="paramList") String cachedParamList, @Cached(value="body") String cachedBody, @Cached(value="sourceName") String cachedSourceName, @Cached(value="createAssumedValue()") AssumedValue<ScriptNode> cachedParsedFunction) {
            ScriptNode parsedFunction = (ScriptNode)cachedParsedFunction.get();
            if (parsedFunction == null) {
                parsedFunction = this.parseFunction(paramList, body, sourceName, activeScriptOrModule);
                cachedParsedFunction.set((Object)parsedFunction);
            }
            return CreateDynamicFunctionNode.evalParsedFunction(this.getRealm(), parsedFunction);
        }

        @Specialization(replaces={"doCached"})
        protected final JSFunctionObject doUncached(String paramList, String body, String sourceName, ScriptOrModule activeScriptOrModule, @Cached(value="createCache()") LRUCache<CachedSourceKey, ScriptNode> cache) {
            ScriptNode cached = this.cacheLookup(cache, new CachedSourceKey(paramList, body, sourceName, activeScriptOrModule));
            JSRealm realm = this.getRealm();
            if (cached == null) {
                return this.parseAndEvalFunction(cache, realm, paramList, body, sourceName, activeScriptOrModule);
            }
            return CreateDynamicFunctionNode.evalParsedFunction(realm, cached);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        protected ScriptNode cacheLookup(LRUCache<CachedSourceKey, ScriptNode> cache, CachedSourceKey sourceKey) {
            LRUCache<CachedSourceKey, ScriptNode> lRUCache = cache;
            synchronized (lRUCache) {
                return (ScriptNode)cache.get(sourceKey);
            }
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        protected final ScriptNode parseFunction(String paramList, String body, String sourceName, ScriptOrModule activeScriptOrModule) {
            CompilerAsserts.neverPartOfCompilation();
            return this.context.getEvaluator().parseFunction(this.context, paramList, body, this.generatorFunction, this.asyncFunction, sourceName, activeScriptOrModule);
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        private static JSFunctionObject evalParsedFunction(JSRealm realm, ScriptNode parsedFunction) {
            return (JSFunctionObject)((Object)parsedFunction.run(realm));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        private JSFunctionObject parseAndEvalFunction(LRUCache<CachedSourceKey, ScriptNode> cache, JSRealm realm, String paramList, String body, String sourceName, ScriptOrModule activeScriptOrModule) {
            ScriptNode parsedBody = this.parseFunction(paramList, body, sourceName, activeScriptOrModule);
            LRUCache<CachedSourceKey, ScriptNode> lRUCache = cache;
            synchronized (lRUCache) {
                cache.put(new CachedSourceKey(paramList, body, sourceName, activeScriptOrModule), parsedBody);
            }
            return CreateDynamicFunctionNode.evalParsedFunction(realm, parsedBody);
        }

        AssumedValue<ScriptNode> createAssumedValue() {
            return new AssumedValue("parsedFunction", null);
        }

        protected record CachedSourceKey(String paramList, String body, String sourceName, ScriptOrModule activeScriptOrModule) {
        }
    }

    public static abstract class ConstructWithNewTargetNode
    extends JSBuiltinNode {
        protected final boolean isNewTargetCase;
        @Node.Child
        private PropertyGetNode getPrototypeNode;

        protected ConstructWithNewTargetNode(JSContext context, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context, builtin);
            this.isNewTargetCase = isNewTargetCase;
            if (isNewTargetCase) {
                this.getPrototypeNode = PropertyGetNode.create(JSObject.PROTOTYPE, context);
            }
        }

        protected JSRealm getRealmFromNewTarget(Object newTarget) {
            if (this.isNewTargetCase) {
                return JSRuntime.getFunctionRealm(newTarget, this.getRealm());
            }
            return this.getRealm();
        }

        protected abstract JSDynamicObject getIntrinsicDefaultProto(JSRealm var1);

        protected JSDynamicObject getPrototype(JSRealm realm, JSDynamicObject newTarget) {
            if (this.isNewTargetCase) {
                return this.getPrototypeFromNewTarget(newTarget);
            }
            return this.getIntrinsicDefaultProto(realm);
        }

        protected <T extends JSObject> T swapPrototype(T resultObj, JSDynamicObject newTarget) {
            if (this.isNewTargetCase) {
                return this.setPrototypeFromNewTarget(resultObj, newTarget);
            }
            return resultObj;
        }

        private JSDynamicObject getPrototypeFromNewTarget(JSDynamicObject newTarget) {
            Object prototype = this.getPrototypeNode.getValue((Object)newTarget);
            if (!JSRuntime.isObject(prototype)) {
                prototype = this.getIntrinsicDefaultProto(this.getRealmFromNewTarget((Object)newTarget));
            }
            return (JSDynamicObject)((Object)prototype);
        }

        protected <T extends JSObject> T setPrototypeFromNewTarget(T resultObj, JSDynamicObject newTarget) {
            JSDynamicObject prototype = this.getPrototypeFromNewTarget(newTarget);
            JSObject.setPrototype(resultObj, prototype);
            return resultObj;
        }
    }
}

