/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.file.launcher.queries;

import java.util.List;
import java.util.Objects;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.file.launcher.SingleSourceFileUtil;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

public class LauncherSourceLevelQueryImpl
implements SourceLevelQueryImplementation2 {
    public SourceLevelQueryImplementation2.Result getSourceLevel(FileObject javaFile) {
        SingleSourceFileUtil.ParsedFileOptions delegate = SingleSourceFileUtil.getOptionsFor(javaFile);
        if (delegate != null) {
            return new ResultImpl(delegate);
        }
        return null;
    }

    private static final class ResultImpl
    implements ChangeListener,
    SourceLevelQueryImplementation2.Result {
        private static final String DEFAULT_SOURCE_LEVEL = JavaPlatformManager.getDefault().getDefaultPlatform().getSpecification().getVersion().toString();
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final SingleSourceFileUtil.ParsedFileOptions delegate;
        private String sourceLevel;

        public ResultImpl(SingleSourceFileUtil.ParsedFileOptions delegate) {
            this.delegate = delegate;
            this.delegate.addChangeListener(this);
            this.updateDelegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateDelegate() {
            boolean modified;
            List<? extends String> parsed = this.delegate.getArguments();
            String sourceLevel = DEFAULT_SOURCE_LEVEL;
            for (int i = 0; i < parsed.size(); ++i) {
                if (!"--source".equals(parsed.get(i)) || i + 1 >= parsed.size()) continue;
                sourceLevel = parsed.get(i + 1);
            }
            ResultImpl resultImpl = this;
            synchronized (resultImpl) {
                boolean bl = modified = !Objects.equals(this.sourceLevel, sourceLevel);
                if (modified) {
                    this.sourceLevel = sourceLevel;
                }
            }
            if (modified) {
                this.cs.fireChange();
            }
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.updateDelegate();
        }

        public synchronized String getSourceLevel() {
            return this.sourceLevel;
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }
    }
}

