/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.nodes;

import java.awt.Component;
import java.awt.Image;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.actions.DebugAction;
import org.netbeans.modules.payara.common.actions.KillServerAction;
import org.netbeans.modules.payara.common.actions.OpenDomainDirectoryAction;
import org.netbeans.modules.payara.common.actions.OpenServerHomeDirectoryAction;
import org.netbeans.modules.payara.common.actions.ProfileAction;
import org.netbeans.modules.payara.common.actions.PropertiesAction;
import org.netbeans.modules.payara.common.actions.RemoveServerAction;
import org.netbeans.modules.payara.common.actions.RestartAction;
import org.netbeans.modules.payara.common.actions.StartServerAction;
import org.netbeans.modules.payara.common.actions.StopServerAction;
import org.netbeans.modules.payara.common.actions.ViewAdminConsoleAction;
import org.netbeans.modules.payara.common.actions.ViewServerLogAction;
import org.netbeans.modules.payara.common.nodes.Hk2InstanceChildren;
import org.netbeans.modules.payara.common.nodes.Refreshable;
import org.netbeans.modules.payara.common.nodes.actions.RefreshModulesAction;
import org.netbeans.modules.payara.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

public class Hk2InstanceNode
extends AbstractNode
implements ChangeListener {
    private static final String ICON_BASE = "org/netbeans/modules/payara/common/resources/server.png";
    private static final String WAITING_ICON = "org/netbeans/modules/payara/common/resources/waiting.png";
    private static final String RUNNING_ICON = "org/netbeans/modules/payara/common/resources/running.png";
    private static final String DEBUGGING_ICON = "org/netbeans/modules/payara/common/resources/debugging.png";
    private static final String SUSPENDED_ICON = "org/netbeans/modules/payara/common/resources/suspended.png";
    private static final String PROFILING_ICON = "org/netbeans/modules/payara/common/resources/profiling.png";
    private static final String PROFILER_BLOCKING_ICON = "org/netbeans/modules/payara/common/resources/profilerblocking.png";
    private final PayaraInstance serverInstance;
    private final InstanceContent instanceContent;
    private final boolean isFullNode;
    private volatile String displayName = null;
    private volatile String shortDesc = null;

    public Hk2InstanceNode(PayaraInstance instance, boolean isFullNode) {
        this(instance, new InstanceContent(), isFullNode);
        if (isFullNode) {
            instance.getCommonSupport().refresh();
        }
    }

    private Hk2InstanceNode(PayaraInstance instance, InstanceContent ic, boolean isFullNode) {
        super((Children)(isFullNode ? new Hk2InstanceChildren(instance) : Children.LEAF), (Lookup)new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)ic), instance.getLookup()}));
        this.serverInstance = instance;
        this.instanceContent = ic;
        this.isFullNode = isFullNode;
        this.setIconBaseWithExtension(ICON_BASE);
        if (isFullNode) {
            this.serverInstance.getCommonSupport().addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.serverInstance));
            this.instanceContent.add((Object)new RefreshModulesCookie(){

                @Override
                public RequestProcessor.Task refresh() {
                    return this.refresh(null, null);
                }

                @Override
                public RequestProcessor.Task refresh(String expected, String unexpected) {
                    Children children = Hk2InstanceNode.this.getChildren();
                    if (children instanceof Refreshable) {
                        ((Refreshable)children).updateKeys();
                    }
                    return null;
                }
            });
        }
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.buildDisplayName();
        }
        return this.displayName;
    }

    public String getShortDescription() {
        if (this.shortDesc == null) {
            this.shortDesc = NbBundle.getMessage(Hk2InstanceNode.class, (String)"LBL_ServerInstanceNodeDesc", (Object)this.serverInstance.getServerDisplayName(), (Object)this.getAdminUrl());
        }
        return this.shortDesc;
    }

    public Action[] getActions(boolean context) {
        if (!this.isFullNode) {
            return new Action[0];
        }
        return this.serverInstance.isRemote() ? this.getRemoteActions() : this.getLocalActions();
    }

    public Action[] getLocalActions() {
        return new Action[]{SystemAction.get(StartServerAction.class), SystemAction.get(DebugAction.class), SystemAction.get(ProfileAction.class), SystemAction.get(RestartAction.class), SystemAction.get(StopServerAction.class), SystemAction.get(RefreshModulesAction.class), null, SystemAction.get(RemoveServerAction.class), null, SystemAction.get(KillServerAction.class), null, SystemAction.get(ViewAdminConsoleAction.class), SystemAction.get(ViewServerLogAction.class), SystemAction.get(OpenDomainDirectoryAction.class), SystemAction.get(OpenServerHomeDirectoryAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public Action[] getRemoteActions() {
        return new Action[]{SystemAction.get(StartServerAction.class), SystemAction.get(DebugAction.class), SystemAction.get(ProfileAction.class), SystemAction.get(RestartAction.class), SystemAction.get(StopServerAction.class), SystemAction.get(RefreshModulesAction.class), null, SystemAction.get(RemoveServerAction.class), null, SystemAction.get(ViewAdminConsoleAction.class), SystemAction.get(ViewServerLogAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new JPanel();
    }

    public Image getIcon(int type) {
        return this.badgeIcon(super.getIcon(type));
    }

    public Image getOpenedIcon(int type) {
        return this.badgeIcon(super.getOpenedIcon(type));
    }

    private Image badgeIcon(Image origImg) {
        Image badge = null;
        switch (this.serverInstance.getServerState()) {
            case RUNNING: {
                if (this.isDebug()) {
                    badge = ImageUtilities.loadImage((String)DEBUGGING_ICON);
                    break;
                }
                if (this.isProfile()) {
                    badge = ImageUtilities.loadImage((String)PROFILING_ICON);
                    break;
                }
                badge = ImageUtilities.loadImage((String)RUNNING_ICON);
                break;
            }
            case STARTING: {
                badge = ImageUtilities.loadImage((String)WAITING_ICON);
                break;
            }
            case STOPPED: {
                break;
            }
            case STOPPED_JVM_BP: 
            case STOPPED_JVM_PROFILER: {
                badge = ImageUtilities.loadImage((String)SUSPENDED_ICON);
                break;
            }
            case STOPPING: {
                badge = ImageUtilities.loadImage((String)WAITING_ICON);
            }
        }
        return badge != null ? ImageUtilities.mergeImages((Image)origImg, (Image)badge, (int)15, (int)8) : origImg;
    }

    private boolean isDebug() {
        return PayaraModule.DEBUG_MODE.equals(this.serverInstance.getProperty("jvmMode"));
    }

    private boolean isProfile() {
        return PayaraModule.PROFILE_MODE.equals(this.serverInstance.getProperty("jvmMode"));
    }

    private String buildDisplayName() {
        String dn = this.serverInstance.getProperty("displayName");
        return dn != null ? dn : "Bogus display name";
    }

    private String getAdminUrl() {
        String adminPort;
        String result = null;
        String host = this.serverInstance.getProperty("host");
        String string = adminPort = !"false".equals(System.getProperty("payara.useadminport")) ? this.serverInstance.getProperty("adminPort") : this.serverInstance.getProperty("httpportnumber");
        if (host != null && host.length() > 0) {
            result = "http://" + host + ":" + adminPort;
        }
        return result;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                Hk2InstanceNode.this.fireIconChange();
            }
        });
    }
}

