/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.cache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.primefaces.cache.CacheProvider;

public class EHCacheProvider
implements CacheProvider {
    private CacheManager cacheManager = CacheManager.create();

    public Object get(String region, String key) {
        Cache cacheRegion = this.getRegion(region);
        Element element = cacheRegion.get((Serializable)((Object)key));
        if (element != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public void put(String region, String key, Object object) {
        Cache cacheRegion = this.getRegion(region);
        cacheRegion.put(new Element((Object)key, object));
    }

    public void remove(String region, String key) {
        Cache cacheRegion = this.getRegion(region);
        cacheRegion.remove((Serializable)((Object)key));
    }

    public void clear() {
        String[] cacheNames = this.getCacheManager().getCacheNames();
        if (cacheNames != null) {
            for (int i = 0; i < cacheNames.length; ++i) {
                Cache cache = this.getRegion(cacheNames[i]);
                cache.removeAll();
            }
        }
    }

    protected Cache getRegion(String regionName) {
        Cache region = this.getCacheManager().getCache(regionName);
        if (region == null) {
            this.getCacheManager().addCache(regionName);
            region = this.getCacheManager().getCache(regionName);
        }
        return region;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

