/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.common;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class BuildUtils {
    public static final String NB_JDK_PROJECT_BUILD = "nb-jdk-project-build";

    private BuildUtils() {
    }

    public static File findTargetJavaHome(FileObject file) {
        File buildDir = BuildUtils.getBuildTargetDir(file);
        if (buildDir != null) {
            File candidate = new File(buildDir, "images/j2sdk-image");
            if (candidate.isDirectory()) {
                return candidate;
            }
            return new File(buildDir, "jdk");
        }
        Project prj = FileOwnerQuery.getOwner((FileObject)file);
        File projectDirFile = FileUtil.toFile((FileObject)prj.getProjectDirectory());
        File userHome = new File(System.getProperty("user.home"));
        ArrayList<PropertyProvider> properties = new ArrayList<PropertyProvider>();
        properties.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(projectDirFile, "build.properties")));
        properties.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(userHome, ".openjdk/langtools-build.properties")));
        properties.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(userHome, ".openjdk/build.properties")));
        properties.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(projectDirFile, "make/build.properties")));
        PropertyEvaluator evaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)PropertyUtils.globalPropertyProvider(), (PropertyProvider[])properties.toArray(new PropertyProvider[0]));
        return new File(evaluator.evaluate("${target.java.home}"));
    }

    public static File getBuildTargetDir(FileObject file) {
        return BuildUtils.getBuildTargetDir(FileOwnerQuery.getOwner((FileObject)file));
    }

    public static File getBuildTargetDir(Project prj) {
        for (String possibleRootLocation : new String[]{"../../..", "../.."}) {
            Object buildAttr;
            FileObject possibleJDKRoot = BuildUtils.getFileObject(prj.getProjectDirectory(), possibleRootLocation);
            Object object = buildAttr = possibleJDKRoot != null ? possibleJDKRoot.getAttribute(NB_JDK_PROJECT_BUILD) : null;
            if (!(buildAttr instanceof File)) continue;
            return (File)buildAttr;
        }
        return null;
    }

    public static FileObject getFileObject(FileObject dir, String relpath) {
        int pos = 0;
        while (relpath.startsWith("../", pos) || relpath.endsWith("..") && pos + 2 == relpath.length()) {
            if ((dir = dir.getParent()) == null) {
                return null;
            }
            pos += 3;
        }
        return pos < relpath.length() ? dir.getFileObject(relpath.substring(pos)) : dir;
    }

    public static interface ExtraMakeTargets {
        public String[] getExtraMakeTargets();
    }
}

