/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.hansolo.jdktools.ReleaseStatus;
import eu.hansolo.jdktools.TermOfSupport;
import eu.hansolo.jdktools.util.Helper;
import eu.hansolo.jdktools.versioning.Semver;
import eu.hansolo.jdktools.versioning.VersionNumber;
import io.foojay.api.discoclient.pkg.Scope;
import java.util.ArrayList;
import java.util.List;

public class MajorVersion {
    public static final String FIELD_MAJOR_VERSION = "major_version";
    public static final String FIELD_TERM_OF_SUPPORT = "term_of_support";
    public static final String FIELD_MAINTAINED = "maintained";
    public static final String FIELD_SCOPE = "scope";
    public static final String FIELD_VERSIONS = "versions";
    private List<Semver> versions = new ArrayList<Semver>();
    private final int majorVersion;
    private final TermOfSupport termOfSupport;
    private boolean maintained;
    private Scope scope;

    public MajorVersion(int majorVersion) {
        this(majorVersion, Helper.getTermOfSupport(majorVersion));
    }

    public MajorVersion(int majorVersion, TermOfSupport termOfSupport) {
        if (majorVersion <= 0) {
            throw new IllegalArgumentException("Major version cannot be <= 0");
        }
        this.majorVersion = majorVersion;
        this.termOfSupport = termOfSupport;
        this.maintained = false;
    }

    public MajorVersion(String jsonText) {
        if (null == jsonText || jsonText.isEmpty()) {
            throw new IllegalArgumentException("json text cannot be null or empty");
        }
        Gson gson = new Gson();
        JsonObject json = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
        this.majorVersion = json.has(FIELD_MAJOR_VERSION) ? json.get(FIELD_MAJOR_VERSION).getAsInt() : 1;
        this.termOfSupport = json.has(FIELD_TERM_OF_SUPPORT) ? TermOfSupport.fromText(json.get(FIELD_TERM_OF_SUPPORT).getAsString()) : TermOfSupport.NOT_FOUND;
        this.maintained = json.has(FIELD_MAINTAINED) ? json.get(FIELD_MAINTAINED).getAsBoolean() : false;
        Scope scope = this.scope = json.has(FIELD_SCOPE) ? Scope.fromText(json.get(FIELD_SCOPE).getAsString()) : Scope.NOT_FOUND;
        if (json.has(FIELD_VERSIONS)) {
            JsonArray versionsArray = json.getAsJsonArray(FIELD_VERSIONS);
            for (JsonElement jsonElement : versionsArray) {
                this.versions.add(Semver.fromText(jsonElement.getAsString()).getSemver1());
            }
        }
    }

    public int getAsInt() {
        return this.majorVersion;
    }

    public TermOfSupport getTermOfSupport() {
        return this.termOfSupport;
    }

    public boolean isMaintained() {
        return this.maintained;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Boolean isEarlyAccessOnly() {
        return this.getVersions().stream().filter(semver -> ReleaseStatus.EA == semver.getReleaseStatus()).count() == (long)this.getVersions().size();
    }

    public List<Semver> getVersions() {
        return this.versions;
    }

    public VersionNumber getVersionNumber() {
        return new VersionNumber(this.majorVersion);
    }

    public String toString() {
        return Integer.toString(this.getAsInt());
    }
}

