/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class TextUtils {
    private TextUtils() {
    }

    public static String shortenText(String text, int minWords, int limit) {
        boolean wholeWords;
        int endIndex;
        if (text == null) {
            throw new IllegalArgumentException("text must be non-null");
        }
        if (minWords < 1) {
            throw new IllegalArgumentException("minimum number of words must be positive");
        }
        if (limit < 1) {
            throw new IllegalArgumentException("limit must be positive - was: " + limit);
        }
        int length = (text = TextUtils.trimSpecial(text)).length();
        if (length <= limit) {
            return text;
        }
        int wordCount = 0;
        int lastWordEndIndex = -1;
        boolean lastWasSpace = false;
        for (int i = 1; i < limit; ++i) {
            boolean isSpace = TextUtils.isSpace(text.charAt(i));
            if (isSpace && !lastWasSpace) {
                lastWordEndIndex = i;
                ++wordCount;
            }
            lastWasSpace = isSpace;
        }
        if (wordCount >= minWords) {
            endIndex = lastWordEndIndex;
            wholeWords = true;
        } else if (lastWasSpace) {
            endIndex = lastWordEndIndex;
            wholeWords = true;
        } else {
            endIndex = limit;
            wholeWords = TextUtils.isSpace(text.charAt(limit));
        }
        StringBuilder buf = new StringBuilder(endIndex + 4);
        buf.append(text.substring(0, endIndex));
        if (wholeWords) {
            buf.append(' ');
        }
        buf.append("...");
        return buf.toString();
    }

    public static String trimSpecial(String str) {
        int index;
        if (str == null) {
            throw new IllegalArgumentException("null");
        }
        int length = str.length();
        for (index = 0; index < length && TextUtils.isSpace(str.charAt(index)); ++index) {
        }
        if (index == length) {
            return "";
        }
        int beginIndex = index;
        index = length - 1;
        while (TextUtils.isSpace(str.charAt(index))) {
            --index;
        }
        int endIndex = index + 1;
        return str.substring(beginIndex, endIndex);
    }

    private static boolean isSpace(char ch) {
        return ch == '\t' || Character.isSpaceChar(ch);
    }

    public static String escapeForHTMLLabel(String text) {
        if (text == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block4;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String encodeURL(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLEncoder.encode(url, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException ignored) {
            return null;
        }
    }

    public static String decodeURL(String encoded) {
        if (encoded == null) {
            return null;
        }
        try {
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ignored) {
            return null;
        }
    }

    public static String getMD5(String name) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update(name.getBytes());
        byte[] hash = digest.digest();
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i] & 0xFF);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            ret.append(hex);
        }
        return ret.toString();
    }
}

