/*
 *                            COPYRIGHT
 *
 *  up2pcb, simple unixplot file to pcb sintaxe file program converter
 *  Copyright (C) 2001 Luis Claudio Gamba Lopes
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact address for Email:
 *  lcgamboa@yahoo.com
 *
 */

#include<iostream>
#include<fstream>
#include<string>

#include<stdio.h>


using namespace std;

float SCALE= 3.0;
	
int
main (int argc, char **argv)
{
  int x1, y1, x2, y2, r;
  string s;
  string fname,fname2;

  for (int d = 1; d < argc; d++)
    {
      fname = argv[d];
      FILE *fi, *fo, *fov;
      float sx,sy;

      fi = fopen (fname.c_str (), "r");
      fname2 =fname+ ".lpcb";
      fo = fopen (fname2.c_str (), "w");
      fname2 =fname+ ".vpcb";
      fov = fopen (fname2.c_str (), "w");
  
       while (!feof (fi))
	{
	  switch (getc (fi))
	    {
	    case 's':
	      x1 = getc (fi) + (getc (fi) * 256);
	      y1 = getc (fi) + (getc (fi) * 256);
	      x2 = getc (fi) + (getc (fi) * 256);
	      y2 = getc (fi) + (getc (fi) * 256);

	      sx= x2/600.0;
	      sy= y2/800.0;
	      if(sx<sy)
	        SCALE=sy;
	      else
		SCALE=sx;      
//	      printf ("s--%i %i %i %i ???\n", x1, y1, x2, y2);
	      break;
	    case 'l':
	      x1 = getc (fi) + (getc (fi) * 256);
	      y1 = getc (fi) + (getc (fi) * 256);
	      x2 = getc (fi) + (getc (fi) * 256);
	      y2 = getc (fi) + (getc (fi) * 256);
	      fprintf (fo, "Line(%i %i %i %i 20 0x00000000)\n",x1,y1,x2,y2);
	      break;
	    case 'c':
	      x1 = getc (fi) + (getc (fi) * 256);
	      y1 = getc (fi) + (getc (fi) * 256);
	      r = getc (fi) + (getc (fi) * 256);
	      fprintf (fov,"Via(%i %i 60 25 \"\" 0x00000002)\n",x1, y1);
	      break;
	    case 'n':
	      x1 = getc (fi) + (getc (fi) * 256);
	      y1 = getc (fi) + (getc (fi) * 256);
	      fprintf (fo, "Line(%i %i %i %i 20 0x00000000)\n",x1,y1,x2,y2);
	      x2=x1;
	      y2=y1;
	      break;
	    case 'm':
	      x1 = (getc (fi) * 256) + getc (fi);
	      y1 = (getc (fi) * 256) + getc (fi);
	      printf ("m--%0.4f %0.4f moveto\n", x1 / SCALE, y1 / SCALE);
	      break;
	    case 'a':
	      x1 = (getc (fi) * 256) + getc (fi);
	      y1 = (getc (fi) * 256) + getc (fi);
	      x2 = (getc (fi) * 256) + getc (fi);
	      y2 = (getc (fi) * 256) + getc (fi);
	      r = (getc (fi) * 256) + getc (fi);
	      printf
		("a--stroke newpath\n%0.4f %0.4f %0.4f %0.4f %0.4f arc\n",
		 x1 / SCALE, y1 / SCALE, x2 / SCALE, y2 / SCALE, r / SCALE);
	      break;
	    case 'e':
	      break;
	    case 't':
	      while (r != '\0')
		r = getc (fi);
	      break;
	    };
	};
      fclose (fi);
      fclose (fo);
      fclose (fov);
    };
};
