/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * sign(dvec2(-1.5lf, -0.75lf)) => dvec2(-1.0lf, -1.0lf)
 * sign(dvec2(0.0lf, 0.75lf)) => dvec2(0.0lf, 1.0lf)
 * sign(dvec2(1.5lf, -1.5lf)) => dvec2(1.0lf, -1.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(sign(dvec2(-1.5lf, -0.75lf)), dvec2(-1.0lf, -1.0lf)) <= 1.4142135623730951e-05lf ? 1 : -1] array0;
  double[distance(sign(dvec2(0.0lf, 0.75lf)), dvec2(0.0lf, 1.0lf)) <= 1e-05lf ? 1 : -1] array1;
  double[distance(sign(dvec2(1.5lf, -1.5lf)), dvec2(1.0lf, -1.0lf)) <= 1.4142135623730951e-05lf ? 1 : -1] array2;
  gl_Position = vec4(array0.length() + array1.length() + array2.length());
}
