/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.manager.consumer;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.crossdc.common.CrossDcConf;
import org.apache.solr.crossdc.common.IQueueHandler;
import org.apache.solr.crossdc.common.KafkaCrossDcConf;
import org.apache.solr.crossdc.common.KafkaMirroringSink;
import org.apache.solr.crossdc.common.MirroredSolrRequest;
import org.apache.solr.crossdc.common.MirroredSolrRequestSerializer;
import org.apache.solr.crossdc.common.MirroringException;
import org.apache.solr.crossdc.manager.consumer.BlockingQueue;
import org.apache.solr.crossdc.manager.consumer.Consumer;
import org.apache.solr.crossdc.manager.consumer.PartitionManager;
import org.apache.solr.crossdc.manager.consumer.Util;
import org.apache.solr.crossdc.manager.messageprocessor.SolrMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaCrossDcConsumer
extends Consumer.CrossDcConsumer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)"metrics");
    private final KafkaConsumer<String, MirroredSolrRequest<?>> kafkaConsumer;
    private final CountDownLatch startLatch;
    KafkaMirroringSink kafkaMirroringSink;
    private static final int KAFKA_CONSUMER_POLL_TIMEOUT_MS = 5000;
    private final String[] topicNames;
    private final int maxAttempts;
    private final CrossDcConf.CollapseUpdates collapseUpdates;
    private final int maxCollapseRecords;
    private final SolrMessageProcessor messageProcessor;
    protected final CloudSolrClient solrClient;
    private final ThreadPoolExecutor executor;
    private final ExecutorService offsetCheckExecutor = ExecutorUtil.newMDCAwareCachedThreadPool(r -> new Thread(r, "offset-check-thread"));
    private final PartitionManager partitionManager;
    private final BlockingQueue<Runnable> queue = new BlockingQueue(10);

    public KafkaCrossDcConsumer(KafkaCrossDcConf conf, CountDownLatch startLatch) {
        this.topicNames = conf.get("solr.crossdc.topicName").split(",");
        this.maxAttempts = conf.getInt("solr.crossdc.maxAttempts");
        this.collapseUpdates = CrossDcConf.CollapseUpdates.getOrDefault((String)conf.get("solr.crossdc.collapseUpdates"), (CrossDcConf.CollapseUpdates)CrossDcConf.CollapseUpdates.PARTIAL);
        this.maxCollapseRecords = conf.getInt("solr.crossdc.maxCollapseRecords");
        this.startLatch = startLatch;
        Properties kafkaConsumerProps = new Properties();
        kafkaConsumerProps.put("bootstrap.servers", conf.get("solr.crossdc.bootstrapServers"));
        kafkaConsumerProps.put("group.id", conf.get("solr.crossdc.groupId"));
        kafkaConsumerProps.put("max.poll.records", conf.getInt("solr.crossdc.maxPollRecords"));
        kafkaConsumerProps.put("max.poll.interval.ms", conf.get("solr.crossdc.maxPollIntervalMs"));
        kafkaConsumerProps.put("session.timeout.ms", conf.get("solr.crossdc.sessionTimeoutMs"));
        kafkaConsumerProps.put("auto.offset.reset", "earliest");
        kafkaConsumerProps.put("enable.auto.commit", (Object)false);
        kafkaConsumerProps.put("fetch.min.bytes", conf.getInt("solr.crossdc.fetchMinBytes"));
        kafkaConsumerProps.put("fetch.max.wait.ms", conf.getInt("solr.crossdc.fetchMaxWaitMS"));
        kafkaConsumerProps.put("fetch.max.bytes", conf.getInt("solr.crossdc.fetchMaxBytes"));
        kafkaConsumerProps.put("max.partition.fetch.bytes", conf.getInt("solr.crossdc.maxPartitionFetchBytes"));
        kafkaConsumerProps.put("request.timeout.ms", conf.getInt("solr.crossdc.requestTimeoutMS"));
        KafkaCrossDcConf.addSecurityProps((KafkaCrossDcConf)conf, (Properties)kafkaConsumerProps);
        kafkaConsumerProps.putAll((Map<?, ?>)conf.getAdditionalProperties());
        int threads = conf.getInt("solr.crossdc.consumerProcessingThreads");
        this.executor = new ExecutorUtil.MDCAwareThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, this.queue, r -> new Thread(r, "KafkaCrossDcConsumerWorker"));
        this.executor.prestartAllCoreThreads();
        this.solrClient = this.createSolrClient(conf);
        this.messageProcessor = this.createSolrMessageProcessor();
        log.info("Creating Kafka consumer with configuration {}", (Object)kafkaConsumerProps);
        this.kafkaConsumer = this.createKafkaConsumer(kafkaConsumerProps);
        this.partitionManager = new PartitionManager(this.kafkaConsumer);
        log.info("Creating Kafka resubmit producer");
        this.kafkaMirroringSink = this.createKafkaMirroringSink(conf);
        log.info("Created Kafka resubmit producer");
    }

    protected SolrMessageProcessor createSolrMessageProcessor() {
        return new SolrMessageProcessor(this.solrClient, resubmitRequest -> 0L);
    }

    public KafkaConsumer<String, MirroredSolrRequest<?>> createKafkaConsumer(Properties properties) {
        return new KafkaConsumer(properties, (Deserializer)new StringDeserializer(), (Deserializer)new MirroredSolrRequestSerializer());
    }

    @Override
    public void run() {
        List<String> topicNameList = Arrays.asList(this.topicNames);
        log.info("About to start Kafka consumer thread, topics={}", topicNameList);
        try {
            this.kafkaConsumer.subscribe(topicNameList);
            log.info("Consumer started");
            this.startLatch.countDown();
            while (this.pollAndProcessRequests()) {
            }
            log.info("Closed kafka consumer. Exiting now.");
            try {
                this.kafkaConsumer.close();
            }
            catch (Exception e) {
                log.warn("Failed to close kafka consumer", (Throwable)e);
            }
            try {
                this.kafkaMirroringSink.close();
            }
            catch (Exception e) {
                log.warn("Failed to close kafka mirroring sink", (Throwable)e);
            }
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)this.solrClient);
        }
    }

    boolean pollAndProcessRequests() {
        log.trace("Entered pollAndProcessRequests loop");
        try {
            try {
                this.partitionManager.checkOffsetUpdates();
            }
            catch (Throwable e) {
                log.error("Error while checking offset updates, shutting down", e);
                return false;
            }
            ConsumerRecords records = this.kafkaConsumer.poll(Duration.ofMillis(5000L));
            if (log.isTraceEnabled()) {
                log.trace("poll return {} records", (Object)records.count());
            }
            UpdateRequest updateReqBatch = null;
            int currentCollapsed = 0;
            ConsumerRecord lastRecord = null;
            for (TopicPartition partition : records.partitions()) {
                List partitionRecords = records.records(partition);
                PartitionManager.PartitionWork partitionWork = this.partitionManager.getPartitionWork(partition);
                PartitionManager.WorkUnit workUnit = new PartitionManager.WorkUnit(partition);
                workUnit.nextOffset = PartitionManager.getOffsetForPartition(partitionRecords);
                partitionWork.partitionQueue.add(workUnit);
                try {
                    ModifiableSolrParams lastUpdateParams = null;
                    NamedList lastUpdateParamsAsNamedList = null;
                    for (ConsumerRecord requestRecord : partitionRecords) {
                        if (log.isTraceEnabled()) {
                            log.trace("Fetched record from topic={} partition={} key={} value={}", new Object[]{requestRecord.topic(), requestRecord.partition(), requestRecord.key(), requestRecord.value()});
                        }
                        lastRecord = requestRecord;
                        MirroredSolrRequest req = (MirroredSolrRequest)requestRecord.value();
                        SolrRequest solrReq = req.getSolrRequest();
                        MirroredSolrRequest.Type type = req.getType();
                        this.metrics.counter(MetricRegistry.name((String)type.name(), (String[])new String[]{"input"})).inc();
                        ModifiableSolrParams params = new ModifiableSolrParams(solrReq.getParams());
                        if (log.isTraceEnabled()) {
                            log.trace("-- picked type={}, params={}", (Object)req.getType(), (Object)params);
                        }
                        boolean hasDeletes = false;
                        if (type == MirroredSolrRequest.Type.UPDATE) {
                            UpdateRequest ureq = (UpdateRequest)solrReq;
                            boolean bl = hasDeletes = this.hasDeletes(ureq) || this.hasDeletes(updateReqBatch);
                        }
                        if (type == MirroredSolrRequest.Type.UPDATE && (lastUpdateParams != null && !lastUpdateParams.toNamedList().equals((Object)params.toNamedList()) || this.collapseUpdates == CrossDcConf.CollapseUpdates.NONE || this.collapseUpdates == CrossDcConf.CollapseUpdates.PARTIAL && hasDeletes || currentCollapsed >= this.maxCollapseRecords)) {
                            if (log.isTraceEnabled()) {
                                log.trace("Starting new UpdateRequest, params={}", (Object)params);
                            }
                            if (updateReqBatch != null) {
                                this.sendBatch((SolrRequest<?>)updateReqBatch, type, (ConsumerRecord<String, MirroredSolrRequest<?>>)lastRecord, workUnit);
                            }
                            updateReqBatch = null;
                            lastUpdateParamsAsNamedList = null;
                            currentCollapsed = 0;
                            workUnit = new PartitionManager.WorkUnit(partition);
                            workUnit.nextOffset = PartitionManager.getOffsetForPartition(partitionRecords);
                            partitionWork.partitionQueue.add(workUnit);
                        }
                        lastUpdateParams = params;
                        if (type == MirroredSolrRequest.Type.UPDATE) {
                            List deleteByQuery;
                            List deletes;
                            List docs;
                            if (updateReqBatch == null) {
                                updateReqBatch = new UpdateRequest();
                            } else {
                                if (this.collapseUpdates == CrossDcConf.CollapseUpdates.NONE) {
                                    throw new RuntimeException("Can't collapse requests.");
                                }
                                if (this.collapseUpdates == CrossDcConf.CollapseUpdates.PARTIAL && hasDeletes) {
                                    throw new RuntimeException("Can't collapse requests with deletions.");
                                }
                                this.metrics.counter(MetricRegistry.name((String)type.name(), (String[])new String[]{"collapsed"})).inc();
                                ++currentCollapsed;
                            }
                            UpdateRequest update = (UpdateRequest)solrReq;
                            MirroredSolrRequest.setParams((SolrRequest)updateReqBatch, (ModifiableSolrParams)params);
                            if (lastUpdateParamsAsNamedList == null) {
                                lastUpdateParamsAsNamedList = lastUpdateParams.toNamedList();
                            }
                            if ((docs = update.getDocuments()) != null) {
                                updateReqBatch.add((Collection)docs);
                                this.metrics.counter(MetricRegistry.name((String)type.name(), (String[])new String[]{"add"})).inc((long)docs.size());
                            }
                            if ((deletes = update.getDeleteById()) != null) {
                                updateReqBatch.deleteById(deletes);
                                this.metrics.counter(MetricRegistry.name((String)type.name(), (String[])new String[]{"dbi"})).inc((long)deletes.size());
                            }
                            if ((deleteByQuery = update.getDeleteQuery()) == null) continue;
                            for (String delByQuery : deleteByQuery) {
                                updateReqBatch.deleteByQuery(delByQuery);
                            }
                            this.metrics.counter(MetricRegistry.name((String)type.name(), (String[])new String[]{"dbq"})).inc((long)deleteByQuery.size());
                            continue;
                        }
                        this.sendBatch(req.getSolrRequest(), type, lastRecord, workUnit);
                    }
                    if (updateReqBatch != null) {
                        this.sendBatch((SolrRequest<?>)updateReqBatch, MirroredSolrRequest.Type.UPDATE, (ConsumerRecord<String, MirroredSolrRequest<?>>)lastRecord, workUnit);
                    }
                    try {
                        this.partitionManager.checkForOffsetUpdates(partition);
                    }
                    catch (Throwable e) {
                        log.error("Error while checking offset updates, shutting down", e);
                        return false;
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    log.info("Kafka Consumer thread interrupted, shutting down Kafka consumer.");
                    return false;
                }
                catch (WakeupException e) {
                    log.info("Caught wakeup exception, shutting down KafkaSolrRequestConsumer.");
                    return false;
                }
                catch (Exception e) {
                    if (e instanceof ClassCastException || e instanceof SerializationException) {
                        log.error("Non retryable error", (Throwable)e);
                        return false;
                    }
                    log.error("Exception occurred in Kafka consumer thread, stopping the Consumer.", (Throwable)e);
                    return false;
                }
            }
            try {
                this.partitionManager.checkOffsetUpdates();
            }
            catch (Throwable e) {
                log.error("Error while checking offset updates, shutting down", e);
                return false;
            }
        }
        catch (WakeupException e) {
            log.info("Caught wakeup exception, shutting down KafkaSolrRequestConsumer");
            return false;
        }
        catch (Exception e) {
            if (e instanceof ClassCastException || e instanceof SerializationException) {
                log.error("Non retryable error", (Throwable)e);
                return false;
            }
            log.error("Exception occurred in Kafka consumer thread, but we will continue.", (Throwable)e);
        }
        return true;
    }

    private boolean hasDeletes(UpdateRequest ureq) {
        if (ureq == null) {
            return false;
        }
        return ureq.getDeleteByIdMap() != null && !ureq.getDeleteByIdMap().isEmpty() || ureq.getDeleteQuery() != null && !ureq.getDeleteQuery().isEmpty();
    }

    public void sendBatch(SolrRequest<?> solrReqBatch, MirroredSolrRequest.Type type, ConsumerRecord<String, MirroredSolrRequest<?>> lastRecord, PartitionManager.WorkUnit workUnit) {
        Future<?> future = this.executor.submit(() -> {
            try {
                MirroredSolrRequest mirroredSolrRequest = new MirroredSolrRequest(type, ((MirroredSolrRequest)lastRecord.value()).getAttempt(), solrReqBatch);
                IQueueHandler.Result<MirroredSolrRequest<?>> result = this.messageProcessor.handleItem(mirroredSolrRequest);
                this.processResult(type, result);
            }
            catch (MirroringException e) {
                log.error("Mirroring exception occurred while resubmitting to Kafka. We are going to stop the consumer thread now.", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
        workUnit.workItems.add(future);
    }

    protected void processResult(MirroredSolrRequest.Type type, IQueueHandler.Result<MirroredSolrRequest<?>> result) throws MirroringException {
        MirroredSolrRequest item = (MirroredSolrRequest)result.getItem();
        switch (result.status()) {
            case FAILED_RESUBMIT: {
                int attempt;
                if (log.isTraceEnabled()) {
                    log.trace("result=failed-resubmit");
                }
                if ((attempt = item.getAttempt()) > this.maxAttempts) {
                    log.info("Sending message to dead letter queue because of max attempts limit with current value = {}", (Object)attempt);
                    this.kafkaMirroringSink.submitToDlq(item);
                    this.metrics.counter(MetricRegistry.name((String)type.name(), (String[])new String[]{"failed-dlq"})).inc();
                    break;
                }
                this.kafkaMirroringSink.submit(item);
                this.metrics.counter(MetricRegistry.name((String)type.name(), (String[])new String[]{"failed-resubmit"})).inc();
                break;
            }
            case HANDLED: {
                if (log.isTraceEnabled()) {
                    log.trace("result=handled");
                }
                this.metrics.counter(MetricRegistry.name((String)type.name(), (String[])new String[]{"handled"})).inc();
                break;
            }
            case NOT_HANDLED_SHUTDOWN: {
                if (log.isTraceEnabled()) {
                    log.trace("result=nothandled_shutdown");
                }
                this.metrics.counter(MetricRegistry.name((String)type.name(), (String[])new String[]{"nothandled_shutdown"})).inc();
                break;
            }
            case FAILED_RETRY: {
                log.error("Unexpected response while processing request. We never expect {}.", (Object)result.status());
                this.metrics.counter(MetricRegistry.name((String)type.name(), (String[])new String[]{"failed-retry"})).inc();
                break;
            }
            default: {
                if (!log.isTraceEnabled()) break;
                log.trace("result=no matching case");
            }
        }
    }

    @Override
    public final void shutdown() {
        this.kafkaConsumer.wakeup();
        log.info("Shutdown called on KafkaCrossDcConsumer");
        try {
            if (!this.executor.isShutdown()) {
                this.executor.shutdown();
                this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            if (!this.offsetCheckExecutor.isShutdown()) {
                this.offsetCheckExecutor.shutdown();
                this.offsetCheckExecutor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            this.solrClient.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted while waiting for executor to shutdown");
        }
        catch (Exception e) {
            log.warn("Exception closing Solr client on shutdown", (Throwable)e);
        }
        finally {
            Util.logMetrics(this.metrics);
        }
    }

    protected CloudSolrClient createSolrClient(KafkaCrossDcConf conf) {
        return new CloudSolrClient.Builder(Collections.singletonList(conf.get("solr.crossdc.zkConnectString")), Optional.empty()).build();
    }

    protected KafkaMirroringSink createKafkaMirroringSink(KafkaCrossDcConf conf) {
        return new KafkaMirroringSink(conf);
    }
}

