/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.internal.geoapi.temporal.Instant;
import org.apache.sis.internal.geoapi.temporal.Period;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.internal.jaxb.gml.TimeInstant;
import org.apache.sis.internal.jaxb.gml.TimePeriod;
import org.apache.sis.internal.jaxb.gml.TimePeriodBound;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.internal.xml.XmlUtilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.temporal.TemporalPrimitive;

public class TM_Primitive
extends PropertyType<TM_Primitive, TemporalPrimitive> {
    public TM_Primitive() {
    }

    private TM_Primitive(TemporalPrimitive temporalPrimitive) {
        super(temporalPrimitive);
    }

    @Override
    protected TM_Primitive wrap(TemporalPrimitive temporalPrimitive) {
        return new TM_Primitive(temporalPrimitive);
    }

    @Override
    protected final Class<TemporalPrimitive> getBoundType() {
        return TemporalPrimitive.class;
    }

    @XmlElement(name="TimePeriod")
    public final TimePeriod getTimePeriod() {
        TemporalPrimitive temporalPrimitive = (TemporalPrimitive)this.metadata;
        return temporalPrimitive instanceof Period ? new TimePeriod((Period)temporalPrimitive) : null;
    }

    @XmlElement(name="TimeInstant")
    public final TimeInstant getTimeInstant() {
        TemporalPrimitive temporalPrimitive = (TemporalPrimitive)this.metadata;
        return temporalPrimitive instanceof Instant ? new TimeInstant((Instant)temporalPrimitive) : null;
    }

    public final void setTimePeriod(TimePeriod timePeriod) {
        this.metadata = null;
        if (timePeriod != null) {
            Context context = Context.current();
            Date date = TM_Primitive.toDate(context, timePeriod.begin);
            Date date2 = TM_Primitive.toDate(context, timePeriod.end);
            if (date != null || date2 != null) {
                if (date != null && date2 != null && date2.before(date)) {
                    Context.warningOccured(context, TemporalPrimitive.class, "setTimePeriod", Errors.class, (short)60, date, date2);
                } else {
                    try {
                        this.metadata = TemporalUtilities.createPeriod(date, date2);
                        timePeriod.copyIdTo(this.metadata);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        TM_Primitive.warningOccured("setTimePeriod", unsupportedOperationException);
                    }
                }
            }
        }
    }

    public final void setTimeInstant(TimeInstant timeInstant) {
        Date date;
        this.metadata = null;
        if (timeInstant != null && (date = XmlUtilities.toDate(Context.current(), timeInstant.timePosition)) != null) {
            try {
                this.metadata = TemporalUtilities.createInstant(date);
                timeInstant.copyIdTo(this.metadata);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                TM_Primitive.warningOccured("setTimeInstant", unsupportedOperationException);
            }
        }
    }

    private static Date toDate(Context context, TimePeriodBound timePeriodBound) {
        return timePeriodBound != null ? XmlUtilities.toDate(context, timePeriodBound.calendar()) : null;
    }

    private static void warningOccured(String string, Exception exception) {
        Context.warningOccured(Context.current(), TM_Primitive.class, string, exception, true);
    }

    public static final class Since2014
    extends TM_Primitive {
        @Override
        protected TM_Primitive wrap(TemporalPrimitive temporalPrimitive) {
            return this.accept2014() ? super.wrap(temporalPrimitive) : null;
        }
    }
}

