/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.math.matrix;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.carrot2.attrs.AttrComposite;
import org.carrot2.attrs.AttrEnum;
import org.carrot2.math.mahout.matrix.DoubleMatrix2D;
import org.carrot2.math.matrix.FactorizationQuality;
import org.carrot2.math.matrix.KMeansSeedingStrategyFactory;
import org.carrot2.math.matrix.LocalNonnegativeMatrixFactorizationFactory;
import org.carrot2.math.matrix.MatrixFactorizationFactory;
import org.carrot2.math.matrix.NonnegativeMatrixFactorizationEDFactory;
import org.carrot2.math.matrix.NonnegativeMatrixFactorizationKLFactory;
import org.carrot2.math.matrix.RandomSeedingStrategyFactory;
import org.carrot2.math.matrix.SeedingStrategy;
import org.carrot2.math.matrix.SeedingStrategyFactory;

public abstract class IterativeMatrixFactorizationFactory
extends AttrComposite
implements MatrixFactorizationFactory {
    public final AttrEnum<FactorizationQuality> factorizationQuality;
    protected int k;
    protected static final int DEFAULT_K = 15;
    protected int maxIterations;
    protected static final int DEFAULT_MAX_ITERATIONS = 15;
    protected double stopThreshold;
    protected static final double DEFAULT_STOP_THRESHOLD = -1.0;
    protected SeedingStrategyFactory seedingFactory;
    protected static final SeedingStrategyFactory DEFAULT_SEEDING_FACTORY = new RandomSeedingStrategyFactory(0);
    protected boolean ordered;
    protected static final boolean DEFAULT_ORDERED = true;
    private static Map<List<Object>, double[]> allKnownCoefficients = new HashMap<List<Object>, double[]>();

    public IterativeMatrixFactorizationFactory() {
        this.factorizationQuality = this.attributes.register("factorizationQuality", ((AttrEnum.Builder)AttrEnum.builder(FactorizationQuality.class).label("Factorization quality")).defaultValue(FactorizationQuality.HIGH));
        this.k = 15;
        this.maxIterations = 15;
        this.stopThreshold = -1.0;
        this.seedingFactory = DEFAULT_SEEDING_FACTORY;
        this.ordered = true;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getK() {
        return this.k;
    }

    protected SeedingStrategy createSeedingStrategy() {
        return this.seedingFactory.createSeedingStrategy();
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public double getStopThreshold() {
        return this.stopThreshold;
    }

    public void setStopThreshold(double stopThreshold) {
        this.stopThreshold = stopThreshold;
    }

    public SeedingStrategyFactory getSeedingFactory() {
        return this.seedingFactory;
    }

    public void setSeedingFactory(SeedingStrategyFactory seedingFactory) {
        this.seedingFactory = seedingFactory;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void estimateIterationsNumber(int dimensions, DoubleMatrix2D termDocumentMatrix) {
        double columns;
        this.setK(dimensions);
        double[] coefficients = allKnownCoefficients.get(Arrays.asList(this.getClass(), this.getSeedingFactory().getClass(), (Serializable)this.factorizationQuality.get()));
        DoubleMatrix2D A = termDocumentMatrix;
        if (coefficients != null && !((columns = Math.sqrt((double)(A.rows() * A.columns()) / 2.8)) < 50.0) && !(columns > 400.0) && this.getK() >= 5 && this.getK() <= 50) {
            int iterations = (int)(columns * coefficients[0] + (double)this.getK() * coefficients[1] + coefficients[2]);
            this.setMaxIterations((int)((double)iterations * 0.6));
        }
    }

    static {
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.LOW}), new double[]{-0.0166, 0.3333, 8.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.MEDIUM}), new double[]{-0.0175, 0.6, 12.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.HIGH}), new double[]{-0.0186, 0.8222, 17.3555});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationKLFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.LOW}), new double[]{-0.0166, 0.3333, 8.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationKLFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.MEDIUM}), new double[]{-0.0175, 0.6, 12.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationKLFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.HIGH}), new double[]{-0.0186, 0.8222, 17.3555});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, KMeansSeedingStrategyFactory.class, FactorizationQuality.LOW}), new double[]{-0.005, 0.0, 6.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, KMeansSeedingStrategyFactory.class, FactorizationQuality.MEDIUM}), new double[]{-0.005, 0.0, 10.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, KMeansSeedingStrategyFactory.class, FactorizationQuality.HIGH}), new double[]{-0.005, 0.0, 20.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{LocalNonnegativeMatrixFactorizationFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.LOW}), new double[]{-0.014, 0.1, 7.5});
        allKnownCoefficients.put(Arrays.asList(new Object[]{LocalNonnegativeMatrixFactorizationFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.MEDIUM}), new double[]{-0.0175, 0.15, 11.3333});
        allKnownCoefficients.put(Arrays.asList(new Object[]{LocalNonnegativeMatrixFactorizationFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.HIGH}), new double[]{-0.02333, 0.2, 16.8888});
    }
}

