/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.execution.ExecutionEngine;
import org.netbeans.core.execution.RunClassThread;
import org.netbeans.core.execution.TaskThreadGroup;
import org.openide.execution.ExecutorTask;
import org.openide.util.Exceptions;
import org.openide.windows.InputOutput;

final class DefaultSysProcess
extends ExecutorTask {
    static int processCount;
    private final TaskThreadGroup group;
    private boolean destroyed = false;
    private final InputOutput io;
    private final String name;

    public DefaultSysProcess(Runnable runnable, TaskThreadGroup taskThreadGroup, InputOutput inputOutput, String string) {
        super(runnable);
        this.group = taskThreadGroup;
        this.io = inputOutput;
        this.name = string;
    }

    public synchronized void stop() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        try {
            this.group.interrupt();
            RunClassThread runClassThread = this.group.getRunClassThread();
            if (runClassThread != null) {
                runClassThread.waitForEnd(3000L);
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(DefaultSysProcess.class.getName()).log(Level.FINE, null, interruptedException);
        }
        finally {
            this.group.setRunClassThread(null);
        }
        ExecutionEngine.closeGroup(this.group);
        this.group.kill();
        this.notifyFinished();
    }

    public int result() {
        try {
            this.group.waitFor();
        }
        catch (InterruptedException interruptedException) {
            return 4;
        }
        this.notifyFinished();
        return 0;
    }

    public InputOutput getInputOutput() {
        return this.io;
    }

    public void run() {
    }

    public String getName() {
        return this.name;
    }

    void destroyThreadGroup(ThreadGroup threadGroup) {
        new Thread(threadGroup, new Destroyer(this.group)).start();
    }

    private static class Destroyer
    implements Runnable {
        private final ThreadGroup group;

        Destroyer(ThreadGroup threadGroup) {
            this.group = threadGroup;
        }

        @Override
        public void run() {
            try {
                while (this.group.activeCount() > 0) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            if (!this.group.isDestroyed()) {
                try {
                    this.group.destroy();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
            }
        }
    }
}

