/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Messages;
import org.pentaho.di.core.ObjectUsageCount;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.SortedFileOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Props
implements Cloneable {
    protected static Props props;
    public static final String STRING_FONT_FIXED_NAME = "FontFixedName";
    public static final String STRING_FONT_FIXED_SIZE = "FontFixedSize";
    public static final String STRING_FONT_FIXED_STYLE = "FontFixedStyle";
    public static final String STRING_FONT_DEFAULT_NAME = "FontDefaultName";
    public static final String STRING_FONT_DEFAULT_SIZE = "FontDefaultSize";
    public static final String STRING_FONT_DEFAULT_STYLE = "FontDefaultStyle";
    public static final String STRING_FONT_GRAPH_NAME = "FontGraphName";
    public static final String STRING_FONT_GRAPH_SIZE = "FontGraphSize";
    public static final String STRING_FONT_GRAPH_STYLE = "FontGraphStyle";
    public static final String STRING_FONT_GRID_NAME = "FontGridName";
    public static final String STRING_FONT_GRID_SIZE = "FontGridSize";
    public static final String STRING_FONT_GRID_STYLE = "FontGridStyle";
    public static final String STRING_FONT_NOTE_NAME = "FontNoteName";
    public static final String STRING_FONT_NOTE_SIZE = "FontNoteSize";
    public static final String STRING_FONT_NOTE_STYLE = "FontNoteStyle";
    public static final String STRING_BACKGROUND_COLOR_R = "BackgroundColorR";
    public static final String STRING_BACKGROUND_COLOR_G = "BackgroundColorG";
    public static final String STRING_BACKGROUND_COLOR_B = "BackgroundColorB";
    public static final String STRING_GRAPH_COLOR_R = "GraphColorR";
    public static final String STRING_GRAPH_COLOR_G = "GraphColorG";
    public static final String STRING_GRAPH_COLOR_B = "GraphColorB";
    public static final String STRING_TAB_COLOR_R = "TabColorR";
    public static final String STRING_TAB_COLOR_G = "TabColorG";
    public static final String STRING_TAB_COLOR_B = "TabColorB";
    public static final String STRING_ICON_SIZE = "IconSize";
    public static final String STRING_LINE_WIDTH = "LineWidth";
    public static final String STRING_SHADOW_SIZE = "ShadowSize";
    public static final String STRING_LOG_LEVEL = "LogLevel";
    public static final String STRING_LOG_FILTER = "LogFilter";
    public static final String STRING_MIDDLE_PCT = "MiddlePct";
    public static final String STRING_LAST_PREVIEW_TRANS = "LastPreviewTrans";
    public static final String STRING_LAST_PREVIEW_STEP = "LastPreviewStep";
    public static final String STRING_LAST_PREVIEW_SIZE = "LastPreviewSize";
    public static final String STRING_MAX_UNDO = "MaxUndo";
    public static final String STRING_SIZE_MAX = "SizeMax";
    public static final String STRING_SIZE_X = "SizeX";
    public static final String STRING_SIZE_Y = "SizeY";
    public static final String STRING_SIZE_W = "SizeW";
    public static final String STRING_SIZE_H = "SizeH";
    public static final String STRING_SASH_W1 = "SashWeight1";
    public static final String STRING_SASH_W2 = "SashWeight2";
    public static final String STRING_SHOW_TIPS = "ShowTips";
    public static final String STRING_TIP_NR = "TipNr";
    public static final String STRING_AUTO_SAVE = "AutoSave";
    public static final String STRING_SAVE_CONF = "SaveConfirmation";
    public static final String STRING_AUTO_SPLIT = "AutoSplit";
    public static final String STRING_AUTO_COLLAPSE_CORE_TREE = "AutoCollapseCoreObjectsTree";
    public static final String STRING_USE_DB_CACHE = "UseDBCache";
    public static final String STRING_OPEN_LAST_FILE = "OpenLastFile";
    public static final String STRING_LAST_REPOSITORY_LOGIN = "RepositoryLastLogin";
    public static final String STRING_LAST_REPOSITORY = "RepositoryLast";
    public static final String STRING_ONLY_ACTIVE_STEPS = "OnlyActiveSteps";
    public static final String STRING_START_SHOW_REPOSITORIES = "ShowRepositoriesAtStartup";
    public static final String STRING_ANTI_ALIASING = "EnableAntiAliasing";
    public static final String STRING_SHOW_EXIT_WARNING = "ShowExitWarning";
    public static final String STRING_SHOW_OS_LOOK = "ShowOSLook";
    public static final String STRING_LAST_ARGUMENT = "LastArgument";
    public static final String STRING_ARGUMENT_NAME_PREFIX = "Argument ";
    public static final String STRING_CUSTOM_PARAMETER = "CustomParameter";
    public static final String STRING_PLUGIN_HISTORY = "PluginHistory";
    public static final String STRING_DEFAULT_PREVIEW_SIZE = "DefaultPreviewSize";
    public static final String STRING_ONLY_USED_DB_TO_XML = "SaveOnlyUsedConnectionsToXML";
    public static final String STRING_ASK_ABOUT_REPLACING_DATABASES = "AskAboutReplacingDatabases";
    public static final String STRING_REPLACE_DATABASES = "ReplaceDatabases";
    private static final String STRING_MAX_NR_LINES_IN_LOG = "MaxNrOfLinesInLog";
    private static final String STRING_MAX_NR_LINES_IN_HISTORY = "MaxNrOfLinesInHistory";
    protected LogWriter log = LogWriter.getInstance();
    protected Properties properties;
    protected ArrayList<ObjectUsageCount> pluginHistory;
    protected int type;
    protected String filename;
    public static final int TYPE_PROPERTIES_EMPTY = 0;
    public static final int TYPE_PROPERTIES_SPOON = 1;
    public static final int TYPE_PROPERTIES_PAN = 2;
    public static final int TYPE_PROPERTIES_CHEF = 3;
    public static final int TYPE_PROPERTIES_KITCHEN = 4;
    public static final int TYPE_PROPERTIES_MENU = 5;
    public static final int TYPE_PROPERTIES_PLATE = 6;
    public static final int WIDGET_STYLE_DEFAULT = 0;
    public static final int WIDGET_STYLE_FIXED = 1;
    public static final int WIDGET_STYLE_TABLE = 2;
    public static final int WIDGET_STYLE_NOTEPAD = 3;
    public static final int WIDGET_STYLE_GRAPH = 4;
    public static final int WIDGET_STYLE_TAB = 5;

    public static final void init(int t) {
        if (props != null) {
            throw new RuntimeException("The Properties systems settings are already initialised!");
        }
        props = new Props(t);
    }

    public static final void init(String filename) {
        if (props != null) {
            throw new RuntimeException("The properties systems settings are already initialised!");
        }
        props = new Props(filename);
    }

    public static boolean isInitialized() {
        return props != null;
    }

    public static Props getInstance() {
        if (props != null) {
            return props;
        }
        throw new RuntimeException("Properties, Kettle systems settings, not initialised!");
    }

    protected Props(int t) {
        this.type = t;
        this.filename = this.getFilename();
        this.init();
    }

    protected void init() {
        this.properties = new Properties();
        this.pluginHistory = new ArrayList();
        this.loadProps();
        this.addDefaultEntries();
        this.loadPluginHistory();
    }

    protected Props(String filename) {
        this.properties = new Properties();
        this.type = 0;
        this.filename = filename;
        this.init();
    }

    public String toString() {
        return "User preferences";
    }

    public String getFilename() {
        String directory = Const.getKettleDirectory();
        String filename = "";
        File dir = new File(directory);
        try {
            dir.mkdirs();
            this.createDefaultKettleProperties(directory);
        }
        catch (Exception e) {
            // empty catch block
        }
        switch (this.type) {
            case 1: 
            case 2: {
                filename = directory + Const.FILE_SEPARATOR + ".spoonrc";
                break;
            }
            case 3: 
            case 4: {
                filename = directory + Const.FILE_SEPARATOR + ".chefrc";
                break;
            }
            case 5: {
                filename = directory + Const.FILE_SEPARATOR + ".menurc";
                break;
            }
            case 6: {
                filename = directory + Const.FILE_SEPARATOR + ".platerc";
                break;
            }
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultKettleProperties(String directory) {
        String kpFile = directory + Const.FILE_SEPARATOR + "kettle.properties";
        File file = new File(kpFile);
        if (!file.exists()) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                out.write((Messages.getString("Props.Kettle.Properties.Sample.Line01", "3.2.2") + Const.CR).getBytes());
                out.write((Messages.getString("Props.Kettle.Properties.Sample.Line02") + Const.CR).getBytes());
                out.write((Messages.getString("Props.Kettle.Properties.Sample.Line03") + Const.CR).getBytes());
                out.write((Messages.getString("Props.Kettle.Properties.Sample.Line04") + Const.CR).getBytes());
                out.write((Messages.getString("Props.Kettle.Properties.Sample.Line05") + Const.CR).getBytes());
                out.write((Messages.getString("Props.Kettle.Properties.Sample.Line06") + Const.CR).getBytes());
                out.write((Messages.getString("Props.Kettle.Properties.Sample.Line07") + Const.CR).getBytes());
                out.write((Messages.getString("Props.Kettle.Properties.Sample.Line08") + Const.CR).getBytes());
                out.write((Messages.getString("Props.Kettle.Properties.Sample.Line09") + Const.CR).getBytes());
                out.write((Messages.getString("Props.Kettle.Properties.Sample.Line10") + Const.CR).getBytes());
            }
            catch (IOException e) {
                this.log.logError("kettle.properties", Messages.getString("Props.Log.Error.UnableToCreateDefaultKettleProperties.Message", "kettle.properties", kpFile), e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        this.log.logError("kettle.properties", Messages.getString("Props.Log.Error.UnableToCreateDefaultKettleProperties.Message", "kettle.properties", kpFile), e);
                    }
                }
            }
        }
    }

    public String getLicenseFilename() {
        String directory = Const.getKettleDirectory();
        String filename = directory + Const.FILE_SEPARATOR + ".licence";
        File dir = new File(directory);
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return filename;
    }

    public boolean fileExists() {
        File f = new File(this.filename);
        return f.exists();
    }

    public void setType(int t) {
        this.type = t;
    }

    public int getType() {
        return this.type;
    }

    public boolean loadProps() {
        try {
            this.properties.load(new FileInputStream(this.filename));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected void addDefaultEntries() {
        if (!this.properties.containsKey("JobDialogStyle")) {
            this.properties.setProperty("JobDialogStyle", "RESIZE,MAX,MIN");
        }
    }

    public void saveProps() {
        File spoonRc = new File(this.filename);
        try {
            SortedFileOutputStream fos = new SortedFileOutputStream(spoonRc);
            fos.setLogger(this.log);
            this.properties.store(fos, "Kettle Properties file");
            fos.close();
            this.log.logDetailed(this.toString(), Messages.getString("Spoon.Log.SaveProperties"), new Object[0]);
        }
        catch (IOException e) {
            if (spoonRc.isHidden() && this.filename.indexOf(92) != -1) {
                this.log.logError(this.toString(), Messages.getString("Spoon.Log.SavePropertiesFailedWindowsBugAttr", this.filename), new Object[0]);
            }
            this.log.logError(this.toString(), Messages.getString("Spoon.Log.SavePropertiesFailed") + e.getMessage(), new Object[0]);
        }
    }

    public void setLogLevel(String level) {
        this.properties.setProperty(STRING_LOG_LEVEL, level);
    }

    public String getLogLevel() {
        String level = this.properties.getProperty(STRING_LOG_LEVEL, "Basic");
        return level;
    }

    public void setLogFilter(String filter) {
        this.properties.setProperty(STRING_LOG_FILTER, Const.NVL(filter, ""));
    }

    public String getLogFilter() {
        String level = this.properties.getProperty(STRING_LOG_FILTER, "");
        return level;
    }

    public void setUseDBCache(boolean use) {
        this.properties.setProperty(STRING_USE_DB_CACHE, use ? "Y" : "N");
    }

    public boolean useDBCache() {
        String use = this.properties.getProperty(STRING_USE_DB_CACHE);
        return !"N".equalsIgnoreCase(use);
    }

    public void setLastRepository(String repname) {
        this.properties.setProperty(STRING_LAST_REPOSITORY, repname);
    }

    public String getLastRepository() {
        return this.properties.getProperty(STRING_LAST_REPOSITORY);
    }

    public void setLastRepositoryLogin(String login) {
        this.properties.setProperty(STRING_LAST_REPOSITORY_LOGIN, login);
    }

    public String getLastRepositoryLogin() {
        return this.properties.getProperty(STRING_LAST_REPOSITORY_LOGIN);
    }

    public void setOnlyActiveSteps(boolean only) {
        this.properties.setProperty(STRING_ONLY_ACTIVE_STEPS, only ? "Y" : "N");
    }

    public boolean getOnlyActiveSteps() {
        String only = this.properties.getProperty(STRING_ONLY_ACTIVE_STEPS, "N");
        return "Y".equalsIgnoreCase(only);
    }

    public boolean askAboutReplacingDatabaseConnections() {
        String ask = this.properties.getProperty(STRING_ASK_ABOUT_REPLACING_DATABASES, "N");
        return "Y".equalsIgnoreCase(ask);
    }

    public void setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public void setAskAboutReplacingDatabaseConnections(boolean ask) {
        this.properties.setProperty(STRING_ASK_ABOUT_REPLACING_DATABASES, ask ? "Y" : "N");
    }

    public String getCustomParameter(String parameterName, String defaultValue) {
        return this.properties.getProperty(STRING_CUSTOM_PARAMETER + parameterName, defaultValue);
    }

    public void setCustomParameter(String parameterName, String value) {
        this.properties.setProperty(STRING_CUSTOM_PARAMETER + parameterName, value);
    }

    public void clearCustomParameters() {
        Enumeration<Object> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(STRING_CUSTOM_PARAMETER)) continue;
            this.properties.remove(key);
        }
    }

    public static final int getArgumentNumber(ValueMetaInterface value) {
        if (value != null && value.getName().startsWith(STRING_ARGUMENT_NAME_PREFIX)) {
            return Const.toInt(value.getName().substring(STRING_ARGUMENT_NAME_PREFIX.length()), -1);
        }
        return -1;
    }

    public static final String[] convertArguments(RowMetaAndData row) {
        String[] args = new String[10];
        for (int i = 0; i < row.size(); ++i) {
            ValueMetaInterface valueMeta = row.getValueMeta(i);
            int argNr = Props.getArgumentNumber(valueMeta);
            if (argNr < 0 || argNr >= 10) continue;
            try {
                args[argNr] = row.getString(i, "");
                continue;
            }
            catch (KettleValueException e) {
                args[argNr] = "";
            }
        }
        return args;
    }

    public void setLastArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            this.properties.setProperty("LastArgument_" + i, args[i]);
        }
    }

    public String[] getLastArguments() {
        String[] args = new String[10];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.properties.getProperty("LastArgument_" + i);
        }
        return args;
    }

    public List<ObjectUsageCount> getPluginHistory() {
        return this.pluginHistory;
    }

    public int increasePluginHistory(String pluginID) {
        for (int i = 0; i < this.pluginHistory.size(); ++i) {
            ObjectUsageCount usage = this.pluginHistory.get(i);
            if (!usage.getObjectName().equalsIgnoreCase(pluginID)) continue;
            int uses = usage.increment();
            Collections.sort(this.pluginHistory);
            this.savePluginHistory();
            return uses;
        }
        this.addPluginHistory(pluginID, 1);
        Collections.sort(this.pluginHistory);
        this.savePluginHistory();
        return 1;
    }

    public void addPluginHistory(String pluginID, int uses) {
        this.pluginHistory.add(new ObjectUsageCount(pluginID, uses));
    }

    protected void loadPluginHistory() {
        this.pluginHistory = new ArrayList();
        int i = 0;
        String string = this.properties.getProperty("PluginHistory_" + i);
        while (string != null) {
            this.pluginHistory.add(ObjectUsageCount.fromString(string));
            string = this.properties.getProperty("PluginHistory_" + ++i);
        }
        Collections.sort(this.pluginHistory);
    }

    private void savePluginHistory() {
        for (int i = 0; i < this.pluginHistory.size(); ++i) {
            ObjectUsageCount usage = this.pluginHistory.get(i);
            this.properties.setProperty("PluginHistory_" + i, usage.toString());
        }
    }

    public boolean areOnlyUsedConnectionsSavedToXML() {
        String show = this.properties.getProperty(STRING_ONLY_USED_DB_TO_XML, "N");
        return !"N".equalsIgnoreCase(show);
    }

    public void setOnlyUsedConnectionsSavedToXML(boolean onlyUsedConnections) {
        this.properties.setProperty(STRING_ONLY_USED_DB_TO_XML, onlyUsedConnections ? "Y" : "N");
    }

    public boolean replaceExistingDatabaseConnections() {
        String replace = this.properties.getProperty(STRING_REPLACE_DATABASES, "Y");
        return "Y".equalsIgnoreCase(replace);
    }

    public void setReplaceDatabaseConnections(boolean replace) {
        this.properties.setProperty(STRING_REPLACE_DATABASES, replace ? "Y" : "N");
    }

    public int getMaxNrLinesInLog() {
        String lines = this.properties.getProperty(STRING_MAX_NR_LINES_IN_LOG);
        return Const.toInt(lines, 5000);
    }

    public void setMaxNrLinesInLog(int maxNrLinesInLog) {
        this.properties.setProperty(STRING_MAX_NR_LINES_IN_LOG, Integer.toString(maxNrLinesInLog));
    }

    public int getMaxNrLinesInHistory() {
        String lines = this.properties.getProperty(STRING_MAX_NR_LINES_IN_HISTORY);
        return Const.toInt(lines, 50);
    }

    public void setMaxNrLinesInHistory(int maxNrLinesInHistory) {
        this.properties.setProperty(STRING_MAX_NR_LINES_IN_HISTORY, Integer.toString(maxNrLinesInHistory));
    }
}

