/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.event.authentication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.event.authentication.AbstractAuthenticationEvent;
import org.springframework.security.event.authentication.AbstractAuthenticationFailureEvent;
import org.springframework.security.event.authentication.InteractiveAuthenticationSuccessEvent;
import org.springframework.util.ClassUtils;

public class LoggerListener
implements ApplicationListener {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$event$authentication$LoggerListener == null ? (class$org$springframework$security$event$authentication$LoggerListener = LoggerListener.class$("org.springframework.security.event.authentication.LoggerListener")) : class$org$springframework$security$event$authentication$LoggerListener));
    private boolean logInteractiveAuthenticationSuccessEvents = true;
    static /* synthetic */ Class class$org$springframework$security$event$authentication$LoggerListener;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof AbstractAuthenticationEvent) {
            AbstractAuthenticationEvent authEvent = (AbstractAuthenticationEvent)event;
            if (!this.logInteractiveAuthenticationSuccessEvents && authEvent instanceof InteractiveAuthenticationSuccessEvent) {
                return;
            }
            if (logger.isWarnEnabled()) {
                String message = "Authentication event " + ClassUtils.getShortName(((Object)((Object)authEvent)).getClass()) + ": " + authEvent.getAuthentication().getName() + "; details: " + authEvent.getAuthentication().getDetails();
                if (event instanceof AbstractAuthenticationFailureEvent) {
                    message = message + "; exception: " + ((AbstractAuthenticationFailureEvent)event).getException().getMessage();
                }
                logger.warn((Object)message);
            }
        }
    }

    public boolean isLogInteractiveAuthenticationSuccessEvents() {
        return this.logInteractiveAuthenticationSuccessEvents;
    }

    public void setLogInteractiveAuthenticationSuccessEvents(boolean logInteractiveAuthenticationSuccessEvents) {
        this.logInteractiveAuthenticationSuccessEvents = logInteractiveAuthenticationSuccessEvents;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

