/*
 * Copyright Mesa3D Contributors
 * SPDX-License-Identifier: MIT
 *
 * Autogenerated file, do not edit
 */
#pragma once
#include <stdint.h>
#include "compiler/nir/nir_builder.h"

static inline void
gfx11_write_3DSTATE_VERTEX_BUFFERS(nir_builder *b, nir_def *dst_ptr, nir_def *buffer_count)
{
   assert(dst_ptr->bit_size == 64);
   assert(dst_ptr->num_components == 1);
   assert(buffer_count->bit_size == 32);
   assert(buffer_count->num_components == 1);

   nir_function *func = nir_shader_get_function_for_name(b->shader, "gfx11_write_3DSTATE_VERTEX_BUFFERS");

   if (!func) {
      func = nir_function_create(b->shader, "gfx11_write_3DSTATE_VERTEX_BUFFERS");
      func->num_params = 2;
      func->params = rzalloc_array(b->shader, nir_parameter, func->num_params);

      func->params[0].bit_size = 64;
      func->params[0].num_components = 1;
      func->params[0].name = "dst_ptr";

      func->params[1].bit_size = 32;
      func->params[1].num_components = 1;
      func->params[1].name = "buffer_count";
   }

   nir_call(b, func, dst_ptr, buffer_count);
}

static inline void
gfx11_write_VERTEX_BUFFER_STATE(nir_builder *b, nir_def *dst_ptr, nir_def *mocs, nir_def *buffer_idx, nir_def *address, nir_def *size, nir_def *stride)
{
   assert(dst_ptr->bit_size == 64);
   assert(dst_ptr->num_components == 1);
   assert(mocs->bit_size == 32);
   assert(mocs->num_components == 1);
   assert(buffer_idx->bit_size == 32);
   assert(buffer_idx->num_components == 1);
   assert(address->bit_size == 64);
   assert(address->num_components == 1);
   assert(size->bit_size == 32);
   assert(size->num_components == 1);
   assert(stride->bit_size == 32);
   assert(stride->num_components == 1);

   nir_function *func = nir_shader_get_function_for_name(b->shader, "gfx11_write_VERTEX_BUFFER_STATE");

   if (!func) {
      func = nir_function_create(b->shader, "gfx11_write_VERTEX_BUFFER_STATE");
      func->num_params = 6;
      func->params = rzalloc_array(b->shader, nir_parameter, func->num_params);

      func->params[0].bit_size = 64;
      func->params[0].num_components = 1;
      func->params[0].name = "dst_ptr";

      func->params[1].bit_size = 32;
      func->params[1].num_components = 1;
      func->params[1].name = "mocs";

      func->params[2].bit_size = 32;
      func->params[2].num_components = 1;
      func->params[2].name = "buffer_idx";

      func->params[3].bit_size = 64;
      func->params[3].num_components = 1;
      func->params[3].name = "address";

      func->params[4].bit_size = 32;
      func->params[4].num_components = 1;
      func->params[4].name = "size";

      func->params[5].bit_size = 32;
      func->params[5].num_components = 1;
      func->params[5].name = "stride";
   }

   nir_call(b, func, dst_ptr, mocs, buffer_idx, address, size, stride);
}

static inline void
gfx11_write_3DPRIMITIVE(nir_builder *b, nir_def *dst_ptr, nir_def *is_predicated, nir_def *is_indexed, nir_def *uses_tbimr, nir_def *vertex_count_per_instance, nir_def *start_vertex_location, nir_def *instance_count, nir_def *start_instance_location, nir_def *base_vertex_location)
{
   assert(dst_ptr->bit_size == 64);
   assert(dst_ptr->num_components == 1);
   assert(is_predicated->bit_size == 1);
   assert(is_predicated->num_components == 1);
   assert(is_indexed->bit_size == 1);
   assert(is_indexed->num_components == 1);
   assert(uses_tbimr->bit_size == 1);
   assert(uses_tbimr->num_components == 1);
   assert(vertex_count_per_instance->bit_size == 32);
   assert(vertex_count_per_instance->num_components == 1);
   assert(start_vertex_location->bit_size == 32);
   assert(start_vertex_location->num_components == 1);
   assert(instance_count->bit_size == 32);
   assert(instance_count->num_components == 1);
   assert(start_instance_location->bit_size == 32);
   assert(start_instance_location->num_components == 1);
   assert(base_vertex_location->bit_size == 32);
   assert(base_vertex_location->num_components == 1);

   nir_function *func = nir_shader_get_function_for_name(b->shader, "gfx11_write_3DPRIMITIVE");

   if (!func) {
      func = nir_function_create(b->shader, "gfx11_write_3DPRIMITIVE");
      func->num_params = 9;
      func->params = rzalloc_array(b->shader, nir_parameter, func->num_params);

      func->params[0].bit_size = 64;
      func->params[0].num_components = 1;
      func->params[0].name = "dst_ptr";

      func->params[1].bit_size = 1;
      func->params[1].num_components = 1;
      func->params[1].name = "is_predicated";

      func->params[2].bit_size = 1;
      func->params[2].num_components = 1;
      func->params[2].name = "is_indexed";

      func->params[3].bit_size = 1;
      func->params[3].num_components = 1;
      func->params[3].name = "uses_tbimr";

      func->params[4].bit_size = 32;
      func->params[4].num_components = 1;
      func->params[4].name = "vertex_count_per_instance";

      func->params[5].bit_size = 32;
      func->params[5].num_components = 1;
      func->params[5].name = "start_vertex_location";

      func->params[6].bit_size = 32;
      func->params[6].num_components = 1;
      func->params[6].name = "instance_count";

      func->params[7].bit_size = 32;
      func->params[7].num_components = 1;
      func->params[7].name = "start_instance_location";

      func->params[8].bit_size = 32;
      func->params[8].num_components = 1;
      func->params[8].name = "base_vertex_location";
   }

   nir_call(b, func, dst_ptr, is_predicated, is_indexed, uses_tbimr, vertex_count_per_instance, start_vertex_location, instance_count, start_instance_location, base_vertex_location);
}

static inline void
gfx11_write_3DPRIMITIVE_EXTENDED(nir_builder *b, nir_def *dst_ptr, nir_def *is_predicated, nir_def *is_indexed, nir_def *uses_tbimr, nir_def *vertex_count_per_instance, nir_def *start_vertex_location, nir_def *instance_count, nir_def *start_instance_location, nir_def *base_vertex_location, nir_def *param_base_vertex, nir_def *param_base_instance, nir_def *param_draw_id)
{
   assert(dst_ptr->bit_size == 64);
   assert(dst_ptr->num_components == 1);
   assert(is_predicated->bit_size == 1);
   assert(is_predicated->num_components == 1);
   assert(is_indexed->bit_size == 1);
   assert(is_indexed->num_components == 1);
   assert(uses_tbimr->bit_size == 1);
   assert(uses_tbimr->num_components == 1);
   assert(vertex_count_per_instance->bit_size == 32);
   assert(vertex_count_per_instance->num_components == 1);
   assert(start_vertex_location->bit_size == 32);
   assert(start_vertex_location->num_components == 1);
   assert(instance_count->bit_size == 32);
   assert(instance_count->num_components == 1);
   assert(start_instance_location->bit_size == 32);
   assert(start_instance_location->num_components == 1);
   assert(base_vertex_location->bit_size == 32);
   assert(base_vertex_location->num_components == 1);
   assert(param_base_vertex->bit_size == 32);
   assert(param_base_vertex->num_components == 1);
   assert(param_base_instance->bit_size == 32);
   assert(param_base_instance->num_components == 1);
   assert(param_draw_id->bit_size == 32);
   assert(param_draw_id->num_components == 1);

   nir_function *func = nir_shader_get_function_for_name(b->shader, "gfx11_write_3DPRIMITIVE_EXTENDED");

   if (!func) {
      func = nir_function_create(b->shader, "gfx11_write_3DPRIMITIVE_EXTENDED");
      func->num_params = 12;
      func->params = rzalloc_array(b->shader, nir_parameter, func->num_params);

      func->params[0].bit_size = 64;
      func->params[0].num_components = 1;
      func->params[0].name = "dst_ptr";

      func->params[1].bit_size = 1;
      func->params[1].num_components = 1;
      func->params[1].name = "is_predicated";

      func->params[2].bit_size = 1;
      func->params[2].num_components = 1;
      func->params[2].name = "is_indexed";

      func->params[3].bit_size = 1;
      func->params[3].num_components = 1;
      func->params[3].name = "uses_tbimr";

      func->params[4].bit_size = 32;
      func->params[4].num_components = 1;
      func->params[4].name = "vertex_count_per_instance";

      func->params[5].bit_size = 32;
      func->params[5].num_components = 1;
      func->params[5].name = "start_vertex_location";

      func->params[6].bit_size = 32;
      func->params[6].num_components = 1;
      func->params[6].name = "instance_count";

      func->params[7].bit_size = 32;
      func->params[7].num_components = 1;
      func->params[7].name = "start_instance_location";

      func->params[8].bit_size = 32;
      func->params[8].num_components = 1;
      func->params[8].name = "base_vertex_location";

      func->params[9].bit_size = 32;
      func->params[9].num_components = 1;
      func->params[9].name = "param_base_vertex";

      func->params[10].bit_size = 32;
      func->params[10].num_components = 1;
      func->params[10].name = "param_base_instance";

      func->params[11].bit_size = 32;
      func->params[11].num_components = 1;
      func->params[11].name = "param_draw_id";
   }

   nir_call(b, func, dst_ptr, is_predicated, is_indexed, uses_tbimr, vertex_count_per_instance, start_vertex_location, instance_count, start_instance_location, base_vertex_location, param_base_vertex, param_base_instance, param_draw_id);
}

static inline void
gfx11_write_MI_BATCH_BUFFER_START(nir_builder *b, nir_def *dst_ptr, nir_def *addr)
{
   assert(dst_ptr->bit_size == 64);
   assert(dst_ptr->num_components == 1);
   assert(addr->bit_size == 64);
   assert(addr->num_components == 1);

   nir_function *func = nir_shader_get_function_for_name(b->shader, "gfx11_write_MI_BATCH_BUFFER_START");

   if (!func) {
      func = nir_function_create(b->shader, "gfx11_write_MI_BATCH_BUFFER_START");
      func->num_params = 2;
      func->params = rzalloc_array(b->shader, nir_parameter, func->num_params);

      func->params[0].bit_size = 64;
      func->params[0].num_components = 1;
      func->params[0].name = "dst_ptr";

      func->params[1].bit_size = 64;
      func->params[1].num_components = 1;
      func->params[1].name = "addr";
   }

   nir_call(b, func, dst_ptr, addr);
}

static inline void
gfx11_write_draw(nir_builder *b, nir_def *dst_ptr, nir_def *indirect_ptr, nir_def *draw_id_ptr, nir_def *draw_id, nir_def *instance_multiplier, nir_def *is_indexed, nir_def *is_predicated, nir_def *uses_tbimr, nir_def *uses_base, nir_def *uses_drawid, nir_def *mocs)
{
   assert(dst_ptr->bit_size == 64);
   assert(dst_ptr->num_components == 1);
   assert(indirect_ptr->bit_size == 64);
   assert(indirect_ptr->num_components == 1);
   assert(draw_id_ptr->bit_size == 64);
   assert(draw_id_ptr->num_components == 1);
   assert(draw_id->bit_size == 32);
   assert(draw_id->num_components == 1);
   assert(instance_multiplier->bit_size == 32);
   assert(instance_multiplier->num_components == 1);
   assert(is_indexed->bit_size == 1);
   assert(is_indexed->num_components == 1);
   assert(is_predicated->bit_size == 1);
   assert(is_predicated->num_components == 1);
   assert(uses_tbimr->bit_size == 1);
   assert(uses_tbimr->num_components == 1);
   assert(uses_base->bit_size == 1);
   assert(uses_base->num_components == 1);
   assert(uses_drawid->bit_size == 1);
   assert(uses_drawid->num_components == 1);
   assert(mocs->bit_size == 32);
   assert(mocs->num_components == 1);

   nir_function *func = nir_shader_get_function_for_name(b->shader, "gfx11_write_draw");

   if (!func) {
      func = nir_function_create(b->shader, "gfx11_write_draw");
      func->num_params = 11;
      func->params = rzalloc_array(b->shader, nir_parameter, func->num_params);

      func->params[0].bit_size = 64;
      func->params[0].num_components = 1;
      func->params[0].name = "dst_ptr";

      func->params[1].bit_size = 64;
      func->params[1].num_components = 1;
      func->params[1].name = "indirect_ptr";

      func->params[2].bit_size = 64;
      func->params[2].num_components = 1;
      func->params[2].name = "draw_id_ptr";

      func->params[3].bit_size = 32;
      func->params[3].num_components = 1;
      func->params[3].name = "draw_id";

      func->params[4].bit_size = 32;
      func->params[4].num_components = 1;
      func->params[4].name = "instance_multiplier";

      func->params[5].bit_size = 1;
      func->params[5].num_components = 1;
      func->params[5].name = "is_indexed";

      func->params[6].bit_size = 1;
      func->params[6].num_components = 1;
      func->params[6].name = "is_predicated";

      func->params[7].bit_size = 1;
      func->params[7].num_components = 1;
      func->params[7].name = "uses_tbimr";

      func->params[8].bit_size = 1;
      func->params[8].num_components = 1;
      func->params[8].name = "uses_base";

      func->params[9].bit_size = 1;
      func->params[9].num_components = 1;
      func->params[9].name = "uses_drawid";

      func->params[10].bit_size = 32;
      func->params[10].num_components = 1;
      func->params[10].name = "mocs";
   }

   nir_call(b, func, dst_ptr, indirect_ptr, draw_id_ptr, draw_id, instance_multiplier, is_indexed, is_predicated, uses_tbimr, uses_base, uses_drawid, mocs);
}

static inline void
gfx11_libanv_write_draw(nir_builder *b, nir_def *dst_base, nir_def *wa_insts_ptr, nir_def *indirect_base, nir_def *draw_id_base, nir_def *indirect_stride, nir_def *_draw_count, nir_def *draw_base, nir_def *instance_multiplier, nir_def *max_draw_count, nir_def *flags, nir_def *mocs, nir_def *_3dprim_size_B, nir_def *ring_count, nir_def *gen_addr, nir_def *end_addr, nir_def *item_idx)
{
   assert(dst_base->bit_size == 64);
   assert(dst_base->num_components == 1);
   assert(wa_insts_ptr->bit_size == 64);
   assert(wa_insts_ptr->num_components == 1);
   assert(indirect_base->bit_size == 64);
   assert(indirect_base->num_components == 1);
   assert(draw_id_base->bit_size == 64);
   assert(draw_id_base->num_components == 1);
   assert(indirect_stride->bit_size == 32);
   assert(indirect_stride->num_components == 1);
   assert(_draw_count->bit_size == 64);
   assert(_draw_count->num_components == 1);
   assert(draw_base->bit_size == 32);
   assert(draw_base->num_components == 1);
   assert(instance_multiplier->bit_size == 32);
   assert(instance_multiplier->num_components == 1);
   assert(max_draw_count->bit_size == 32);
   assert(max_draw_count->num_components == 1);
   assert(flags->bit_size == 32);
   assert(flags->num_components == 1);
   assert(mocs->bit_size == 32);
   assert(mocs->num_components == 1);
   assert(_3dprim_size_B->bit_size == 32);
   assert(_3dprim_size_B->num_components == 1);
   assert(ring_count->bit_size == 32);
   assert(ring_count->num_components == 1);
   assert(gen_addr->bit_size == 64);
   assert(gen_addr->num_components == 1);
   assert(end_addr->bit_size == 64);
   assert(end_addr->num_components == 1);
   assert(item_idx->bit_size == 32);
   assert(item_idx->num_components == 1);

   nir_function *func = nir_shader_get_function_for_name(b->shader, "gfx11_libanv_write_draw");

   if (!func) {
      func = nir_function_create(b->shader, "gfx11_libanv_write_draw");
      func->num_params = 16;
      func->params = rzalloc_array(b->shader, nir_parameter, func->num_params);

      func->params[0].bit_size = 64;
      func->params[0].num_components = 1;
      func->params[0].name = "dst_base";

      func->params[1].bit_size = 64;
      func->params[1].num_components = 1;
      func->params[1].name = "wa_insts_ptr";

      func->params[2].bit_size = 64;
      func->params[2].num_components = 1;
      func->params[2].name = "indirect_base";

      func->params[3].bit_size = 64;
      func->params[3].num_components = 1;
      func->params[3].name = "draw_id_base";

      func->params[4].bit_size = 32;
      func->params[4].num_components = 1;
      func->params[4].name = "indirect_stride";

      func->params[5].bit_size = 64;
      func->params[5].num_components = 1;
      func->params[5].name = "_draw_count";

      func->params[6].bit_size = 32;
      func->params[6].num_components = 1;
      func->params[6].name = "draw_base";

      func->params[7].bit_size = 32;
      func->params[7].num_components = 1;
      func->params[7].name = "instance_multiplier";

      func->params[8].bit_size = 32;
      func->params[8].num_components = 1;
      func->params[8].name = "max_draw_count";

      func->params[9].bit_size = 32;
      func->params[9].num_components = 1;
      func->params[9].name = "flags";

      func->params[10].bit_size = 32;
      func->params[10].num_components = 1;
      func->params[10].name = "mocs";

      func->params[11].bit_size = 32;
      func->params[11].num_components = 1;
      func->params[11].name = "_3dprim_size_B";

      func->params[12].bit_size = 32;
      func->params[12].num_components = 1;
      func->params[12].name = "ring_count";

      func->params[13].bit_size = 64;
      func->params[13].num_components = 1;
      func->params[13].name = "gen_addr";

      func->params[14].bit_size = 64;
      func->params[14].num_components = 1;
      func->params[14].name = "end_addr";

      func->params[15].bit_size = 32;
      func->params[15].num_components = 1;
      func->params[15].name = "item_idx";
   }

   nir_call(b, func, dst_base, wa_insts_ptr, indirect_base, draw_id_base, indirect_stride, _draw_count, draw_base, instance_multiplier, max_draw_count, flags, mocs, _3dprim_size_B, ring_count, gen_addr, end_addr, item_idx);
}

static inline void
gfx11_libiris_write_draw(nir_builder *b, nir_def *dst_base, nir_def *indirect_base, nir_def *draw_id_base, nir_def *indirect_stride, nir_def *indirect_draw_count, nir_def *draw_base, nir_def *max_draw_count, nir_def *flags, nir_def *ring_count, nir_def *gen_addr, nir_def *end_addr, nir_def *item_idx)
{
   assert(dst_base->bit_size == 64);
   assert(dst_base->num_components == 1);
   assert(indirect_base->bit_size == 64);
   assert(indirect_base->num_components == 1);
   assert(draw_id_base->bit_size == 64);
   assert(draw_id_base->num_components == 1);
   assert(indirect_stride->bit_size == 32);
   assert(indirect_stride->num_components == 1);
   assert(indirect_draw_count->bit_size == 64);
   assert(indirect_draw_count->num_components == 1);
   assert(draw_base->bit_size == 32);
   assert(draw_base->num_components == 1);
   assert(max_draw_count->bit_size == 32);
   assert(max_draw_count->num_components == 1);
   assert(flags->bit_size == 32);
   assert(flags->num_components == 1);
   assert(ring_count->bit_size == 32);
   assert(ring_count->num_components == 1);
   assert(gen_addr->bit_size == 64);
   assert(gen_addr->num_components == 1);
   assert(end_addr->bit_size == 64);
   assert(end_addr->num_components == 1);
   assert(item_idx->bit_size == 32);
   assert(item_idx->num_components == 1);

   nir_function *func = nir_shader_get_function_for_name(b->shader, "gfx11_libiris_write_draw");

   if (!func) {
      func = nir_function_create(b->shader, "gfx11_libiris_write_draw");
      func->num_params = 12;
      func->params = rzalloc_array(b->shader, nir_parameter, func->num_params);

      func->params[0].bit_size = 64;
      func->params[0].num_components = 1;
      func->params[0].name = "dst_base";

      func->params[1].bit_size = 64;
      func->params[1].num_components = 1;
      func->params[1].name = "indirect_base";

      func->params[2].bit_size = 64;
      func->params[2].num_components = 1;
      func->params[2].name = "draw_id_base";

      func->params[3].bit_size = 32;
      func->params[3].num_components = 1;
      func->params[3].name = "indirect_stride";

      func->params[4].bit_size = 64;
      func->params[4].num_components = 1;
      func->params[4].name = "indirect_draw_count";

      func->params[5].bit_size = 32;
      func->params[5].num_components = 1;
      func->params[5].name = "draw_base";

      func->params[6].bit_size = 32;
      func->params[6].num_components = 1;
      func->params[6].name = "max_draw_count";

      func->params[7].bit_size = 32;
      func->params[7].num_components = 1;
      func->params[7].name = "flags";

      func->params[8].bit_size = 32;
      func->params[8].num_components = 1;
      func->params[8].name = "ring_count";

      func->params[9].bit_size = 64;
      func->params[9].num_components = 1;
      func->params[9].name = "gen_addr";

      func->params[10].bit_size = 64;
      func->params[10].num_components = 1;
      func->params[10].name = "end_addr";

      func->params[11].bit_size = 32;
      func->params[11].num_components = 1;
      func->params[11].name = "item_idx";
   }

   nir_call(b, func, dst_base, indirect_base, draw_id_base, indirect_stride, indirect_draw_count, draw_base, max_draw_count, flags, ring_count, gen_addr, end_addr, item_idx);
}

static inline void
gfx11_libanv_query_copy(nir_builder *b, nir_def *destination_base, nir_def *destination_stride, nir_def *query_data, nir_def *first_query, nir_def *num_queries, nir_def *query_data_offset, nir_def *query_stride, nir_def *num_query_items, nir_def *copy_flags, nir_def *copy_item_idx)
{
   assert(destination_base->bit_size == 64);
   assert(destination_base->num_components == 1);
   assert(destination_stride->bit_size == 32);
   assert(destination_stride->num_components == 1);
   assert(query_data->bit_size == 64);
   assert(query_data->num_components == 1);
   assert(first_query->bit_size == 32);
   assert(first_query->num_components == 1);
   assert(num_queries->bit_size == 32);
   assert(num_queries->num_components == 1);
   assert(query_data_offset->bit_size == 32);
   assert(query_data_offset->num_components == 1);
   assert(query_stride->bit_size == 32);
   assert(query_stride->num_components == 1);
   assert(num_query_items->bit_size == 32);
   assert(num_query_items->num_components == 1);
   assert(copy_flags->bit_size == 32);
   assert(copy_flags->num_components == 1);
   assert(copy_item_idx->bit_size == 32);
   assert(copy_item_idx->num_components == 1);

   nir_function *func = nir_shader_get_function_for_name(b->shader, "gfx11_libanv_query_copy");

   if (!func) {
      func = nir_function_create(b->shader, "gfx11_libanv_query_copy");
      func->num_params = 10;
      func->params = rzalloc_array(b->shader, nir_parameter, func->num_params);

      func->params[0].bit_size = 64;
      func->params[0].num_components = 1;
      func->params[0].name = "destination_base";

      func->params[1].bit_size = 32;
      func->params[1].num_components = 1;
      func->params[1].name = "destination_stride";

      func->params[2].bit_size = 64;
      func->params[2].num_components = 1;
      func->params[2].name = "query_data";

      func->params[3].bit_size = 32;
      func->params[3].num_components = 1;
      func->params[3].name = "first_query";

      func->params[4].bit_size = 32;
      func->params[4].num_components = 1;
      func->params[4].name = "num_queries";

      func->params[5].bit_size = 32;
      func->params[5].num_components = 1;
      func->params[5].name = "query_data_offset";

      func->params[6].bit_size = 32;
      func->params[6].num_components = 1;
      func->params[6].name = "query_stride";

      func->params[7].bit_size = 32;
      func->params[7].num_components = 1;
      func->params[7].name = "num_query_items";

      func->params[8].bit_size = 32;
      func->params[8].num_components = 1;
      func->params[8].name = "copy_flags";

      func->params[9].bit_size = 32;
      func->params[9].num_components = 1;
      func->params[9].name = "copy_item_idx";
   }

   nir_call(b, func, destination_base, destination_stride, query_data, first_query, num_queries, query_data_offset, query_stride, num_query_items, copy_flags, copy_item_idx);
}

static inline void
gfx11_libanv_memcpy(nir_builder *b, nir_def *dst_base, nir_def *src_base, nir_def *num_dwords, nir_def *dword_offset)
{
   assert(dst_base->bit_size == 64);
   assert(dst_base->num_components == 1);
   assert(src_base->bit_size == 64);
   assert(src_base->num_components == 1);
   assert(num_dwords->bit_size == 32);
   assert(num_dwords->num_components == 1);
   assert(dword_offset->bit_size == 32);
   assert(dword_offset->num_components == 1);

   nir_function *func = nir_shader_get_function_for_name(b->shader, "gfx11_libanv_memcpy");

   if (!func) {
      func = nir_function_create(b->shader, "gfx11_libanv_memcpy");
      func->num_params = 4;
      func->params = rzalloc_array(b->shader, nir_parameter, func->num_params);

      func->params[0].bit_size = 64;
      func->params[0].num_components = 1;
      func->params[0].name = "dst_base";

      func->params[1].bit_size = 64;
      func->params[1].num_components = 1;
      func->params[1].name = "src_base";

      func->params[2].bit_size = 32;
      func->params[2].num_components = 1;
      func->params[2].name = "num_dwords";

      func->params[3].bit_size = 32;
      func->params[3].num_components = 1;
      func->params[3].name = "dword_offset";
   }

   nir_call(b, func, dst_base, src_base, num_dwords, dword_offset);
}

static inline void
gfx11_copy_data(nir_builder *b, nir_def *dst_ptr, nir_def *src_ptr, nir_def *size)
{
   assert(dst_ptr->bit_size == 64);
   assert(dst_ptr->num_components == 1);
   assert(src_ptr->bit_size == 64);
   assert(src_ptr->num_components == 1);
   assert(size->bit_size == 32);
   assert(size->num_components == 1);

   nir_function *func = nir_shader_get_function_for_name(b->shader, "gfx11_copy_data");

   if (!func) {
      func = nir_function_create(b->shader, "gfx11_copy_data");
      func->num_params = 3;
      func->params = rzalloc_array(b->shader, nir_parameter, func->num_params);

      func->params[0].bit_size = 64;
      func->params[0].num_components = 1;
      func->params[0].name = "dst_ptr";

      func->params[1].bit_size = 64;
      func->params[1].num_components = 1;
      func->params[1].name = "src_ptr";

      func->params[2].bit_size = 32;
      func->params[2].num_components = 1;
      func->params[2].name = "size";
   }

   nir_call(b, func, dst_ptr, src_ptr, size);
}

