/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.border;

import java.util.HashMap;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BorderStyle;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.keys.border.BorderWidth;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;

public class BorderWidthResolveHandler
extends ConstantsResolveHandler {
    private HashMap keyMapping = new HashMap();

    public BorderWidthResolveHandler() {
        this.keyMapping.put(BorderStyleKeys.BORDER_TOP_WIDTH, BorderStyleKeys.BORDER_TOP_STYLE);
        this.keyMapping.put(BorderStyleKeys.BORDER_LEFT_WIDTH, BorderStyleKeys.BORDER_LEFT_STYLE);
        this.keyMapping.put(BorderStyleKeys.BORDER_BOTTOM_WIDTH, BorderStyleKeys.BORDER_BOTTOM_STYLE);
        this.keyMapping.put(BorderStyleKeys.BORDER_RIGHT_WIDTH, BorderStyleKeys.BORDER_RIGHT_STYLE);
        this.keyMapping.put(BorderStyleKeys.BORDER_BREAK_WIDTH, BorderStyleKeys.BORDER_BREAK_STYLE);
        this.addValue(BorderWidth.THIN, CSSNumericValue.createValue(CSSNumericType.PT, 1.0));
        this.addValue(BorderWidth.MEDIUM, CSSNumericValue.createValue(CSSNumericType.PT, 3.0));
        this.addValue(BorderWidth.THICK, CSSNumericValue.createValue(CSSNumericType.PT, 5.0));
        this.setFallback(CSSNumericValue.ZERO_LENGTH);
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{BorderStyleKeys.BORDER_TOP_STYLE, BorderStyleKeys.BORDER_LEFT_STYLE, BorderStyleKeys.BORDER_BOTTOM_STYLE, BorderStyleKeys.BORDER_RIGHT_STYLE, BorderStyleKeys.BORDER_BREAK_STYLE};
    }

    @Override
    protected CSSValue resolveValue(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        StyleKey styleKey2 = (StyleKey)this.keyMapping.get(styleKey);
        if (styleKey2 == null) {
            throw new IllegalArgumentException("This is not a valid key: " + styleKey);
        }
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(styleKey2);
        if (BorderStyle.NONE.equals(cSSValue)) {
            return CSSNumericValue.ZERO_LENGTH;
        }
        CSSValue cSSValue2 = layoutContext.getValue(styleKey);
        if (cSSValue2 instanceof CSSConstant) {
            return super.resolveValue(layoutProcess, layoutElement, styleKey);
        }
        return cSSValue2;
    }
}

