/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.operators.AbstractNumericOperator;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class SubtractOperator
extends AbstractNumericOperator {
    private static final long serialVersionUID = -3455847702508382227L;

    @Override
    protected Number evaluate(Number number1, Number number2) throws EvaluationException {
        if ((number1 instanceof Integer || number1 instanceof Short) && (number2 instanceof Integer || number2 instanceof Short)) {
            return new BigDecimal(number1.longValue() - number2.longValue());
        }
        BigDecimal bd1 = NumberUtil.getAsBigDecimal(number1);
        BigDecimal bd2 = NumberUtil.getAsBigDecimal(number2);
        return bd1.subtract(bd2);
    }

    @Override
    public int getLevel() {
        return 200;
    }

    public String toString() {
        return "-";
    }

    @Override
    public boolean isLeftOperation() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return false;
    }
}

