/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import net.sourceforge.htmlunit.cyberneko.HTMLConfiguration;
import net.sourceforge.htmlunit.cyberneko.filters.DefaultFilter;
import nokogiri.Html4Document;
import nokogiri.XmlDocument;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriDomParser;
import nokogiri.internals.NokogiriErrorHandler;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.XmlDomParserContext;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlDomParserContext
extends XmlDomParserContext {
    private static final long serialVersionUID = 1L;

    public HtmlDomParserContext(Ruby ruby, IRubyObject iRubyObject) {
        this(ruby, ruby.getNil(), iRubyObject);
    }

    public HtmlDomParserContext(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        super(ruby, iRubyObject, iRubyObject2);
        this.java_encoding = NokogiriHelpers.getValidEncoding(iRubyObject);
    }

    @Override
    protected void initParser(Ruby ruby) {
        HTMLConfiguration hTMLConfiguration = new HTMLConfiguration();
        ElementValidityCheckFilter elementValidityCheckFilter = new ElementValidityCheckFilter(this.errorHandler);
        XMLDocumentFilter[] xMLDocumentFilterArray = new XMLDocumentFilter[]{elementValidityCheckFilter};
        hTMLConfiguration.setErrorHandler((XMLErrorHandler)this.errorHandler);
        this.parser = new NokogiriDomParser((XMLParserConfiguration)hTMLConfiguration);
        this.setProperty("http://cyberneko.org/html/properties/default-encoding", this.java_encoding);
        this.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
        this.setProperty("http://cyberneko.org/html/properties/names/attrs", "lower");
        this.setProperty("http://cyberneko.org/html/properties/filters", xMLDocumentFilterArray);
        this.setFeature("http://cyberneko.org/html/features/report-errors", true);
        this.setFeature("http://xml.org/sax/features/namespaces", false);
    }

    @Override
    public void setEncoding(String string) {
        super.setEncoding(string);
    }

    public void enableDocumentFragment() {
        this.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
    }

    @Override
    public XmlDocument parse(ThreadContext threadContext, RubyClass rubyClass, IRubyObject iRubyObject) {
        XmlDocument xmlDocument = super.parse(threadContext, rubyClass, iRubyObject);
        if (!this.options.recover && this.errorHandler.getErrors().size() > 0) {
            XmlSyntaxError xmlSyntaxError = XmlSyntaxError.createXMLSyntaxError(threadContext.runtime);
            String string = String.format("%s: '%s'", "Parser without recover option encountered error or warning", this.errorHandler.getErrors().get(0));
            xmlSyntaxError.setException(new Exception(string));
            throw xmlSyntaxError.toThrowable();
        }
        return xmlDocument;
    }

    @Override
    protected XmlDocument wrapDocument(ThreadContext threadContext, RubyClass rubyClass, Document document) {
        Html4Document html4Document = new Html4Document(threadContext.runtime, rubyClass, document);
        html4Document.setDocumentNode(threadContext.runtime, document);
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)html4Document, (String)"initialize");
        if (this.ruby_encoding.isNil()) {
            if (this.detected_encoding != null && !this.detected_encoding.isNil()) {
                this.ruby_encoding = this.detected_encoding;
            } else {
                String string = HtmlDomParserContext.tryGetCharsetFromHtml5MetaTag(document);
                this.ruby_encoding = NokogiriHelpers.stringOrNil(threadContext.runtime, string);
            }
        }
        html4Document.setEncoding(this.ruby_encoding);
        html4Document.setParsedEncoding(this.java_encoding);
        return html4Document;
    }

    private static String tryGetCharsetFromHtml5MetaTag(Document document) {
        if (!"html".equalsIgnoreCase(document.getDocumentElement().getNodeName())) {
            return null;
        }
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"head".equalsIgnoreCase(node.getNodeName())) continue;
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                node = nodeList2.item(j);
                if (!"meta".equalsIgnoreCase(node.getNodeName())) continue;
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int k = 0; k < namedNodeMap.getLength(); ++k) {
                    node = namedNodeMap.item(k);
                    if (!"charset".equalsIgnoreCase(node.getNodeName())) continue;
                    return node.getNodeValue();
                }
            }
        }
        return null;
    }

    public static class ElementValidityCheckFilter
    extends DefaultFilter {
        private NokogiriErrorHandler errorHandler;
        private static String[][] element_names = new String[][]{{"a", "abbr", "acronym", "address", "area"}, {"b", "base", "basefont", "bdo", "big", "blockquote", "body", "br", "button"}, {"caption", "cite", "code", "col", "colgroup"}, {"dd", "del", "dfn", "div", "dl", "dt"}, {"em"}, {"fieldset", "font", "form", "frame", "frameset"}, new String[0], {"h1", "h2", "h3", "h4", "h5", "h6", "head", "hr", "html"}, {"i", "iframe", "img", "input", "ins"}, new String[0], {"kbd"}, {"label", "legend", "li", "link"}, {"map", "meta"}, {"noframes", "noscript"}, {"object", "ol", "optgroup", "option"}, {"p", "param", "pre"}, {"q"}, new String[0], {"s", "samp", "script", "select", "small", "span", "strike", "strong", "style", "sub", "sup"}, {"table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "tt"}, {"u", "ul"}, {"var"}, new String[0], new String[0], new String[0], new String[0]};

        private ElementValidityCheckFilter(NokogiriErrorHandler nokogiriErrorHandler) {
            this.errorHandler = nokogiriErrorHandler;
        }

        private static boolean isValid(String string) {
            int n = string.charAt(0) - 97;
            if (n >= element_names.length) {
                return false;
            }
            String[] stringArray = element_names[n];
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return true;
            }
            return false;
        }

        public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
            if (!ElementValidityCheckFilter.isValid(qName.rawname)) {
                this.errorHandler.addError(new Exception("Tag " + qName.rawname + " invalid"));
            }
            super.startElement(qName, xMLAttributes, augmentations);
        }
    }
}

