/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class CurrentOfNode
extends FromTable {
    private String cursorName;
    private ExecPreparedStatement preStmt;
    private TableName exposedTableName;
    private TableName baseTableName;
    private CostEstimate singleScanCostEstimate;
    private FromBaseTable dummyTargetTable;

    CurrentOfNode(String correlationName, String cursor, Properties tableProperties, ContextManager cm) {
        super(correlationName, tableProperties, cm);
        this.cursorName = cursor;
    }

    static CurrentOfNode makeForMerge(String cursorName, FromBaseTable dummyTargetTable, ContextManager cm) {
        CurrentOfNode node = new CurrentOfNode(null, cursorName, null, cm);
        node.dummyTargetTable = dummyTargetTable;
        return node;
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        if (this.singleScanCostEstimate == null) {
            this.singleScanCostEstimate = this.getOptimizerFactory().getCostEstimate();
        }
        this.singleScanCostEstimate.setCost(0.0, 1.0, 1.0);
        this.getBestAccessPath().setCostEstimate(this.singleScanCostEstimate);
        this.getBestSortAvoidancePath().setCostEstimate(this.singleScanCostEstimate);
        return this.singleScanCostEstimate;
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        this.preStmt = this.getCursorStatement();
        if (this.preStmt == null) {
            throw StandardException.newException((String)"42X30", (Object[])new Object[]{this.cursorName});
        }
        this.preStmt.rePrepare(this.getLanguageConnectionContext());
        if (this.preStmt.getUpdateMode() != 2) {
            String printableString = this.cursorName == null ? "" : this.cursorName;
            throw StandardException.newException((String)"42X23", (Object[])new Object[]{printableString});
        }
        ExecCursorTableReference refTab = this.preStmt.getTargetTable();
        String schemaName = refTab.getSchemaName();
        this.exposedTableName = this.makeTableName(null, refTab.getExposedName());
        this.baseTableName = this.makeTableName(schemaName, refTab.getBaseName());
        SchemaDescriptor tableSchema = this.getSchemaDescriptor(refTab.getSchemaName());
        if (tableSchema == null) {
            throw StandardException.newException((String)"42Y07", (Object[])new Object[]{refTab.getSchemaName()});
        }
        TableDescriptor td = this.getTableDescriptor(refTab.getBaseName(), tableSchema);
        if (td == null) {
            throw StandardException.newException((String)"42X05", (Object[])new Object[]{refTab.getBaseName()});
        }
        this.setResultColumns(new ResultColumnList(this.getContextManager()));
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor colDesc = cdl.elementAt(index);
            BaseColumnNode bcn = new BaseColumnNode(colDesc.getColumnName(), this.exposedTableName, colDesc.getType(), this.getContextManager());
            ResultColumn rc = new ResultColumn(colDesc, (ValueNode)bcn, this.getContextManager());
            this.getResultColumns().addResultColumn(rc);
        }
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    @Override
    void bindExpressions(FromList fromListParam) {
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        if (this.dummyTargetTable != null) {
            return this.dummyTargetTable.getMatchingColumn(columnReference);
        }
        ResultColumn resultColumn = null;
        TableName columnsTableName = columnReference.getQualifiedTableName();
        if (columnsTableName != null && columnsTableName.getSchemaName() == null && this.correlationName == null) {
            columnsTableName.bind();
        }
        SanityManager.ASSERT((this.preStmt != null ? 1 : 0) != 0, (String)"must have prepared statement");
        SanityManager.ASSERT((this.baseTableName != null ? 1 : 0) != 0, (String)"no name on target table");
        if (this.baseTableName != null && this.baseTableName.getSchemaName() == null && this.correlationName == null) {
            this.baseTableName.bind();
        }
        if (columnsTableName == null || columnsTableName.getFullTableName().equals(this.baseTableName.getFullTableName()) || this.correlationName != null && this.correlationName.equals(columnsTableName.getTableName())) {
            boolean notfound;
            resultColumn = this.getResultColumns().getResultColumn(columnReference.getColumnName());
            if (resultColumn != null) {
                columnReference.setTableNumber(this.tableNumber);
                columnReference.setColumnNumber(resultColumn.getColumnPosition());
                notfound = resultColumn.updatableByCursor() && !this.preStmt.isUpdateColumn(columnReference.getColumnName());
            } else {
                notfound = true;
            }
            if (notfound) {
                String printableString = this.cursorName == null ? "" : this.cursorName;
                throw StandardException.newException((String)"42X31", (Object[])new Object[]{columnReference.getColumnName(), printableString});
            }
        }
        return resultColumn;
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.setReferencedTableMap(new JBitSet(numTables));
        return this;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double outerRows) throws StandardException {
        this.bestCostEstimate = this.getOptimizerFactory().getCostEstimate();
        this.bestCostEstimate.setCost(0.0, outerRows, outerRows);
        return this;
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((!this.isStatementResultSet() ? 1 : 0) != 0, (String)"CurrentOfNode not expected to be statement node");
        this.assignResultSetNumber();
        mb.pushThis();
        acb.pushGetResultSetFactoryExpression(mb);
        mb.push(this.cursorName);
        acb.pushThisAsActivation(mb);
        mb.push(this.getResultSetNumber());
        mb.callMethod((short)185, null, "getCurrentOfResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 3);
        mb.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
        mb.putField(null, acb.getRowLocationScanResultSetName(), "org.apache.derby.iapi.sql.execute.CursorResultSet");
        mb.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        MethodBuilder rmb = acb.startResetMethod();
        rmb.pushThis();
        rmb.push(this.cursorName);
        rmb.push(this.preStmt.getObjectName());
        rmb.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "checkPositionedStatement", "void", 2);
        rmb.methodReturn();
        rmb.complete();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "cursor: ");
    }

    @Override
    public String toString() {
        return "preparedStatement: " + (String)(this.preStmt == null ? "no prepared statement yet\n" : this.preStmt.toString() + "\n") + this.cursorName + "\n" + super.toString();
    }

    @Override
    String getExposedName() {
        if (this.dummyTargetTable != null) {
            return this.dummyTargetTable.getExposedName();
        }
        return this.exposedTableName.getFullTableName();
    }

    @Override
    public int updateTargetLockMode() {
        return 6;
    }

    TableName getExposedTableName() {
        return this.exposedTableName;
    }

    TableName getBaseCursorTargetTableName() {
        return this.baseTableName;
    }

    String getCursorName() {
        return this.cursorName;
    }

    ExecPreparedStatement getCursorStatement() {
        CursorActivation activation = this.getLanguageConnectionContext().lookupCursorActivation(this.cursorName);
        if (activation == null) {
            return null;
        }
        return activation.getPreparedStatement();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.exposedTableName != null) {
            this.exposedTableName = (TableName)this.exposedTableName.accept(v);
        }
        if (this.baseTableName != null) {
            this.baseTableName = (TableName)this.baseTableName.accept(v);
        }
    }
}

