<?php
/**
 * ScraperTargetsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * ScraperTargetsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ScraperTargetsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation deleteScrapersID
     *
     * Delete a scraper target
     *
     * @param  string $scraper_target_id The identifier of the scraper target. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteScrapersID($scraper_target_id, $zap_trace_span = null)
    {
        $this->deleteScrapersIDWithHttpInfo($scraper_target_id, $zap_trace_span);
    }

    /**
     * Operation deleteScrapersIDWithHttpInfo
     *
     * Delete a scraper target
     *
     * @param  string $scraper_target_id The identifier of the scraper target. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteScrapersIDWithHttpInfo($scraper_target_id, $zap_trace_span = null)
    {
        $request = $this->deleteScrapersIDRequest($scraper_target_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteScrapersID'
     *
     * @param  string $scraper_target_id The identifier of the scraper target. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteScrapersIDRequest($scraper_target_id, $zap_trace_span = null)
    {
        // verify the required parameter 'scraper_target_id' is set
        if ($scraper_target_id === null || (is_array($scraper_target_id) && count($scraper_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_id when calling deleteScrapersID'
            );
        }

        $resourcePath = '/api/v2/scrapers/{scraperTargetID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($scraper_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scraperTargetID' . '}',
                ObjectSerializer::toPathValue($scraper_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteScrapersIDLabelsID
     *
     * Delete a label from a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $label_id The label ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteScrapersIDLabelsID($scraper_target_id, $label_id, $zap_trace_span = null)
    {
        $this->deleteScrapersIDLabelsIDWithHttpInfo($scraper_target_id, $label_id, $zap_trace_span);
    }

    /**
     * Operation deleteScrapersIDLabelsIDWithHttpInfo
     *
     * Delete a label from a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $label_id The label ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteScrapersIDLabelsIDWithHttpInfo($scraper_target_id, $label_id, $zap_trace_span = null)
    {
        $request = $this->deleteScrapersIDLabelsIDRequest($scraper_target_id, $label_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteScrapersIDLabelsID'
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $label_id The label ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteScrapersIDLabelsIDRequest($scraper_target_id, $label_id, $zap_trace_span = null)
    {
        // verify the required parameter 'scraper_target_id' is set
        if ($scraper_target_id === null || (is_array($scraper_target_id) && count($scraper_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_id when calling deleteScrapersIDLabelsID'
            );
        }
        // verify the required parameter 'label_id' is set
        if ($label_id === null || (is_array($label_id) && count($label_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_id when calling deleteScrapersIDLabelsID'
            );
        }

        $resourcePath = '/api/v2/scrapers/{scraperTargetID}/labels/{labelID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($scraper_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scraperTargetID' . '}',
                ObjectSerializer::toPathValue($scraper_target_id),
                $resourcePath
            );
        }
        // path params
        if ($label_id !== null) {
            $resourcePath = str_replace(
                '{' . 'labelID' . '}',
                ObjectSerializer::toPathValue($label_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteScrapersIDMembersID
     *
     * Remove a member from a scraper target
     *
     * @param  string $user_id The ID of member to remove. (required)
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteScrapersIDMembersID($user_id, $scraper_target_id, $zap_trace_span = null)
    {
        $this->deleteScrapersIDMembersIDWithHttpInfo($user_id, $scraper_target_id, $zap_trace_span);
    }

    /**
     * Operation deleteScrapersIDMembersIDWithHttpInfo
     *
     * Remove a member from a scraper target
     *
     * @param  string $user_id The ID of member to remove. (required)
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteScrapersIDMembersIDWithHttpInfo($user_id, $scraper_target_id, $zap_trace_span = null)
    {
        $request = $this->deleteScrapersIDMembersIDRequest($user_id, $scraper_target_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteScrapersIDMembersID'
     *
     * @param  string $user_id The ID of member to remove. (required)
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteScrapersIDMembersIDRequest($user_id, $scraper_target_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteScrapersIDMembersID'
            );
        }
        // verify the required parameter 'scraper_target_id' is set
        if ($scraper_target_id === null || (is_array($scraper_target_id) && count($scraper_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_id when calling deleteScrapersIDMembersID'
            );
        }

        $resourcePath = '/api/v2/scrapers/{scraperTargetID}/members/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($scraper_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scraperTargetID' . '}',
                ObjectSerializer::toPathValue($scraper_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteScrapersIDOwnersID
     *
     * Remove an owner from a scraper target
     *
     * @param  string $user_id The ID of owner to remove. (required)
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteScrapersIDOwnersID($user_id, $scraper_target_id, $zap_trace_span = null)
    {
        $this->deleteScrapersIDOwnersIDWithHttpInfo($user_id, $scraper_target_id, $zap_trace_span);
    }

    /**
     * Operation deleteScrapersIDOwnersIDWithHttpInfo
     *
     * Remove an owner from a scraper target
     *
     * @param  string $user_id The ID of owner to remove. (required)
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteScrapersIDOwnersIDWithHttpInfo($user_id, $scraper_target_id, $zap_trace_span = null)
    {
        $request = $this->deleteScrapersIDOwnersIDRequest($user_id, $scraper_target_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteScrapersIDOwnersID'
     *
     * @param  string $user_id The ID of owner to remove. (required)
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteScrapersIDOwnersIDRequest($user_id, $scraper_target_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteScrapersIDOwnersID'
            );
        }
        // verify the required parameter 'scraper_target_id' is set
        if ($scraper_target_id === null || (is_array($scraper_target_id) && count($scraper_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_id when calling deleteScrapersIDOwnersID'
            );
        }

        $resourcePath = '/api/v2/scrapers/{scraperTargetID}/owners/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($scraper_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scraperTargetID' . '}',
                ObjectSerializer::toPathValue($scraper_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getScrapers
     *
     * List all scraper targets
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $name Specifies the name of the scraper target. (optional)
     * @param  string[] $id List of scraper target IDs to return. If both &#x60;id&#x60; and &#x60;owner&#x60; are specified, only &#x60;id&#x60; is used. (optional)
     * @param  string $org_id Specifies the organization ID of the scraper target. (optional)
     * @param  string $org Specifies the organization name of the scraper target. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ScraperTargetResponses
     */
    public function getScrapers($zap_trace_span = null, $name = null, $id = null, $org_id = null, $org = null)
    {
        list($response) = $this->getScrapersWithHttpInfo($zap_trace_span, $name, $id, $org_id, $org);
        return $response;
    }

    /**
     * Operation getScrapersWithHttpInfo
     *
     * List all scraper targets
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $name Specifies the name of the scraper target. (optional)
     * @param  string[] $id List of scraper target IDs to return. If both &#x60;id&#x60; and &#x60;owner&#x60; are specified, only &#x60;id&#x60; is used. (optional)
     * @param  string $org_id Specifies the organization ID of the scraper target. (optional)
     * @param  string $org Specifies the organization name of the scraper target. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ScraperTargetResponses, HTTP status code, HTTP response headers (array of strings)
     */
    public function getScrapersWithHttpInfo($zap_trace_span = null, $name = null, $id = null, $org_id = null, $org = null)
    {
        $request = $this->getScrapersRequest($zap_trace_span, $name, $id, $org_id, $org);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ScraperTargetResponses';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getScrapers'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $name Specifies the name of the scraper target. (optional)
     * @param  string[] $id List of scraper target IDs to return. If both &#x60;id&#x60; and &#x60;owner&#x60; are specified, only &#x60;id&#x60; is used. (optional)
     * @param  string $org_id Specifies the organization ID of the scraper target. (optional)
     * @param  string $org Specifies the organization name of the scraper target. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getScrapersRequest($zap_trace_span = null, $name = null, $id = null, $org_id = null, $org = null)
    {

        $resourcePath = '/api/v2/scrapers';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($name !== null) {
            $queryParams['name'] = ObjectSerializer::toQueryValue($name);
        }
        // query params
        if (is_array($id)) {
            $id = ObjectSerializer::serializeCollection($id, 'multi', true);
        }
        if ($id !== null) {
            $queryParams['id'] = ObjectSerializer::toQueryValue($id);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getScrapersID
     *
     * Retrieve a scraper target
     *
     * @param  string $scraper_target_id The identifier of the scraper target. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ScraperTargetResponse|\InfluxDB2\Model\Error
     */
    public function getScrapersID($scraper_target_id, $zap_trace_span = null)
    {
        list($response) = $this->getScrapersIDWithHttpInfo($scraper_target_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getScrapersIDWithHttpInfo
     *
     * Retrieve a scraper target
     *
     * @param  string $scraper_target_id The identifier of the scraper target. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ScraperTargetResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getScrapersIDWithHttpInfo($scraper_target_id, $zap_trace_span = null)
    {
        $request = $this->getScrapersIDRequest($scraper_target_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ScraperTargetResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getScrapersID'
     *
     * @param  string $scraper_target_id The identifier of the scraper target. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getScrapersIDRequest($scraper_target_id, $zap_trace_span = null)
    {
        // verify the required parameter 'scraper_target_id' is set
        if ($scraper_target_id === null || (is_array($scraper_target_id) && count($scraper_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_id when calling getScrapersID'
            );
        }

        $resourcePath = '/api/v2/scrapers/{scraperTargetID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($scraper_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scraperTargetID' . '}',
                ObjectSerializer::toPathValue($scraper_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getScrapersIDLabels
     *
     * List all labels for a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error
     */
    public function getScrapersIDLabels($scraper_target_id, $zap_trace_span = null)
    {
        list($response) = $this->getScrapersIDLabelsWithHttpInfo($scraper_target_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getScrapersIDLabelsWithHttpInfo
     *
     * List all labels for a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getScrapersIDLabelsWithHttpInfo($scraper_target_id, $zap_trace_span = null)
    {
        $request = $this->getScrapersIDLabelsRequest($scraper_target_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelsResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getScrapersIDLabels'
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getScrapersIDLabelsRequest($scraper_target_id, $zap_trace_span = null)
    {
        // verify the required parameter 'scraper_target_id' is set
        if ($scraper_target_id === null || (is_array($scraper_target_id) && count($scraper_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_id when calling getScrapersIDLabels'
            );
        }

        $resourcePath = '/api/v2/scrapers/{scraperTargetID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($scraper_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scraperTargetID' . '}',
                ObjectSerializer::toPathValue($scraper_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getScrapersIDMembers
     *
     * List all users with member privileges for a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error
     */
    public function getScrapersIDMembers($scraper_target_id, $zap_trace_span = null)
    {
        list($response) = $this->getScrapersIDMembersWithHttpInfo($scraper_target_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getScrapersIDMembersWithHttpInfo
     *
     * List all users with member privileges for a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getScrapersIDMembersWithHttpInfo($scraper_target_id, $zap_trace_span = null)
    {
        $request = $this->getScrapersIDMembersRequest($scraper_target_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMembers';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getScrapersIDMembers'
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getScrapersIDMembersRequest($scraper_target_id, $zap_trace_span = null)
    {
        // verify the required parameter 'scraper_target_id' is set
        if ($scraper_target_id === null || (is_array($scraper_target_id) && count($scraper_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_id when calling getScrapersIDMembers'
            );
        }

        $resourcePath = '/api/v2/scrapers/{scraperTargetID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($scraper_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scraperTargetID' . '}',
                ObjectSerializer::toPathValue($scraper_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getScrapersIDOwners
     *
     * List all owners of a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwners|\InfluxDB2\Model\Error
     */
    public function getScrapersIDOwners($scraper_target_id, $zap_trace_span = null)
    {
        list($response) = $this->getScrapersIDOwnersWithHttpInfo($scraper_target_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getScrapersIDOwnersWithHttpInfo
     *
     * List all owners of a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwners|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getScrapersIDOwnersWithHttpInfo($scraper_target_id, $zap_trace_span = null)
    {
        $request = $this->getScrapersIDOwnersRequest($scraper_target_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwners';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getScrapersIDOwners'
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getScrapersIDOwnersRequest($scraper_target_id, $zap_trace_span = null)
    {
        // verify the required parameter 'scraper_target_id' is set
        if ($scraper_target_id === null || (is_array($scraper_target_id) && count($scraper_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_id when calling getScrapersIDOwners'
            );
        }

        $resourcePath = '/api/v2/scrapers/{scraperTargetID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($scraper_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scraperTargetID' . '}',
                ObjectSerializer::toPathValue($scraper_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchScrapersID
     *
     * Update a scraper target
     *
     * @param  string $scraper_target_id The identifier of the scraper target. (required)
     * @param  \InfluxDB2\Model\ScraperTargetRequest $scraper_target_request Scraper target update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ScraperTargetResponse|\InfluxDB2\Model\Error
     */
    public function patchScrapersID($scraper_target_id, $scraper_target_request, $zap_trace_span = null)
    {
        list($response) = $this->patchScrapersIDWithHttpInfo($scraper_target_id, $scraper_target_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchScrapersIDWithHttpInfo
     *
     * Update a scraper target
     *
     * @param  string $scraper_target_id The identifier of the scraper target. (required)
     * @param  \InfluxDB2\Model\ScraperTargetRequest $scraper_target_request Scraper target update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ScraperTargetResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchScrapersIDWithHttpInfo($scraper_target_id, $scraper_target_request, $zap_trace_span = null)
    {
        $request = $this->patchScrapersIDRequest($scraper_target_id, $scraper_target_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ScraperTargetResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchScrapersID'
     *
     * @param  string $scraper_target_id The identifier of the scraper target. (required)
     * @param  \InfluxDB2\Model\ScraperTargetRequest $scraper_target_request Scraper target update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchScrapersIDRequest($scraper_target_id, $scraper_target_request, $zap_trace_span = null)
    {
        // verify the required parameter 'scraper_target_id' is set
        if ($scraper_target_id === null || (is_array($scraper_target_id) && count($scraper_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_id when calling patchScrapersID'
            );
        }
        // verify the required parameter 'scraper_target_request' is set
        if ($scraper_target_request === null || (is_array($scraper_target_request) && count($scraper_target_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_request when calling patchScrapersID'
            );
        }

        $resourcePath = '/api/v2/scrapers/{scraperTargetID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($scraper_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scraperTargetID' . '}',
                ObjectSerializer::toPathValue($scraper_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($scraper_target_request)) {
            $_tempBody = $scraper_target_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postScrapers
     *
     * Create a scraper target
     *
     * @param  \InfluxDB2\Model\ScraperTargetRequest $scraper_target_request Scraper target to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ScraperTargetResponse|\InfluxDB2\Model\Error
     */
    public function postScrapers($scraper_target_request, $zap_trace_span = null)
    {
        list($response) = $this->postScrapersWithHttpInfo($scraper_target_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postScrapersWithHttpInfo
     *
     * Create a scraper target
     *
     * @param  \InfluxDB2\Model\ScraperTargetRequest $scraper_target_request Scraper target to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ScraperTargetResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postScrapersWithHttpInfo($scraper_target_request, $zap_trace_span = null)
    {
        $request = $this->postScrapersRequest($scraper_target_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ScraperTargetResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postScrapers'
     *
     * @param  \InfluxDB2\Model\ScraperTargetRequest $scraper_target_request Scraper target to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postScrapersRequest($scraper_target_request, $zap_trace_span = null)
    {
        // verify the required parameter 'scraper_target_request' is set
        if ($scraper_target_request === null || (is_array($scraper_target_request) && count($scraper_target_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_request when calling postScrapers'
            );
        }

        $resourcePath = '/api/v2/scrapers';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;
        if (isset($scraper_target_request)) {
            $_tempBody = $scraper_target_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postScrapersIDLabels
     *
     * Add a label to a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error
     */
    public function postScrapersIDLabels($scraper_target_id, $label_mapping, $zap_trace_span = null)
    {
        list($response) = $this->postScrapersIDLabelsWithHttpInfo($scraper_target_id, $label_mapping, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postScrapersIDLabelsWithHttpInfo
     *
     * Add a label to a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postScrapersIDLabelsWithHttpInfo($scraper_target_id, $label_mapping, $zap_trace_span = null)
    {
        $request = $this->postScrapersIDLabelsRequest($scraper_target_id, $label_mapping, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postScrapersIDLabels'
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postScrapersIDLabelsRequest($scraper_target_id, $label_mapping, $zap_trace_span = null)
    {
        // verify the required parameter 'scraper_target_id' is set
        if ($scraper_target_id === null || (is_array($scraper_target_id) && count($scraper_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_id when calling postScrapersIDLabels'
            );
        }
        // verify the required parameter 'label_mapping' is set
        if ($label_mapping === null || (is_array($label_mapping) && count($label_mapping) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_mapping when calling postScrapersIDLabels'
            );
        }

        $resourcePath = '/api/v2/scrapers/{scraperTargetID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($scraper_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scraperTargetID' . '}',
                ObjectSerializer::toPathValue($scraper_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($label_mapping)) {
            $_tempBody = $label_mapping;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postScrapersIDMembers
     *
     * Add a member to a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as member (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMember|\InfluxDB2\Model\Error
     */
    public function postScrapersIDMembers($scraper_target_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        list($response) = $this->postScrapersIDMembersWithHttpInfo($scraper_target_id, $add_resource_member_request_body, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postScrapersIDMembersWithHttpInfo
     *
     * Add a member to a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as member (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMember|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postScrapersIDMembersWithHttpInfo($scraper_target_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        $request = $this->postScrapersIDMembersRequest($scraper_target_id, $add_resource_member_request_body, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMember';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postScrapersIDMembers'
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as member (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postScrapersIDMembersRequest($scraper_target_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        // verify the required parameter 'scraper_target_id' is set
        if ($scraper_target_id === null || (is_array($scraper_target_id) && count($scraper_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_id when calling postScrapersIDMembers'
            );
        }
        // verify the required parameter 'add_resource_member_request_body' is set
        if ($add_resource_member_request_body === null || (is_array($add_resource_member_request_body) && count($add_resource_member_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_resource_member_request_body when calling postScrapersIDMembers'
            );
        }

        $resourcePath = '/api/v2/scrapers/{scraperTargetID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($scraper_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scraperTargetID' . '}',
                ObjectSerializer::toPathValue($scraper_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($add_resource_member_request_body)) {
            $_tempBody = $add_resource_member_request_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postScrapersIDOwners
     *
     * Add an owner to a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as owner (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwner|\InfluxDB2\Model\Error
     */
    public function postScrapersIDOwners($scraper_target_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        list($response) = $this->postScrapersIDOwnersWithHttpInfo($scraper_target_id, $add_resource_member_request_body, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postScrapersIDOwnersWithHttpInfo
     *
     * Add an owner to a scraper target
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as owner (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwner|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postScrapersIDOwnersWithHttpInfo($scraper_target_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        $request = $this->postScrapersIDOwnersRequest($scraper_target_id, $add_resource_member_request_body, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwner';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postScrapersIDOwners'
     *
     * @param  string $scraper_target_id The scraper target ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as owner (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postScrapersIDOwnersRequest($scraper_target_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        // verify the required parameter 'scraper_target_id' is set
        if ($scraper_target_id === null || (is_array($scraper_target_id) && count($scraper_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scraper_target_id when calling postScrapersIDOwners'
            );
        }
        // verify the required parameter 'add_resource_member_request_body' is set
        if ($add_resource_member_request_body === null || (is_array($add_resource_member_request_body) && count($add_resource_member_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_resource_member_request_body when calling postScrapersIDOwners'
            );
        }

        $resourcePath = '/api/v2/scrapers/{scraperTargetID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($scraper_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'scraperTargetID' . '}',
                ObjectSerializer::toPathValue($scraper_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($add_resource_member_request_body)) {
            $_tempBody = $add_resource_member_request_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
