<?php
/**
 * WriteService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * WriteService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class WriteService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation postWrite
     *
     * Write data
     *
     * @param  string $org The destination organization for writes. InfluxDB writes all points in the batch to this organization. If you pass both &#x60;orgID&#x60; and &#x60;org&#x60;, they must both be valid.  #### InfluxDB Cloud  - Doesn&#39;t require &#x60;org&#x60; or &#x60;orgID&#x60;. - Writes to the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. - InfluxDB writes all points in the batch to this organization. (required)
     * @param  string $bucket The destination bucket for writes. InfluxDB writes all points in the batch to this bucket. (required)
     * @param  string $body Data in line protocol format.  To send compressed data, do the following:    1. Use [GZIP](https://www.gzip.org/) to compress the line protocol data.   2. In your request, send the compressed data and the      &#x60;Content-Encoding: gzip&#x60; header.  #### Related guides  - [Best practices for optimizing writes](https://docs.influxdata.com/influxdb/v2.3/write-data/best-practices/optimize-writes/). (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_encoding The compression applied to the line protocol in the request payload. To send a GZIP payload, pass &#x60;Content-Encoding: gzip&#x60; header. (optional, default to 'identity')
     * @param  string $content_type The format of the data in the request body. To send a line protocol payload, pass &#x60;Content-Type: text/plain; charset&#x3D;utf-8&#x60;. (optional, default to 'text/plain; charset=utf-8')
     * @param  int $content_length The size of the entity-body, in bytes, sent to InfluxDB. If the length is greater than the &#x60;max body&#x60; configuration option, the server responds with status code &#x60;413&#x60;. (optional)
     * @param  string $accept The content type that the client can understand. Writes only return a response body if they fail--for example, due to a formatting problem or quota limit.  #### InfluxDB Cloud    - Returns only &#x60;application/json&#x60; for format and limit errors.   - Returns only &#x60;text/html&#x60; for some quota limit errors.  #### InfluxDB OSS    - Returns only &#x60;application/json&#x60; for format and limit errors.  #### Related guides   - [Troubleshoot issues writing data](https://docs.influxdata.com/influxdb/v2.3/write-data/troubleshoot/). (optional, default to 'application/json')
     * @param  string $org_id The ID of the destination organization for writes. If you pass both &#x60;orgID&#x60; and &#x60;org&#x60;, they must both be valid.  #### InfluxDB Cloud  - Doesn&#39;t require &#x60;org&#x60; or &#x60;orgID&#x60;. - Writes to the bucket in the organization associated with the authorization (API token).   #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. - InfluxDB writes all points in the batch to this organization. (optional)
     * @param  \InfluxDB2\Model\WritePrecision $precision The precision for unix timestamps in the line protocol batch. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postWrite($org, $bucket, $body, $zap_trace_span = null, $content_encoding = 'identity', $content_type = 'text/plain; charset=utf-8', $content_length = null, $accept = 'application/json', $org_id = null, $precision = null)
    {
        $this->postWriteWithHttpInfo($org, $bucket, $body, $zap_trace_span, $content_encoding, $content_type, $content_length, $accept, $org_id, $precision);
    }

    /**
     * Operation postWriteWithHttpInfo
     *
     * Write data
     *
     * @param  string $org The destination organization for writes. InfluxDB writes all points in the batch to this organization. If you pass both &#x60;orgID&#x60; and &#x60;org&#x60;, they must both be valid.  #### InfluxDB Cloud  - Doesn&#39;t require &#x60;org&#x60; or &#x60;orgID&#x60;. - Writes to the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. - InfluxDB writes all points in the batch to this organization. (required)
     * @param  string $bucket The destination bucket for writes. InfluxDB writes all points in the batch to this bucket. (required)
     * @param  string $body Data in line protocol format.  To send compressed data, do the following:    1. Use [GZIP](https://www.gzip.org/) to compress the line protocol data.   2. In your request, send the compressed data and the      &#x60;Content-Encoding: gzip&#x60; header.  #### Related guides  - [Best practices for optimizing writes](https://docs.influxdata.com/influxdb/v2.3/write-data/best-practices/optimize-writes/). (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_encoding The compression applied to the line protocol in the request payload. To send a GZIP payload, pass &#x60;Content-Encoding: gzip&#x60; header. (optional, default to 'identity')
     * @param  string $content_type The format of the data in the request body. To send a line protocol payload, pass &#x60;Content-Type: text/plain; charset&#x3D;utf-8&#x60;. (optional, default to 'text/plain; charset=utf-8')
     * @param  int $content_length The size of the entity-body, in bytes, sent to InfluxDB. If the length is greater than the &#x60;max body&#x60; configuration option, the server responds with status code &#x60;413&#x60;. (optional)
     * @param  string $accept The content type that the client can understand. Writes only return a response body if they fail--for example, due to a formatting problem or quota limit.  #### InfluxDB Cloud    - Returns only &#x60;application/json&#x60; for format and limit errors.   - Returns only &#x60;text/html&#x60; for some quota limit errors.  #### InfluxDB OSS    - Returns only &#x60;application/json&#x60; for format and limit errors.  #### Related guides   - [Troubleshoot issues writing data](https://docs.influxdata.com/influxdb/v2.3/write-data/troubleshoot/). (optional, default to 'application/json')
     * @param  string $org_id The ID of the destination organization for writes. If you pass both &#x60;orgID&#x60; and &#x60;org&#x60;, they must both be valid.  #### InfluxDB Cloud  - Doesn&#39;t require &#x60;org&#x60; or &#x60;orgID&#x60;. - Writes to the bucket in the organization associated with the authorization (API token).   #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. - InfluxDB writes all points in the batch to this organization. (optional)
     * @param  \InfluxDB2\Model\WritePrecision $precision The precision for unix timestamps in the line protocol batch. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postWriteWithHttpInfo($org, $bucket, $body, $zap_trace_span = null, $content_encoding = 'identity', $content_type = 'text/plain; charset=utf-8', $content_length = null, $accept = 'application/json', $org_id = null, $precision = null)
    {
        $request = $this->postWriteRequest($org, $bucket, $body, $zap_trace_span, $content_encoding, $content_type, $content_length, $accept, $org_id, $precision);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'postWrite'
     *
     * @param  string $org The destination organization for writes. InfluxDB writes all points in the batch to this organization. If you pass both &#x60;orgID&#x60; and &#x60;org&#x60;, they must both be valid.  #### InfluxDB Cloud  - Doesn&#39;t require &#x60;org&#x60; or &#x60;orgID&#x60;. - Writes to the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. - InfluxDB writes all points in the batch to this organization. (required)
     * @param  string $bucket The destination bucket for writes. InfluxDB writes all points in the batch to this bucket. (required)
     * @param  string $body Data in line protocol format.  To send compressed data, do the following:    1. Use [GZIP](https://www.gzip.org/) to compress the line protocol data.   2. In your request, send the compressed data and the      &#x60;Content-Encoding: gzip&#x60; header.  #### Related guides  - [Best practices for optimizing writes](https://docs.influxdata.com/influxdb/v2.3/write-data/best-practices/optimize-writes/). (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_encoding The compression applied to the line protocol in the request payload. To send a GZIP payload, pass &#x60;Content-Encoding: gzip&#x60; header. (optional, default to 'identity')
     * @param  string $content_type The format of the data in the request body. To send a line protocol payload, pass &#x60;Content-Type: text/plain; charset&#x3D;utf-8&#x60;. (optional, default to 'text/plain; charset=utf-8')
     * @param  int $content_length The size of the entity-body, in bytes, sent to InfluxDB. If the length is greater than the &#x60;max body&#x60; configuration option, the server responds with status code &#x60;413&#x60;. (optional)
     * @param  string $accept The content type that the client can understand. Writes only return a response body if they fail--for example, due to a formatting problem or quota limit.  #### InfluxDB Cloud    - Returns only &#x60;application/json&#x60; for format and limit errors.   - Returns only &#x60;text/html&#x60; for some quota limit errors.  #### InfluxDB OSS    - Returns only &#x60;application/json&#x60; for format and limit errors.  #### Related guides   - [Troubleshoot issues writing data](https://docs.influxdata.com/influxdb/v2.3/write-data/troubleshoot/). (optional, default to 'application/json')
     * @param  string $org_id The ID of the destination organization for writes. If you pass both &#x60;orgID&#x60; and &#x60;org&#x60;, they must both be valid.  #### InfluxDB Cloud  - Doesn&#39;t require &#x60;org&#x60; or &#x60;orgID&#x60;. - Writes to the bucket in the organization associated with the authorization (API token).   #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. - InfluxDB writes all points in the batch to this organization. (optional)
     * @param  \InfluxDB2\Model\WritePrecision $precision The precision for unix timestamps in the line protocol batch. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postWriteRequest($org, $bucket, $body, $zap_trace_span = null, $content_encoding = 'identity', $content_type = 'text/plain; charset=utf-8', $content_length = null, $accept = 'application/json', $org_id = null, $precision = null)
    {
        // verify the required parameter 'org' is set
        if ($org === null || (is_array($org) && count($org) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org when calling postWrite'
            );
        }
        // verify the required parameter 'bucket' is set
        if ($bucket === null || (is_array($bucket) && count($bucket) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket when calling postWrite'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling postWrite'
            );
        }

        $resourcePath = '/api/v2/write';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($bucket !== null) {
            $queryParams['bucket'] = ObjectSerializer::toQueryValue($bucket);
        }
        // query params
        if ($precision !== null) {
            $queryParams['precision'] = ObjectSerializer::toQueryValue($precision);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }
        // header params
        if ($content_encoding !== null) {
            $headerParams['Content-Encoding'] = ObjectSerializer::toHeaderValue($content_encoding);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }
        // header params
        if ($content_length !== null) {
            $headerParams['Content-Length'] = ObjectSerializer::toHeaderValue($content_length);
        }
        // header params
        if ($accept !== null) {
            $headerParams['Accept'] = ObjectSerializer::toHeaderValue($accept);
        }


        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', 'text/html', ]
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', 'text/html', ],
                ['text/plain']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
