/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.SchemaExtensionDefinition;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.errors.MissingTypeError;
import graphql.schema.idl.errors.OperationRedefinitionError;
import graphql.schema.idl.errors.OperationTypesMustBeObjects;
import graphql.schema.idl.errors.QueryOperationMissingError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

@Internal
public class SchemaExtensionsChecker {
    static Map<String, OperationTypeDefinition> gatherOperationDefs(TypeDefinitionRegistry typeRegistry) {
        ArrayList<GraphQLError> noErrors = new ArrayList<GraphQLError>();
        Map<String, OperationTypeDefinition> operationTypeDefinitionMap = SchemaExtensionsChecker.gatherOperationDefs(noErrors, typeRegistry.schemaDefinition().orElse(null), typeRegistry.getSchemaExtensionDefinitions());
        Assert.assertTrue(noErrors.isEmpty(), () -> "If you call this method it MUST have previously been error checked");
        return operationTypeDefinitionMap;
    }

    static Map<String, OperationTypeDefinition> gatherOperationDefs(List<GraphQLError> errors, SchemaDefinition schema, List<SchemaExtensionDefinition> schemaExtensionDefinitions) {
        LinkedHashMap<String, OperationTypeDefinition> operationDefs = new LinkedHashMap<String, OperationTypeDefinition>();
        if (schema != null) {
            SchemaExtensionsChecker.defineOperationDefs(errors, schema.getOperationTypeDefinitions(), operationDefs);
        }
        for (SchemaExtensionDefinition schemaExtensionDefinition : schemaExtensionDefinitions) {
            SchemaExtensionsChecker.defineOperationDefs(errors, schemaExtensionDefinition.getOperationTypeDefinitions(), operationDefs);
        }
        return operationDefs;
    }

    static void defineOperationDefs(List<GraphQLError> errors, Collection<OperationTypeDefinition> newOperationDefs, Map<String, OperationTypeDefinition> existingOperationDefs) {
        for (OperationTypeDefinition operationTypeDefinition : newOperationDefs) {
            OperationTypeDefinition oldEntry = existingOperationDefs.get(operationTypeDefinition.getName());
            if (oldEntry != null) {
                errors.add(new OperationRedefinitionError(oldEntry, operationTypeDefinition));
                continue;
            }
            existingOperationDefs.put(operationTypeDefinition.getName(), operationTypeDefinition);
        }
    }

    static List<OperationTypeDefinition> checkSchemaInvariants(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        Optional<TypeDefinition> queryType;
        SchemaDefinition schemaDef = typeRegistry.schemaDefinition().orElse(null);
        Map<String, OperationTypeDefinition> operationTypeMap = SchemaExtensionsChecker.gatherOperationDefs(errors, schemaDef, typeRegistry.getSchemaExtensionDefinitions());
        ArrayList<OperationTypeDefinition> operationTypeDefinitions = new ArrayList<OperationTypeDefinition>(operationTypeMap.values());
        operationTypeDefinitions.forEach(SchemaExtensionsChecker.checkOperationTypesExist(typeRegistry, errors));
        operationTypeDefinitions.forEach(SchemaExtensionsChecker.checkOperationTypesAreObjects(typeRegistry, errors));
        Optional<OperationTypeDefinition> query = operationTypeDefinitions.stream().filter(op -> "query".equals(op.getName())).findFirst();
        if (!query.isPresent() && !(queryType = typeRegistry.getType("Query")).isPresent()) {
            errors.add(new QueryOperationMissingError());
        }
        return operationTypeDefinitions;
    }

    static List<Directive> gatherSchemaDirectives(TypeDefinitionRegistry typeRegistry) {
        ArrayList<GraphQLError> noErrors = new ArrayList<GraphQLError>();
        List<Directive> directiveList = SchemaExtensionsChecker.gatherSchemaDirectives(typeRegistry, noErrors);
        Assert.assertTrue(noErrors.isEmpty(), () -> "If you call this method it MUST have previously been error checked");
        return directiveList;
    }

    static List<Directive> gatherSchemaDirectives(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors) {
        ArrayList<Directive> directiveList = new ArrayList<Directive>();
        SchemaDefinition schemaDefinition = typeRegistry.schemaDefinition().orElse(null);
        if (schemaDefinition != null) {
            directiveList.addAll(schemaDefinition.getDirectives());
        }
        for (SchemaExtensionDefinition schemaExtensionDefinition : typeRegistry.getSchemaExtensionDefinitions()) {
            directiveList.addAll(schemaExtensionDefinition.getDirectives());
        }
        return directiveList;
    }

    private static Consumer<OperationTypeDefinition> checkOperationTypesExist(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors) {
        return op -> {
            TypeName unwrapped = TypeInfo.typeInfo(op.getTypeName()).getTypeName();
            if (!typeRegistry.hasType(unwrapped)) {
                errors.add(new MissingTypeError("operation", (Node)op, op.getName(), unwrapped));
            }
        };
    }

    private static Consumer<OperationTypeDefinition> checkOperationTypesAreObjects(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors) {
        return op -> {
            TypeName queryType = op.getTypeName();
            Optional<TypeDefinition> type = typeRegistry.getType(queryType);
            type.ifPresent(typeDef -> {
                if (!(typeDef instanceof ObjectTypeDefinition)) {
                    errors.add(new OperationTypesMustBeObjects((OperationTypeDefinition)op));
                }
            });
        };
    }
}

