/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.consul;

import com.google.common.base.Strings;
import com.orbitz.consul.AgentClient;
import com.orbitz.consul.Consul;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.cache.ServiceHealthCache;
import com.orbitz.consul.cache.ServiceHealthKey;
import com.orbitz.consul.model.agent.ImmutableRegistration;
import com.orbitz.consul.model.agent.Registration;
import com.orbitz.consul.model.health.ServiceHealth;
import com.orbitz.consul.option.QueryOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.cluster.plugin.consul.ClusterModuleConsulConfig;
import org.apache.skywalking.oap.server.core.cluster.ClusterCoordinator;
import org.apache.skywalking.oap.server.core.cluster.ClusterHealthStatus;
import org.apache.skywalking.oap.server.core.cluster.OAPNodeChecker;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceQueryException;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulCoordinator
extends ClusterCoordinator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsulCoordinator.class);
    private final ModuleDefineHolder manager;
    private final Consul client;
    private final String serviceName;
    private final ClusterModuleConsulConfig config;
    private volatile Address selfAddress;
    private HealthCheckMetrics healthChecker;

    public ConsulCoordinator(ModuleDefineHolder manager, ClusterModuleConsulConfig config, Consul client) {
        this.manager = manager;
        this.config = config;
        this.client = client;
        this.serviceName = config.getServiceName();
    }

    public List<RemoteInstance> queryRemoteNodes() {
        ArrayList<RemoteInstance> remoteInstances = new ArrayList<RemoteInstance>();
        try {
            ClusterHealthStatus healthStatus;
            HealthClient healthClient = this.client.healthClient();
            List nodes = (List)healthClient.getHealthyServiceInstances(this.serviceName).getResponse();
            if (CollectionUtils.isNotEmpty((List)nodes)) {
                nodes.forEach(node -> {
                    if (!Strings.isNullOrEmpty((String)node.getService().getAddress())) {
                        Address address = new Address(node.getService().getAddress(), node.getService().getPort(), false);
                        if (address.equals((Object)this.selfAddress)) {
                            address.setSelf(true);
                        }
                        remoteInstances.add(new RemoteInstance(address));
                    }
                });
            }
            if ((healthStatus = OAPNodeChecker.isHealth(remoteInstances)).isHealth()) {
                this.healthChecker.health();
            } else {
                this.healthChecker.unHealth(healthStatus.getReason());
            }
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceQueryException(e.getMessage());
        }
        if (log.isDebugEnabled()) {
            remoteInstances.forEach(instance -> log.debug("Cosule cluster instance: {}", instance));
        }
        return remoteInstances;
    }

    public void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        if (this.needUsingInternalAddr()) {
            remoteInstance = new RemoteInstance(new Address(this.config.getInternalComHost(), this.config.getInternalComPort(), true));
        }
        this.selfAddress = remoteInstance.getAddress();
        try {
            AgentClient agentClient = this.client.agentClient();
            ImmutableRegistration registration = ImmutableRegistration.builder().id(remoteInstance.getAddress().toString()).name(this.serviceName).address(remoteInstance.getAddress().getHost()).port(remoteInstance.getAddress().getPort()).check(Registration.RegCheck.grpc((String)(remoteInstance.getAddress().getHost() + ":" + remoteInstance.getAddress().getPort()), (long)5L)).build();
            agentClient.register((Registration)registration);
            this.healthChecker.health();
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceRegisterException(e.getMessage());
        }
    }

    private void initHealthChecker() {
        if (this.healthChecker == null) {
            MetricsCreator metricCreator = (MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class);
            this.healthChecker = metricCreator.createHealthCheckerGauge("cluster_consul", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        }
    }

    private boolean needUsingInternalAddr() {
        return !Strings.isNullOrEmpty((String)this.config.getInternalComHost()) && this.config.getInternalComPort() > 0;
    }

    private RemoteInstance buildRemoteInstance(String host, int port) {
        Address address = new Address(host, port, false);
        if (address.equals((Object)this.selfAddress)) {
            address.setSelf(true);
        }
        return new RemoteInstance(address);
    }

    private void checkHealth(List<RemoteInstance> remoteInstances) {
        ClusterHealthStatus healthStatus = OAPNodeChecker.isHealth(remoteInstances);
        if (healthStatus.isHealth()) {
            this.healthChecker.health();
        } else {
            this.healthChecker.unHealth(healthStatus.getReason());
        }
    }

    public void start() {
        this.initHealthChecker();
        ServiceHealthCache svHealth = ServiceHealthCache.newCache((HealthClient)this.client.healthClient(), (String)this.serviceName, (boolean)true, (QueryOptions)QueryOptions.BLANK, (int)5);
        svHealth.addListener((ConsulCache.Listener)new ConsulEventListener());
        svHealth.start();
    }

    class ConsulEventListener
    implements ConsulCache.Listener<ServiceHealthKey, ServiceHealth> {
        ConsulEventListener() {
        }

        public void notify(Map<ServiceHealthKey, ServiceHealth> newValues) {
            try {
                if (newValues.size() > 0) {
                    ArrayList<RemoteInstance> remoteInstances = new ArrayList<RemoteInstance>(newValues.size());
                    newValues.values().forEach(serviceHealth -> {
                        if (StringUtil.isNotBlank((String)serviceHealth.getService().getAddress())) {
                            RemoteInstance remoteInstance = ConsulCoordinator.this.buildRemoteInstance(serviceHealth.getService().getAddress(), serviceHealth.getService().getPort());
                            remoteInstances.add(remoteInstance);
                        }
                    });
                    ConsulCoordinator.this.checkHealth(remoteInstances);
                    ConsulCoordinator.this.notifyWatchers(remoteInstances);
                }
            }
            catch (Throwable e) {
                ConsulCoordinator.this.healthChecker.unHealth(e);
                log.error("Failed to notify and update remote instances.", e);
            }
        }
    }
}

