/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.DefaultHttpResponseDuplicator;
import com.linecorp.armeria.common.DeferredHttpResponse;
import com.linecorp.armeria.common.FixedHttpResponse;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMessage;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponseBuilder;
import com.linecorp.armeria.common.HttpResponseDuplicator;
import com.linecorp.armeria.common.HttpResponseUtil;
import com.linecorp.armeria.common.HttpResponseWriter;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.PublisherBasedHttpResponse;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SplitHttpResponse;
import com.linecorp.armeria.common.StreamMessageBasedHttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.StreamTimeoutMode;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.AbortedHttpResponse;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.DefaultHttpResponse;
import com.linecorp.armeria.internal.common.DefaultSplitHttpResponse;
import com.linecorp.armeria.internal.common.JacksonUtil;
import com.linecorp.armeria.internal.common.stream.RecoverableStreamMessage;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public interface HttpResponse
extends HttpMessage,
Response {
    public static HttpResponseWriter streaming() {
        return new DefaultHttpResponse();
    }

    @Deprecated
    public static HttpResponse from(CompletionStage<? extends HttpResponse> stage) {
        return HttpResponse.of(stage);
    }

    @Deprecated
    public static HttpResponse from(CompletableFuture<? extends HttpResponse> future) {
        return HttpResponse.of(future);
    }

    @Deprecated
    public static HttpResponse from(CompletionStage<? extends HttpResponse> stage, EventExecutor subscriberExecutor) {
        return HttpResponse.of(stage, subscriberExecutor);
    }

    @Deprecated
    public static HttpResponse from(Supplier<? extends HttpResponse> responseSupplier, Executor executor) {
        return HttpResponse.of(responseSupplier, executor);
    }

    public static HttpResponse delayed(AggregatedHttpResponse response, Duration delay) {
        Objects.requireNonNull(response, "response");
        Objects.requireNonNull(delay, "delay");
        return HttpResponse.delayed(response.toHttpResponse(), delay);
    }

    public static HttpResponse delayed(AggregatedHttpResponse response, Duration delay, ScheduledExecutorService executor) {
        Objects.requireNonNull(response, "response");
        Objects.requireNonNull(delay, "delay");
        Objects.requireNonNull(executor, "executor");
        return HttpResponse.delayed(response.toHttpResponse(), delay, executor);
    }

    public static HttpResponse delayed(HttpResponse response, Duration delay) {
        Objects.requireNonNull(response, "response");
        Objects.requireNonNull(delay, "delay");
        return HttpResponse.delayed(() -> response, delay);
    }

    public static HttpResponse delayed(HttpResponse response, Duration delay, ScheduledExecutorService executor) {
        Objects.requireNonNull(response, "response");
        Objects.requireNonNull(delay, "delay");
        Objects.requireNonNull(executor, "executor");
        return HttpResponse.delayed(() -> response, delay, executor);
    }

    public static HttpResponse delayed(Supplier<? extends HttpResponse> responseSupplier, Duration delay) {
        Objects.requireNonNull(responseSupplier, "responseSupplier");
        Objects.requireNonNull(delay, "delay");
        EventLoop executor = RequestContext.mapCurrent(RequestContext::eventLoop, () -> ((EventLoopGroup)CommonPools.workerGroup()).next());
        if (!1.$assertionsDisabled && executor == null) {
            throw new AssertionError();
        }
        return HttpResponse.delayed(responseSupplier, delay, (ScheduledExecutorService)executor);
    }

    public static HttpResponse delayed(Supplier<? extends HttpResponse> responseSupplier, Duration delay, ScheduledExecutorService executor) {
        Objects.requireNonNull(responseSupplier, "responseSupplier");
        Objects.requireNonNull(delay, "delay");
        Objects.requireNonNull(executor, "executor");
        DeferredHttpResponse res = new DeferredHttpResponse();
        executor.schedule(() -> {
            try {
                res.delegate((HttpResponse)responseSupplier.get());
            }
            catch (Throwable ex) {
                res.abort(ex);
            }
        }, delay.toNanos(), TimeUnit.NANOSECONDS);
        return res;
    }

    public static HttpResponse of(int statusCode) {
        return HttpResponse.of(HttpStatus.valueOf(statusCode));
    }

    public static HttpResponse of(HttpStatus status) {
        Objects.requireNonNull(status, "status");
        Preconditions.checkArgument(!status.isInformational(), "status: %s (expected: a non-1xx status)", (Object)status);
        if (status.isContentAlwaysEmpty()) {
            return new FixedHttpResponse.OneElementFixedHttpResponse(ResponseHeaders.builder(status).endOfStream(true).build());
        }
        return HttpResponse.of(status, MediaType.PLAIN_TEXT_UTF_8, status.toHttpData());
    }

    public static HttpResponse of(HttpStatus status, MediaType mediaType, CharSequence content) {
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return HttpResponse.of(status, mediaType, HttpData.of(mediaType.charset(StandardCharsets.UTF_8), content));
    }

    public static HttpResponse of(HttpStatus status, MediaType mediaType, String content) {
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return HttpResponse.of(status, mediaType, HttpData.of(mediaType.charset(StandardCharsets.UTF_8), content));
    }

    public static HttpResponse of(String content) {
        return HttpResponse.of(HttpStatus.OK, MediaType.PLAIN_TEXT_UTF_8, content);
    }

    @FormatMethod
    public static HttpResponse of(@FormatString String format, Object ... args) {
        return HttpResponse.of(HttpStatus.OK, MediaType.PLAIN_TEXT_UTF_8, format, args);
    }

    public static HttpResponse of(MediaType mediaType, String content) {
        return HttpResponse.of(HttpStatus.OK, mediaType, content);
    }

    @FormatMethod
    public static HttpResponse of(MediaType mediaType, @FormatString String format, Object ... args) {
        return HttpResponse.of(HttpStatus.OK, mediaType, format, args);
    }

    @FormatMethod
    public static HttpResponse of(HttpStatus status, MediaType mediaType, @FormatString String format, Object ... args) {
        Objects.requireNonNull(mediaType, "mediaType");
        return HttpResponse.of(status, mediaType, HttpData.of(mediaType.charset(StandardCharsets.UTF_8), format, args));
    }

    public static HttpResponse of(HttpStatus status, MediaType mediaType, byte[] content) {
        Objects.requireNonNull(content, "content");
        return HttpResponse.of(status, mediaType, HttpData.wrap(content));
    }

    public static HttpResponse of(HttpStatus status, MediaType mediaType, HttpData content) {
        return HttpResponse.of(status, mediaType, content, HttpHeaders.of());
    }

    public static HttpResponse of(HttpStatus status, MediaType mediaType, HttpData content, HttpHeaders trailers) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        ResponseHeaders headers = ResponseHeaders.builder(status).contentType(mediaType).build();
        return HttpResponse.of(headers, content, trailers);
    }

    public static HttpResponse of(ResponseHeaders headers) {
        return HttpResponse.of(headers, HttpData.empty());
    }

    public static HttpResponse of(ResponseHeaders headers, HttpData content) {
        return HttpResponse.of(headers, content, HttpHeaders.of());
    }

    public static HttpResponse of(ResponseHeaders headers, HttpData content, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        HttpStatus status = headers.status();
        Preconditions.checkArgument(!status.isInformational(), "status: %s (expected: a non-1xx status)", (Object)status);
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailers, "trailers");
        if (headers.status().isContentAlwaysEmpty() && !content.isEmpty()) {
            HttpResponseUtil.httpResponseUtilLogger.debug("Non-empty content found with an empty status: {}, content length: {}", (Object)headers.status(), (Object)content.length());
            content.close();
            content = HttpData.empty();
        }
        ResponseHeaders newHeaders = ArmeriaHttpUtil.maybeUpdateContentLengthAndEndOfStream(headers, content, trailers, false);
        boolean contentIsEmpty = content.isEmpty();
        if (contentIsEmpty) {
            content.close();
            if (trailers.isEmpty()) {
                return new FixedHttpResponse.OneElementFixedHttpResponse(newHeaders);
            }
            return new FixedHttpResponse.TwoElementFixedHttpResponse(newHeaders, trailers);
        }
        if (trailers.isEmpty()) {
            return new FixedHttpResponse.TwoElementFixedHttpResponse(newHeaders, content);
        }
        return new FixedHttpResponse.ThreeElementFixedHttpResponse(newHeaders, content, trailers);
    }

    public static HttpResponse of(HttpObject ... objs) {
        return new FixedHttpResponse.RegularFixedHttpResponse(objs);
    }

    public static HttpResponse of(Publisher<? extends HttpObject> publisher) {
        Objects.requireNonNull(publisher, "publisher");
        if (publisher instanceof HttpResponse) {
            return (HttpResponse)publisher;
        }
        if (publisher instanceof StreamMessage) {
            return new StreamMessageBasedHttpResponse((StreamMessage)publisher);
        }
        return new PublisherBasedHttpResponse(publisher);
    }

    public static HttpResponse of(ResponseHeaders headers, Publisher<? extends HttpObject> publisher) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(publisher, "publisher");
        return PublisherBasedHttpResponse.from(headers, publisher);
    }

    public static HttpResponse of(ResponseHeaders headers, Publisher<? extends HttpData> publisher, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(publisher, "publisher");
        Objects.requireNonNull(trailers, "trailers");
        return HttpResponse.of(headers, publisher, (Throwable ignored) -> trailers);
    }

    public static HttpResponse of(ResponseHeaders headers, Publisher<? extends HttpData> publisher, Function<@Nullable Throwable, HttpHeaders> trailersFunction) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(publisher, "publisher");
        Objects.requireNonNull(trailersFunction, "trailersFunction");
        return PublisherBasedHttpResponse.from(headers, publisher, trailersFunction);
    }

    public static HttpResponse of(CompletableFuture<? extends HttpResponse> future) {
        Objects.requireNonNull(future, "future");
        return HttpResponseUtil.createHttpResponseFrom(future);
    }

    public static HttpResponse of(CompletionStage<? extends HttpResponse> stage) {
        Objects.requireNonNull(stage, "stage");
        DeferredHttpResponse res = new DeferredHttpResponse();
        res.delegateWhenComplete(stage);
        return res;
    }

    public static HttpResponse of(CompletionStage<? extends HttpResponse> stage, EventExecutor subscriberExecutor) {
        Objects.requireNonNull(stage, "stage");
        Objects.requireNonNull(subscriberExecutor, "subscriberExecutor");
        DeferredHttpResponse res = new DeferredHttpResponse(subscriberExecutor);
        res.delegateWhenComplete(stage);
        return res;
    }

    public static HttpResponse of(Supplier<? extends HttpResponse> responseSupplier, Executor executor) {
        Objects.requireNonNull(responseSupplier, "responseSupplier");
        Objects.requireNonNull(executor, "executor");
        DeferredHttpResponse res = new DeferredHttpResponse();
        executor.execute(() -> {
            try {
                res.delegate((HttpResponse)responseSupplier.get());
            }
            catch (Throwable ex) {
                res.abort(ex);
            }
        });
        return res;
    }

    public static HttpResponse ofJson(Object content) {
        return HttpResponse.ofJson(HttpStatus.OK, content);
    }

    public static HttpResponse ofJson(HttpStatus status, Object content) {
        Objects.requireNonNull(status, "status");
        ResponseHeaders headers = ResponseHeaders.builder(status).contentType(MediaType.JSON).build();
        return HttpResponse.ofJson(headers, content);
    }

    public static HttpResponse ofJson(MediaType contentType, Object content) {
        return HttpResponse.ofJson(HttpStatus.OK, contentType, content);
    }

    public static HttpResponse ofJson(HttpStatus status, MediaType contentType, Object content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(contentType, "contentType");
        Preconditions.checkArgument(contentType.isJson(), "contentType: %s (expected: the subtype is 'json' or ends with '+json'.", (Object)contentType);
        ResponseHeaders headers = ResponseHeaders.builder(status).contentType(contentType).build();
        return HttpResponse.ofJson(headers, content);
    }

    public static HttpResponse ofJson(ResponseHeaders headers, Object content) {
        HttpData httpData;
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        try {
            httpData = HttpData.wrap(JacksonUtil.writeValueAsBytes(content));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e.toString(), e);
        }
        MediaType contentType = headers.contentType();
        if (contentType != null && contentType.isJson()) {
            return HttpResponse.of(headers, httpData);
        }
        ResponseHeaders newHeaders = headers.toBuilder().contentType(MediaType.JSON).build();
        return HttpResponse.of(newHeaders, httpData);
    }

    public static HttpResponse ofRedirect(HttpStatus redirectStatus, String location) {
        Objects.requireNonNull(redirectStatus, "redirectStatus");
        Objects.requireNonNull(location, "location");
        if (redirectStatus.compareTo(HttpStatus.MULTIPLE_CHOICES) < 0 || redirectStatus.compareTo(HttpStatus.TEMPORARY_REDIRECT) > 0) {
            throw new IllegalArgumentException("redirectStatus: " + redirectStatus + " (expected: 300 .. 307)");
        }
        return HttpResponse.of(ResponseHeaders.of(redirectStatus, (CharSequence)HttpHeaderNames.LOCATION, location));
    }

    public static HttpResponse ofRedirect(HttpStatus redirectStatus, String format, Object ... args) {
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        return HttpResponse.ofRedirect(redirectStatus, String.format(format, args));
    }

    public static HttpResponse ofRedirect(String location) {
        return HttpResponse.ofRedirect(HttpStatus.TEMPORARY_REDIRECT, location);
    }

    public static HttpResponse ofRedirect(String format, Object ... args) {
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        return HttpResponse.ofRedirect(HttpStatus.TEMPORARY_REDIRECT, String.format(format, args));
    }

    public static HttpResponse ofFailure(Throwable cause) {
        return new AbortedHttpResponse(cause);
    }

    @UnstableApi
    public static HttpResponseBuilder builder() {
        return new HttpResponseBuilder();
    }

    @Override
    public CompletableFuture<Void> whenComplete();

    @UnstableApi
    public CompletableFuture<AggregatedHttpResponse> aggregate(AggregationOptions var1);

    default public CompletableFuture<AggregatedHttpResponse> aggregate() {
        return this.aggregate(this.defaultSubscriberExecutor());
    }

    default public CompletableFuture<AggregatedHttpResponse> aggregate(EventExecutor executor) {
        Objects.requireNonNull(executor, "executor");
        return this.aggregate(AggregationOptions.builder().executor(executor).cacheResult(true).build());
    }

    @Deprecated
    @UnstableApi
    default public CompletableFuture<AggregatedHttpResponse> aggregateWithPooledObjects(ByteBufAllocator alloc) {
        return this.aggregateWithPooledObjects(this.defaultSubscriberExecutor(), alloc);
    }

    @Deprecated
    default public CompletableFuture<AggregatedHttpResponse> aggregateWithPooledObjects(EventExecutor executor, ByteBufAllocator alloc) {
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(alloc, "alloc");
        return this.aggregate(AggregationOptions.builder().executor(executor).usePooledObjects(alloc).build());
    }

    default public HttpResponseDuplicator toDuplicator() {
        return this.toDuplicator(Flags.defaultMaxResponseLength());
    }

    default public HttpResponseDuplicator toDuplicator(EventExecutor executor) {
        return this.toDuplicator(executor, Flags.defaultMaxResponseLength());
    }

    default public HttpResponseDuplicator toDuplicator(long maxResponseLength) {
        return this.toDuplicator(this.defaultSubscriberExecutor(), maxResponseLength);
    }

    default public HttpResponseDuplicator toDuplicator(EventExecutor executor, long maxResponseLength) {
        Objects.requireNonNull(executor, "executor");
        return new DefaultHttpResponseDuplicator(this, executor, maxResponseLength);
    }

    @CheckReturnValue
    default public SplitHttpResponse split() {
        return this.split(this.defaultSubscriberExecutor());
    }

    @CheckReturnValue
    default public SplitHttpResponse split(EventExecutor executor) {
        return new DefaultSplitHttpResponse(this, executor);
    }

    default public HttpResponse mapInformational(Function<? super ResponseHeaders, ? extends ResponseHeaders> function) {
        Objects.requireNonNull(function, "function");
        StreamMessage<HttpObject> stream = this.map(obj -> {
            ResponseHeaders headers;
            if (obj instanceof ResponseHeaders && (headers = (ResponseHeaders)obj).status().isInformational()) {
                return (HttpObject)function.apply(headers);
            }
            return obj;
        });
        return HttpResponse.of(stream);
    }

    default public HttpResponse mapHeaders(Function<? super ResponseHeaders, ? extends ResponseHeaders> function) {
        Objects.requireNonNull(function, "function");
        StreamMessage<HttpObject> stream = this.map(obj -> {
            ResponseHeaders headers;
            if (obj instanceof ResponseHeaders && !(headers = (ResponseHeaders)obj).status().isInformational()) {
                return (HttpObject)function.apply(headers);
            }
            return obj;
        });
        return HttpResponse.of(stream);
    }

    @Override
    default public HttpResponse mapData(Function<? super HttpData, ? extends HttpData> function) {
        Objects.requireNonNull(function, "function");
        StreamMessage<HttpObject> stream = this.map(obj -> obj instanceof HttpData ? (HttpObject)function.apply((HttpData)obj) : obj);
        return HttpResponse.of(stream);
    }

    @Override
    default public HttpResponse mapTrailers(Function<? super HttpHeaders, ? extends HttpHeaders> function) {
        Objects.requireNonNull(function, "function");
        StreamMessage<HttpObject> stream = this.map(obj -> {
            if (obj instanceof HttpHeaders && !(obj instanceof ResponseHeaders)) {
                return (HttpObject)function.apply((HttpHeaders)obj);
            }
            return obj;
        });
        return HttpResponse.of(stream);
    }

    default public HttpResponse mapError(Function<? super Throwable, ? extends Throwable> function) {
        Objects.requireNonNull(function, "function");
        return HttpResponse.of(HttpMessage.super.mapError(function));
    }

    @UnstableApi
    default public HttpResponse peekHeaders(Consumer<? super ResponseHeaders> action) {
        Objects.requireNonNull(action, "action");
        StreamMessage stream = this.peek(headers -> {
            if (!headers.status().isInformational()) {
                action.accept((ResponseHeaders)headers);
            }
        }, ResponseHeaders.class);
        return HttpResponse.of(stream);
    }

    @Override
    @UnstableApi
    default public HttpResponse peekData(Consumer<? super HttpData> action) {
        Objects.requireNonNull(action, "action");
        StreamMessage stream = this.peek(action, HttpData.class);
        return HttpResponse.of(stream);
    }

    @Override
    @UnstableApi
    default public HttpResponse peekTrailers(Consumer<? super HttpHeaders> action) {
        Objects.requireNonNull(action, "action");
        StreamMessage stream = this.peek(obj -> {
            if (!(obj instanceof ResponseHeaders)) {
                action.accept((HttpHeaders)obj);
            }
        }, HttpHeaders.class);
        return HttpResponse.of(stream);
    }

    @UnstableApi
    default public HttpResponse peekError(Consumer<? super Throwable> action) {
        Objects.requireNonNull(action, "action");
        return HttpResponse.of(HttpMessage.super.peekError(action));
    }

    default public HttpResponse recover(Function<? super Throwable, ? extends HttpResponse> function) {
        Objects.requireNonNull(function, "function");
        return HttpResponse.of(new RecoverableStreamMessage<HttpObject>(this, function, false));
    }

    @UnstableApi
    default public <T extends Throwable> HttpResponse recover(Class<T> causeClass, Function<? super T, ? extends HttpResponse> function) {
        Objects.requireNonNull(causeClass, "causeClass");
        Objects.requireNonNull(function, "function");
        return this.recover(cause -> {
            if (!causeClass.isInstance(cause)) {
                return (HttpResponse)Exceptions.throwUnsafely(cause);
            }
            try {
                HttpResponse recoveredResponse = (HttpResponse)function.apply(cause);
                Objects.requireNonNull(recoveredResponse, "recoveredResponse");
                return recoveredResponse;
            }
            catch (Throwable t) {
                return (HttpResponse)Exceptions.throwUnsafely(t);
            }
        });
    }

    default public HttpResponse subscribeOn(EventExecutor eventExecutor) {
        return HttpResponse.of(HttpMessage.super.subscribeOn(eventExecutor));
    }

    @UnstableApi
    default public HttpResponse timeout(Duration timeoutDuration) {
        return this.timeout(timeoutDuration, StreamTimeoutMode.UNTIL_NEXT);
    }

    @UnstableApi
    default public HttpResponse timeout(Duration timeoutDuration, StreamTimeoutMode timeoutMode) {
        return HttpResponse.of(HttpMessage.super.timeout(timeoutDuration, timeoutMode));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

