/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model;

public enum State {
    PASS("pass", "passing"),
    WARN("warn", "warning"),
    FAIL("fail", "critical"),
    ANY("any", "any"),
    UNKNOWN("unknown", "unknown");

    private final String path;
    private final String name;

    private State(String path, String name) {
        this.path = path;
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public static State fromName(String name) {
        for (State state : State.values()) {
            if (!state.getName().equals(name)) continue;
            return state;
        }
        throw new IllegalArgumentException("Invalid State name");
    }
}

