/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.PropertyPlaceholderHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigLoaderUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(YamlConfigLoaderUtils.class);

    public static void replacePropertyAndLog(String propertyName, Object propertyValue, Properties target, Object providerName, Yaml yaml) {
        String valueString = PropertyPlaceholderHelper.INSTANCE.replacePlaceholders(String.valueOf(propertyValue), target);
        if (valueString.trim().length() == 0) {
            target.replace(propertyName, valueString);
            log.info("Provider={} config={} has been set as an empty string", providerName, (Object)propertyName);
        } else {
            Object replaceValue = YamlConfigLoaderUtils.convertValueString(valueString, yaml);
            if (replaceValue != null) {
                target.replace(propertyName, replaceValue);
            }
        }
    }

    public static Object convertValueString(String valueString, Yaml yaml) {
        try {
            Object replaceValue = yaml.load(valueString);
            if (replaceValue instanceof String || replaceValue instanceof Integer || replaceValue instanceof Long || replaceValue instanceof Boolean || replaceValue instanceof ArrayList) {
                return replaceValue;
            }
            return valueString;
        }
        catch (Exception e) {
            log.warn("yaml convert value type error, use origin values string. valueString={}", (Object)valueString, (Object)e);
            return valueString;
        }
    }

    public static void copyProperties(Object dest, Properties src, String moduleName, String providerName) throws IllegalAccessException {
        if (dest == null) {
            return;
        }
        Enumeration<?> propertyNames = src.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            Class<?> destClass = dest.getClass();
            try {
                Field field = YamlConfigLoaderUtils.getDeclaredField(destClass, propertyName);
                field.setAccessible(true);
                field.set(dest, src.get(propertyName));
            }
            catch (NoSuchFieldException e) {
                log.warn(propertyName + " setting is not supported in " + providerName + " provider of " + moduleName + " module");
            }
        }
    }

    public static Field getDeclaredField(Class<?> destClass, String fieldName) throws NoSuchFieldException {
        if (destClass != null) {
            Field[] fields;
            for (Field field : fields = destClass.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
            return YamlConfigLoaderUtils.getDeclaredField(destClass.getSuperclass(), fieldName);
        }
        throw new NoSuchFieldException();
    }
}

